/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class CustomElasticsearchHealthIndicator
implements HealthIndicator {
    private final RestHighLevelClient elasticsearchClient;

    public CustomElasticsearchHealthIndicator(RestHighLevelClient elasticsearchClient) {
        this.elasticsearchClient = elasticsearchClient;
    }

    public Health health() {
        try {
            ClusterHealthResponse response = this.elasticsearchClient.cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT);
            return Health.up().withDetail("cluster_name", (Object)response.getClusterName()).withDetail("status", (Object)response.getStatus()).withDetail("number_of_nodes", (Object)response.getNumberOfNodes()).build();
        }
        catch (Exception e) {
            return Health.down((Throwable)e).build();
        }
    }
}

