/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config;

import feign.Client;
import feign.hc5.ApacheHttp5Client;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.clientconfig.HttpClient5FeignConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ApacheHttp5Client.class})
@ConditionalOnMissingBean(value={CloseableHttpClient.class})
@ConditionalOnProperty(value={"feign.httpclient.hc5.enabled"}, havingValue="true")
@Import(value={HttpClient5FeignConfiguration.class})
public class HttpClient5FeignConfig {
    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client feignClient(CloseableHttpClient httpClient5) {
        return new ApacheHttp5Client((HttpClient)httpClient5);
    }
}

