/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.esquery.filter;

import com.arms.egovframework.javaservice.esframework.esquery.filter.Filter;
import java.time.LocalDate;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;

public class RangeQueryFilter
extends Filter<RangeQueryBuilder> {
    private RangeQueryBuilder rangeQueryBuilder;

    private RangeQueryFilter(String name) {
        this.rangeQueryBuilder = QueryBuilders.rangeQuery((String)name);
    }

    public static RangeQueryFilter of(String name) {
        return new RangeQueryFilter(name);
    }

    public RangeQueryFilter lt(LocalDate lt) {
        if (lt != null) {
            this.rangeQueryBuilder.lt((Object)lt);
        }
        if (lt == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lt(String lt) {
        String lessThan = this.checkEmptyThenNull(lt);
        if (lessThan != null) {
            this.rangeQueryBuilder.lt((Object)lessThan);
        }
        if (lessThan == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lte(LocalDate lte) {
        if (lte != null) {
            this.rangeQueryBuilder.lte((Object)lte);
        }
        if (lte == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lte(String lte) {
        String lessThanOrEqualTo = this.checkEmptyThenNull(lte);
        if (lessThanOrEqualTo != null) {
            this.rangeQueryBuilder.lte((Object)lessThanOrEqualTo);
        }
        if (lessThanOrEqualTo == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gt(LocalDate gt) {
        if (gt != null) {
            this.rangeQueryBuilder.gt((Object)gt);
        }
        if (gt == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gt(String gt) {
        String greaterThan = this.checkEmptyThenNull(gt);
        if (greaterThan != null) {
            this.rangeQueryBuilder.gt((Object)greaterThan);
        }
        if (greaterThan == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gte(LocalDate gte) {
        if (gte != null) {
            this.rangeQueryBuilder.gte((Object)gte);
        }
        if (gte == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gte(String gte) {
        String greaterThanOrEqualTo = this.checkEmptyThenNull(gte);
        if (greaterThanOrEqualTo != null) {
            this.rangeQueryBuilder.gte((Object)greaterThanOrEqualTo);
        }
        if (greaterThanOrEqualTo == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter from(LocalDate from) {
        if (from != null) {
            this.rangeQueryBuilder.from((Object)from);
        }
        if (from == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter from(String from) {
        String fromParam = this.checkEmptyThenNull(from);
        if (fromParam != null) {
            this.rangeQueryBuilder.from((Object)fromParam);
        }
        if (fromParam == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter to(LocalDate to) {
        if (to != null) {
            this.rangeQueryBuilder.to((Object)to);
        }
        if (to == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter to(String to) {
        String toParam = this.checkEmptyThenNull(to);
        if (toParam != null) {
            this.rangeQueryBuilder.to((Object)toParam);
        }
        if (toParam == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter betweenDate(String from, String to) {
        this.greaterThanOrEqualTo(from, to);
        this.lessThanOrEqualTo(from, to);
        if (from != null && to != null) {
            this.from(from).to(to);
        }
        if (from == null && to == null) {
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    private void greaterThanOrEqualTo(String from, String to) {
        if (from != null && to == null) {
            String greaterThanOrEqualTo = this.checkEmptyThenNull(from);
            if (greaterThanOrEqualTo != null) {
                this.rangeQueryBuilder.gte((Object)greaterThanOrEqualTo);
            }
            if (greaterThanOrEqualTo == null) {
                this.rangeQueryBuilder = null;
            }
        }
    }

    private void lessThanOrEqualTo(String from, String to) {
        if (from == null && to != null) {
            String lessThanOrEqualTo = this.checkEmptyThenNull(to);
            if (lessThanOrEqualTo != null) {
                this.rangeQueryBuilder.lte((Object)lessThanOrEqualTo);
            }
            if (lessThanOrEqualTo == null) {
                this.rangeQueryBuilder = null;
            }
        }
    }

    public String checkEmptyThenNull(String str) {
        if (str != null && str.isEmpty()) {
            return null;
        }
        return str;
    }

    @Override
    public AbstractQueryBuilder<RangeQueryBuilder> abstractQueryBuilder() {
        return this.rangeQueryBuilder;
    }
}

