package com.arms.api.util.external_communicate;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "backend-core", url = "${arms.backend-core.url}")
public interface BackendCoreCommunicator {

    @GetMapping("/arms/scheduler/pdservice/reqstatus/updateFromES")
    String updateReqStatusFromElasticsearch();

    @GetMapping("/arms/scheduler/pdservice/reqstatus/recreateFailedReqIssue")
    void retryFailedReqStatusCreationToElasticsearch();

    @GetMapping("/arms/scheduler/pdservice/reqstatus/executeSequentialSchedules/storeToES")
    String executeSequentialSchedules();

    @GetMapping("/arms/scheduler/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES")
    void executeIncrementalIssueSequentialSchedules();

    @GetMapping("/arms/scheduler/pdservice/reqstatus/increment/executeSequentialSchedules/storeToES/withDateRange")
    String executeIncrementalIssueWithDateRangeSequentialSchedules(@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    @PutMapping("/arms/scheduler/cacheStatusMappingData")
    String cacheStatusMappingData();

    // Get Test
    @GetMapping("/arms/pdServicePure/get-test-a")
    String getTestA();
    // Post Test
    @PostMapping("/arms/pdServicePure/post-test-a")
    String postTestA();

}
