package com.arms.api.util.external_communicate;

import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.util.external_communicate.dto.SearchDTO;
import com.arms.api.util.external_communicate.vo.ServerInfoVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "engine-fire", url = "${arms.engine-fire.url}")
public interface EngineCommunicator {

    @PostMapping("/engine/serverInfo/backup/scheduler")
    Iterable<ServerInfoVO> serverInfoBackup();

    @GetMapping("/engine/connection/keep-alive")
    void keepAlive();

    @PostMapping("/engine/index/alm-issue/merge-with-reindex")
    void almIssueMergeWithReindex();

    @PostMapping("/engine/index/fluentd/merge-with-reindex")
    void fluentdMergeWithReindex();

    @PostMapping("/engine/index/alm-issue/merge-with-reindex/day/{day}")
    void almIssueMergeWithReindex(@PathVariable("day")int day);

    @PostMapping("/engine/index/fluentd/merge-with-reindex/day/{day}")
    void fluentdMergeWithReindex(@PathVariable("day")int day);

    @PutMapping("/engine/jira/arms-state-category")
    void updateArmsStateCategory();

    @PostMapping("/engine/search/schedule-history-log")
    ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO searchDTO);

    @GetMapping("/engine/jira/issue/test/api-request")
    void cloudJiraTestApiRequest();
}
