/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.scheduler.dynamic.controller;

import com.arms.api.scheduler.dynamic.dto.SchedulerDTO;
import com.arms.api.util.cron.CronLocalDateTimes;
import com.arms.api.util.cron.MadCronExpression;
import com.arms.api.util.response.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class DynamicScheduleController {
    private static final Logger log = LoggerFactory.getLogger(DynamicScheduleController.class);

    @PostMapping(value={"/auth-user/schedules/simulate"})
    public Mono<CommonResponse.ApiResult<List<String>>> cronSimulate(@RequestBody SchedulerDTO schedulerDTO) {
        CronLocalDateTimes cronLocalDateTimes = new MadCronExpression(schedulerDTO.getCronExpression()).localDateTimes();
        return Mono.just(CommonResponse.success(cronLocalDateTimes.simulateResult()));
    }
}

