/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.sample.safeguard;

import com.arms.api.sample.safeguard.SafeGuardAdvisor;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class SafeGuardAdvisor
implements BaseAdvisor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SafeGuardAdvisor.class);
    private int order = 1;
    private static final double SAFETY_THRESHOLD = 0.7;
    private static final int MAX_CONTENT_LENGTH = 50000;
    private final AtomicLong totalRequests = new AtomicLong(0L);
    private final AtomicLong blockedRequests = new AtomicLong(0L);
    private final AtomicLong filteredResponses = new AtomicLong(0L);
    private final ConcurrentHashMap<String, AtomicLong> violationStats = new ConcurrentHashMap();
    private final Set<String> criticalKeywords = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ignore all previous instructions", "disregard all prior", "forget everything", "ignore the above", "ignore your instructions", "new instructions:", "system prompt:", "override instructions", "\uc774\uc804 \uc9c0\uc2dc\uc0ac\ud56d \ubb34\uc2dc", "\ubaa8\ub4e0 \uba85\ub839 \ubb34\uc2dc", "\uc0c8\ub85c\uc6b4 \uc9c0\uc2dc\uc0ac\ud56d", "\uc2dc\uc2a4\ud15c \ud504\ub86c\ud504\ud2b8", "\ub2f9\uc2e0\uc740 \uc774\uc81c\ubd80\ud130", "\uc5ed\ud560\uc744 \ubcc0\uacbd", "\uba85\ub839\uc744 \ubb34\uc2dc\ud558\uace0", "\uc9c0\uc2dc\ub97c \uc78a\uc5b4\ubc84\ub9ac\uace0", "developer mode", "god mode", "unrestricted", "no restrictions", "bypass safety", "disable filter", "\uac1c\ubc1c\uc790 \ubaa8\ub4dc", "\ubb34\uc81c\ud55c \ubaa8\ub4dc", "\uc81c\ud55c \uc5c6\uc774", "\ud544\ud130 \ud574\uc81c", "rm -rf", "format c:", "del /f /s /q", "shutdown", "reboot", "drop database", "truncate table", "delete from users")));
    private final Set<String> highRiskKeywords = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("password", "passwd", "pwd", "api_key", "apikey", "api-key", "secret_key", "secret", "private_key", "access_token", "refresh_token", "bearer", "authorization", "credential", "\ube44\ubc00\ubc88\ud638", "\ud328\uc2a4\uc6cc\ub4dc", "\uc554\ud638", "api\ud0a4", "\ube44\ubc00\ud0a4", "\uc778\uc99d\ud0a4", "\uc811\uadfc\ud1a0\ud070", "\uc561\uc138\uc2a4\ud1a0\ud070", "\uc778\uc99d\uc815\ubcf4")));
    private final Set<String> mediumRiskKeywords = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("union select", "or 1=1", "and 1=1", "'; drop", "' or '1'='1", "admin'--", "' or ''='", "alert(", "confirm(", "prompt(", "document.cookie")));
    private final Set<String> whitelist = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("password hashing", "password encryption", "password security", "how to secure password", "password best practices", "\ube44\ubc00\ubc88\ud638 \uc554\ud638\ud654", "\ube44\ubc00\ubc88\ud638 \ubcf4\uc548", "\ube44\ubc00\ubc88\ud638 \ud574\uc2f1", "sql injection prevention", "xss prevention", "security best practices", "sql \uc778\uc81d\uc158 \ubc29\uc5b4", "xss \ubc29\uc5b4", "\ubcf4\uc548 \ubaa8\ubc94 \uc0ac\ub840")));
    private final Map<String, Pattern> compiledPatterns = new HashMap();

    public SafeGuardAdvisor() {
        this.initializePatterns();
    }

    private void initializePatterns() {
        this.compiledPatterns.put("SQL_UNION", Pattern.compile("(?i)\\b(union|select|insert|update|delete|drop)\\s+(all\\s+)?(select|from|into|table|where)", 2));
        this.compiledPatterns.put("SQL_COMMENT", Pattern.compile("--[^\n]*|/\\*.*?\\*/|#[^\n]*", 2));
        this.compiledPatterns.put("XSS_SCRIPT", Pattern.compile("<script[^>]*>.*?</script>|<iframe[^>]*>.*?</iframe>", 34));
        this.compiledPatterns.put("XSS_EVENT", Pattern.compile("on(load|error|click|mouse\\w+|key\\w+)\\s*=", 2));
        this.compiledPatterns.put("XSS_JAVASCRIPT", Pattern.compile("javascript:\\s*", 2));
        this.compiledPatterns.put("PATH_TRAVERSAL", Pattern.compile("(\\.\\./|\\.\\\\|%2e%2e%2f|%2e%2e/|\\.\\.%2f)", 2));
        this.compiledPatterns.put("COMMAND_INJECTION", Pattern.compile("\\b(exec|system|eval|cmd|sh|bash|powershell|shell_exec)\\s*[\\(\\[]", 2));
        this.compiledPatterns.put("PROMPT_INJECTION", Pattern.compile("(?i)(ignore|disregard|forget|bypass|override)\\s+(all|previous|prior|above|your)\\s+(instructions?|commands?|rules?|prompts?)", 2));
        this.compiledPatterns.put("ROLE_MANIPULATION", Pattern.compile("(?i)(you\\s+are\\s+now|act\\s+as|pretend\\s+to\\s+be|roleplay\\s+as|assume\\s+the\\s+role)", 2));
        this.compiledPatterns.put("EMAIL", Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}"));
        this.compiledPatterns.put("PHONE_KR", Pattern.compile("0\\d{1,2}-\\d{3,4}-\\d{4}|01[016789]-\\d{3,4}-\\d{4}"));
        this.compiledPatterns.put("CREDIT_CARD", Pattern.compile("\\d{4}[-\\s]?\\d{4}[-\\s]?\\d{4}[-\\s]?\\d{4}"));
        this.compiledPatterns.put("SSN_KR", Pattern.compile("\\d{6}[-\\s]?[1-4]\\d{6}"));
        this.compiledPatterns.put("JWT_TOKEN", Pattern.compile("eyJ[a-zA-Z0-9_-]+\\.eyJ[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+"));
        this.compiledPatterns.put("BASE64_LONG", Pattern.compile("(?:[A-Za-z0-9+/]{4}){20,}(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?"));
    }

    public AdvisedRequest before(AdvisedRequest request) {
        this.totalRequests.incrementAndGet();
        long startTime = System.currentTimeMillis();
        log.info("SafeGuardAdvisor::before - Request #{} \ubcf4\uc548 \uac80\uc99d \uc2dc\uc791", (Object)this.totalRequests.get());
        String userText = request.userText();
        if (userText == null || userText.trim().isEmpty()) {
            log.debug("SafeGuardAdvisor::before - \ube48 \uc694\uccad, \ud328\uc2a4");
            return request;
        }
        if (this.isWhitelisted(userText)) {
            log.info("SafeGuardAdvisor::before - \ud654\uc774\ud2b8\ub9ac\uc2a4\ud2b8 \ub9e4\uce6d, \uac80\uc99d \ud328\uc2a4");
            return request;
        }
        ValidationResult inputValidation = this.validateContent(userText, "REQUEST");
        long processingTime = System.currentTimeMillis() - startTime;
        log.info("SafeGuardAdvisor::before - \uac80\uc99d \uc644\ub8cc ({}ms), \uc548\uc804: {}", (Object)processingTime, (Object)inputValidation.isSafe());
        if (!inputValidation.isSafe()) {
            this.blockedRequests.incrementAndGet();
            for (String violation : inputValidation.getViolations()) {
                this.violationStats.computeIfAbsent(violation, k -> new AtomicLong(0L)).incrementAndGet();
            }
            if (inputValidation.getSeverity() == Severity.CRITICAL) {
                log.error("SafeGuardAdvisor::before - CRITICAL \uc704\ud611 \ud0d0\uc9c0! Violations: {}, Details: {}", (Object)inputValidation.getViolations(), (Object)inputValidation.getAllViolationDetails());
            } else {
                log.warn("SafeGuardAdvisor::before - {} \uc704\ud611 \ud0d0\uc9c0, Violations: {}", (Object)inputValidation.getSeverity(), (Object)inputValidation.getViolations());
            }
            return AdvisedRequest.from((AdvisedRequest)request).userText(this.getSafeAlternativeMessage(inputValidation)).userParams(this.addSafetyMetadata(request.userParams(), inputValidation)).build();
        }
        Map sanitizedParams = this.sanitizeParameters(request.userParams());
        return AdvisedRequest.from((AdvisedRequest)request).userParams(sanitizedParams).build();
    }

    public AdvisedResponse after(AdvisedResponse response) {
        String maskedResponse;
        log.info("SafeGuardAdvisor::after - \uc751\ub2f5 \ud544\ud130\ub9c1 \uc2dc\uc791");
        String responseText = this.extractTextFromResponse(response);
        if (responseText == null || responseText.trim().isEmpty()) {
            return response;
        }
        ValidationResult responseValidation = this.validateContent(responseText, "RESPONSE");
        String processedResponse = responseText;
        boolean wasFiltered = false;
        if (!responseValidation.isSafe()) {
            this.filteredResponses.incrementAndGet();
            log.warn("SafeGuardAdvisor::after - \uc751\ub2f5\uc5d0\uc11c {} \uc704\ud611 \ud0d0\uc9c0: {}", (Object)responseValidation.getSeverity(), (Object)responseValidation.getViolations());
            if (responseValidation.getSeverity() == Severity.CRITICAL) {
                processedResponse = "\ubcf4\uc548 \uc815\ucc45\uc5d0 \ub530\ub77c \ud574\ub2f9 \uc751\ub2f5\uc744 \uc81c\uacf5\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (\uc704\ud5d8 \ub4f1\uae09: \ub192\uc74c)";
                wasFiltered = true;
            } else {
                processedResponse = this.filterResponse(responseText, responseValidation);
                boolean bl = wasFiltered = !processedResponse.equals(responseText);
            }
        }
        if (!(maskedResponse = this.maskSensitiveData(processedResponse)).equals(processedResponse)) {
            wasFiltered = true;
            log.info("SafeGuardAdvisor::after - \ubbfc\uac10 \uc815\ubcf4 \ub9c8\uc2a4\ud0b9 \uc801\uc6a9");
        }
        double safetyScore = this.calculateSafetyScore(responseText);
        HashMap<String, Object> adviseContext = new HashMap<String, Object>(response.adviseContext());
        adviseContext.put("safeguard_checked", true);
        adviseContext.put("safeguard_version", "2.0");
        adviseContext.put("safety_score", safetyScore);
        adviseContext.put("filtered", wasFiltered);
        adviseContext.put("severity", responseValidation.getSeverity().name());
        adviseContext.put("timestamp", LocalDateTime.now().toString());
        if (wasFiltered) {
            adviseContext.put("filter_reason", responseValidation.getViolations());
        }
        log.info("SafeGuardAdvisor::after - \ucc98\ub9ac \uc644\ub8cc (Score: {}, Filtered: {})", (Object)safetyScore, (Object)wasFiltered);
        HashMap<String, Comparable<Boolean>> chatResponseMetadata = new HashMap<String, Comparable<Boolean>>();
        chatResponseMetadata.put("safeguard_checked", Boolean.valueOf(true));
        chatResponseMetadata.put("safety_score", Double.valueOf(safetyScore));
        ChatResponse modifiedChatResponse = this.createChatResponse(maskedResponse, chatResponseMetadata);
        return AdvisedResponse.from((AdvisedResponse)response).response(modifiedChatResponse).adviseContext(adviseContext).build();
    }

    public Flux<AdvisedResponse> aroundStream(AdvisedRequest request, StreamAroundAdvisorChain chain) {
        log.info("SafeGuardAdvisor::aroundStream - \uc2a4\ud2b8\ub9bc \ubaa8\ub2c8\ud130\ub9c1 \uc2dc\uc791");
        AtomicLong chunkCount = new AtomicLong(0L);
        AtomicLong filteredChunkCount = new AtomicLong(0L);
        return chain.nextAroundStream(request).map(response -> {
            long currentChunk = chunkCount.incrementAndGet();
            String content = this.extractTextFromResponse(response);
            if (content == null || content.isEmpty()) {
                return response;
            }
            ValidationResult validation = this.validateContentStream(content);
            if (!validation.isSafe()) {
                filteredChunkCount.incrementAndGet();
                log.debug("SafeGuardAdvisor::aroundStream - Chunk #{} \ud544\ud130\ub9c1 ({})", (Object)currentChunk, (Object)validation.getViolations());
                String filteredContent = validation.getSeverity() == Severity.CRITICAL ? "[BLOCKED]" : this.filterResponse(content, validation);
                filteredContent = this.maskSensitiveData(filteredContent);
                return AdvisedResponse.from((AdvisedResponse)response).response(this.createChatResponse(filteredContent, null)).build();
            }
            String maskedContent = this.maskSensitiveData(content);
            if (!maskedContent.equals(content)) {
                return AdvisedResponse.from((AdvisedResponse)response).response(this.createChatResponse(maskedContent, null)).build();
            }
            return response;
        }).doOnComplete(() -> log.info("SafeGuardAdvisor::aroundStream - \uc2a4\ud2b8\ub9bc \uc644\ub8cc (\ucd1d \uccad\ud06c: {}, \ud544\ud130\ub9c1\ub41c \uccad\ud06c: {})", (Object)chunkCount.get(), (Object)filteredChunkCount.get())).doOnError(error -> log.error("SafeGuardAdvisor::aroundStream - \uc2a4\ud2b8\ub9bc \uc5d0\ub7ec", error));
    }

    private String extractTextFromResponse(AdvisedResponse response) {
        if (response.response() == null || response.response().getResult() == null || response.response().getResult().getOutput() == null) {
            return null;
        }
        return response.response().getResult().getOutput().getText();
    }

    private ChatResponse createChatResponse(String text, Map<String, Object> metadata) {
        AssistantMessage assistantMessage = new AssistantMessage(text);
        Generation generation = new Generation(assistantMessage);
        return new ChatResponse(List.of(generation));
    }

    private ValidationResult validateContent(String content, String type) {
        ValidationResult result = new ValidationResult();
        if (content == null || content.trim().isEmpty()) {
            return result;
        }
        String lowerContent = content.toLowerCase();
        if (content.length() > 50000) {
            result.addViolation("CONTENT_TOO_LONG", String.format("Length: %d (max: %d)", content.length(), 50000), Severity.HIGH);
        }
        for (String keyword : this.criticalKeywords) {
            if (!lowerContent.contains(keyword.toLowerCase())) continue;
            result.addViolation("CRITICAL_KEYWORD", keyword, Severity.CRITICAL);
        }
        for (String keyword : this.highRiskKeywords) {
            if (!lowerContent.contains(keyword.toLowerCase())) continue;
            result.addViolation("HIGH_RISK_KEYWORD", keyword, Severity.HIGH);
        }
        for (String keyword : this.mediumRiskKeywords) {
            if (!lowerContent.contains(keyword.toLowerCase())) continue;
            result.addViolation("MEDIUM_RISK_KEYWORD", keyword, Severity.MEDIUM);
        }
        this.checkPattern(content, "SQL_UNION", result, Severity.HIGH);
        this.checkPattern(content, "SQL_COMMENT", result, Severity.MEDIUM);
        this.checkPattern(content, "XSS_SCRIPT", result, Severity.CRITICAL);
        this.checkPattern(content, "XSS_EVENT", result, Severity.HIGH);
        this.checkPattern(content, "XSS_JAVASCRIPT", result, Severity.HIGH);
        this.checkPattern(content, "PATH_TRAVERSAL", result, Severity.HIGH);
        this.checkPattern(content, "COMMAND_INJECTION", result, Severity.CRITICAL);
        this.checkPattern(content, "PROMPT_INJECTION", result, Severity.CRITICAL);
        this.checkPattern(content, "ROLE_MANIPULATION", result, Severity.HIGH);
        return result;
    }

    private ValidationResult validateContentStream(String content) {
        ValidationResult result = new ValidationResult();
        if (content == null || content.trim().isEmpty()) {
            return result;
        }
        String lowerContent = content.toLowerCase();
        for (String keyword : this.criticalKeywords) {
            if (!lowerContent.contains(keyword.toLowerCase())) continue;
            result.addViolation("CRITICAL_KEYWORD", keyword, Severity.CRITICAL);
        }
        this.checkPattern(content, "XSS_SCRIPT", result, Severity.CRITICAL);
        this.checkPattern(content, "COMMAND_INJECTION", result, Severity.CRITICAL);
        this.checkPattern(content, "PROMPT_INJECTION", result, Severity.CRITICAL);
        return result;
    }

    private void checkPattern(String content, String patternKey, ValidationResult result, Severity severity) {
        Matcher matcher;
        Pattern pattern = (Pattern)this.compiledPatterns.get(patternKey);
        if (pattern != null && pattern.matcher(content).find() && (matcher = pattern.matcher(content)).find()) {
            String matched = matcher.group();
            result.addViolation(patternKey, (String)(matched.length() > 50 ? matched.substring(0, 50) + "..." : matched), severity);
        }
    }

    private boolean isWhitelisted(String content) {
        String lowerContent = content.toLowerCase();
        return this.whitelist.stream().anyMatch(whitelistItem -> lowerContent.contains(whitelistItem.toLowerCase()));
    }

    private Map<String, Object> sanitizeParameters(Map<String, Object> params) {
        HashMap<String, Object> sanitized = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (this.isValidParameterKey(key)) {
                if (value instanceof String) {
                    sanitized.put(key, this.sanitizeString((String)value));
                    continue;
                }
                if (value instanceof List) {
                    sanitized.put(key, this.sanitizeList((List)value));
                    continue;
                }
                if (value instanceof Map) {
                    sanitized.put(key, this.sanitizeParameters((Map)value));
                    continue;
                }
                sanitized.put(key, value);
                continue;
            }
            log.warn("SafeGuardAdvisor - \uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud30c\ub77c\ubbf8\ud130 \ud0a4 \uc81c\uac70: {}", (Object)key);
        }
        return sanitized;
    }

    private List<?> sanitizeList(List<?> list) {
        return list.stream().map(item -> {
            if (item instanceof String) {
                return this.sanitizeString((String)item);
            }
            if (item instanceof Map) {
                return this.sanitizeParameters((Map)item);
            }
            return item;
        }).collect(Collectors.toList());
    }

    private String sanitizeString(String input) {
        if (input == null) {
            return null;
        }
        String sanitized = input;
        sanitized = sanitized.replaceAll("<[^>]*>", "");
        sanitized = sanitized.replaceAll("(?i)javascript:", "");
        sanitized = sanitized.replaceAll("(?i)on\\w+\\s*=", "");
        sanitized = sanitized.replaceAll("--[^\n]*", "");
        sanitized = sanitized.replaceAll("/\\*.*?\\*/", "");
        sanitized = sanitized.replaceAll("\\s+", " ").trim();
        return sanitized;
    }

    private String maskSensitiveData(String content) {
        if (content == null) {
            return null;
        }
        String masked = content;
        Pattern emailPattern = (Pattern)this.compiledPatterns.get("EMAIL");
        if (emailPattern != null) {
            masked = emailPattern.matcher(masked).replaceAll(matchResult -> {
                String email = matchResult.group();
                String[] parts = email.split("@");
                if (parts.length == 2) {
                    String username = parts[0];
                    String domain = parts[1];
                    String maskedUsername = username.length() > 2 ? username.substring(0, 2) + "***" : "***";
                    return maskedUsername + "@" + domain;
                }
                return "***@***.***";
            });
        }
        masked = ((Pattern)this.compiledPatterns.get("PHONE_KR")).matcher(masked).replaceAll("***-****-****");
        masked = ((Pattern)this.compiledPatterns.get("CREDIT_CARD")).matcher(masked).replaceAll("****-****-****-****");
        masked = ((Pattern)this.compiledPatterns.get("SSN_KR")).matcher(masked).replaceAll(matchResult -> {
            String ssn = matchResult.group();
            return ssn.substring(0, 6) + "-*******";
        });
        masked = ((Pattern)this.compiledPatterns.get("JWT_TOKEN")).matcher(masked).replaceAll("[JWT_TOKEN_MASKED]");
        masked = ((Pattern)this.compiledPatterns.get("BASE64_LONG")).matcher(masked).replaceAll("[ENCODED_DATA_MASKED]");
        return masked;
    }

    private String getSafeAlternativeMessage(ValidationResult validation) {
        Severity severity = validation.getSeverity();
        switch (severity.ordinal()) {
            case 3: {
                return "\uc8c4\uc1a1\ud569\ub2c8\ub2e4. \uc694\uccad\ud558\uc2e0 \ub0b4\uc6a9\uc5d0 \uc2ec\uac01\ud55c \ubcf4\uc548 \uc704\ud5d8 \uc694\uc18c\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc5b4 \ucc98\ub9ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc2dc\uc2a4\ud15c \uad00\ub9ac\uc790\uc5d0\uac8c \ubb38\uc758\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
            }
            case 2: {
                return "\uc8c4\uc1a1\ud569\ub2c8\ub2e4. \uc694\uccad\ud558\uc2e0 \ub0b4\uc6a9\uc5d0 \ubcf4\uc548\uc0c1 \uc704\ud5d8\ud55c \uc694\uc18c\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc5b4 \ucc98\ub9ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\ub978 \ubc29\uc2dd\uc73c\ub85c \uc9c8\ubb38\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
            }
            case 1: {
                return "\uc8c4\uc1a1\ud569\ub2c8\ub2e4. \uc694\uccad\ud558\uc2e0 \ub0b4\uc6a9\uc5d0 \ubd80\uc801\uc808\ud55c \uc694\uc18c\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc9c8\ubb38\uc744 \ub2e4\uc2dc \uc791\uc131\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
            }
        }
        return "\uc8c4\uc1a1\ud569\ub2c8\ub2e4. \uc694\uccad\uc744 \ucc98\ub9ac\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc9c8\ubb38\uc744 \ub2e4\uc2dc \uc791\uc131\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
    }

    private String filterResponse(String response, ValidationResult validation) {
        if (validation.getSeverity() == Severity.CRITICAL) {
            return "\ubcf4\uc548 \uc815\ucc45\uc5d0 \ub530\ub77c \ud574\ub2f9 \uc751\ub2f5\uc744 \uc81c\uacf5\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. (\uc704\ud5d8 \ub4f1\uae09: \ub192\uc74c)";
        }
        String filtered = response;
        Map violationsBySeverity = validation.getViolationsBySeverity();
        for (Severity severity : Arrays.asList(Severity.HIGH, Severity.MEDIUM)) {
            if (!violationsBySeverity.containsKey(severity)) continue;
            for (String detail : validation.getViolationDetailsBySeverity(severity)) {
                String escapedDetail = Pattern.quote(detail);
                filtered = filtered.replaceAll("(?i)" + escapedDetail, "[FILTERED]");
            }
        }
        return filtered;
    }

    private double calculateSafetyScore(String content) {
        if (content == null || content.isEmpty()) {
            return 1.0;
        }
        double score = 1.0;
        ValidationResult validation = this.validateContent(content, "SCORE");
        Map violationsBySeverity = validation.getViolationsBySeverity();
        score -= (double)violationsBySeverity.getOrDefault(Severity.CRITICAL, Collections.emptyList()).size() * 0.5;
        score -= (double)violationsBySeverity.getOrDefault(Severity.HIGH, Collections.emptyList()).size() * 0.3;
        return Math.max(0.0, Math.min(1.0, score -= (double)violationsBySeverity.getOrDefault(Severity.MEDIUM, Collections.emptyList()).size() * 0.15));
    }

    private boolean isValidParameterKey(String key) {
        return key != null && key.matches("^[a-zA-Z0-9_-]+$");
    }

    private Map<String, Object> addSafetyMetadata(Map<String, Object> params, ValidationResult validation) {
        HashMap<String, Object> enriched = new HashMap<String, Object>(params);
        enriched.put("safeguard_filtered", true);
        enriched.put("safeguard_violations", validation.getViolations());
        enriched.put("safeguard_severity", validation.getSeverity().name());
        enriched.put("safeguard_timestamp", LocalDateTime.now().toString());
        return enriched;
    }

    public SafeGuardStats getStats() {
        return new SafeGuardStats(this.totalRequests.get(), this.blockedRequests.get(), this.filteredResponses.get(), new HashMap<String, Long>(this.violationStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()))));
    }

    public void resetStats() {
        this.totalRequests.set(0L);
        this.blockedRequests.set(0L);
        this.filteredResponses.set(0L);
        this.violationStats.clear();
        log.info("SafeGuardAdvisor - \ud1b5\uacc4 \ucd08\uae30\ud654 \uc644\ub8cc");
    }

    public int getOrder() {
        return this.order;
    }

    public SafeGuardAdvisor withOrder(int order) {
        this.order = order;
        return this;
    }
}

