/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/health"})
public class RedisHealthCheckController {
    private final RedisTemplate<String, Object> redisTemplate;

    @Autowired
    public RedisHealthCheckController(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @GetMapping(value={"/redis"})
    public String checkRedisConnection() {
        try {
            this.redisTemplate.opsForValue().set((Object)"health-check", (Object)"OK");
            String result = (String)this.redisTemplate.opsForValue().get((Object)"health-check");
            return result != null && result.equals("OK") ? "Redis connection is OK" : "Redis connection failed";
        }
        catch (Exception e) {
            return "Redis connection failed: " + e.getMessage();
        }
    }
}

