/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.blog.service;

import com.arms.api.blog.model.entity.BlogDTO;
import com.arms.api.blog.model.entity.BlogEntity;
import com.arms.api.blog.model.vo.BlogVO;
import com.arms.api.blog.service.BlogService;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BlogServiceImpl
implements BlogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlogServiceImpl.class);
    private final EsCommonRepositoryWrapper<BlogEntity> esCommonRepositoryWrapper;

    @Override
    @Transactional
    public Long addBlog(BlogDTO blogDTO) {
        BlogEntity blogEntity = blogDTO.createBlogEntity();
        BlogEntity savedEntity = this.esCommonRepositoryWrapper.save(blogEntity);
        return savedEntity.getC_id();
    }

    @Override
    @Transactional
    public Long updateBlog(BlogDTO blogDTO) {
        if (this.esCommonRepositoryWrapper.findDocById(blogDTO.getC_id()) == null) {
            throw new IllegalArgumentException("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        BlogEntity willUpdateEntity = blogDTO.createBlogEntity();
        this.esCommonRepositoryWrapper.save(willUpdateEntity);
        return willUpdateEntity.getC_id();
    }

    @Override
    @Transactional(readOnly=true)
    public BlogEntity getBlog(BlogDTO blogDTO) {
        Long c_id = blogDTO.getC_id();
        String c_blog_contents = blogDTO.getC_blog_contents();
        BlogEntity existingEntity = this.esCommonRepositoryWrapper.findDocById(c_id);
        if (existingEntity == null) {
            if (c_blog_contents != null && !c_blog_contents.isEmpty()) {
                BlogEntity willCreateEntity = blogDTO.createBlogEntity();
                this.asyncViewCountUp(c_id);
                this.esCommonRepositoryWrapper.save(willCreateEntity);
                return willCreateEntity;
            }
            throw new IllegalArgumentException("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.asyncViewCountUp(c_id);
        return existingEntity;
    }

    @Override
    @Transactional
    public Long removeBlog(Long blogId) {
        this.esCommonRepositoryWrapper.deleteById(blogId);
        return blogId;
    }

    @Override
    @Async
    public void asyncViewCountUp(Long blogId) {
        BlogEntity existingEntity = this.esCommonRepositoryWrapper.findDocById(blogId);
        if (existingEntity != null) {
            existingEntity.viewCountUp();
            this.esCommonRepositoryWrapper.save(existingEntity);
        } else {
            log.warn("\ube14\ub85c\uadf8 \uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: {}", (Object)blogId);
        }
    }

    @Override
    public List<BlogEntity> getBlogListByViewCountDesc(BlogDTO blogDTO) {
        blogDTO.setSize(20);
        return this.getList(SimpleQuery.search(blogDTO).orderBy(SortDTO.builder().field("c_blog_view_count").sortType("desc").build(), SortDTO.builder().field("c_blog_created").sortType("desc").build())).getBlogEntities();
    }

    @Override
    public BlogVO searchBlog(BlogDTO blogDTO) {
        return this.getList(SimpleQuery.search(blogDTO).andMatchQueryFilter("c_blog_title", blogDTO.getC_blog_title()).andMatchQueryFilter("c_blog_contents", blogDTO.getC_blog_contents()).orderBy(SortDTO.builder().field("c_blog_view_count").sortType("desc").build(), SortDTO.builder().field("c_blog_created").sortType("desc").build()));
    }

    private BlogVO getList(SimpleQuery<SearchDocDTO> simpleQuery) {
        DocumentResultWrapper<BlogEntity> docsBySearchAfter = this.esCommonRepositoryWrapper.findDocsBySearchAfter(simpleQuery);
        List<BlogEntity> docs = docsBySearchAfter.toDocs();
        return BlogVO.builder().blogEntities(docs).totalHits(docsBySearchAfter.getTotalHits()).searchAfter(docsBySearchAfter.getLastSortValue()).build();
    }

    @Generated
    public BlogServiceImpl(EsCommonRepositoryWrapper<BlogEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

