/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.clientcase.controller;

import com.arms.api.clientcase.model.ClientCaseContentsDTO;
import com.arms.api.clientcase.service.ClientCaseService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/clientcase"})
public class ClientCaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCaseController.class);
    private final ClientCaseService clientCaseService;

    @GetMapping(value={"/{clientCaseId}"})
    public ResponseEntity<ClientCaseContentsDTO> getClientCase(@PathVariable(name="clientCaseId") String clientCaseId) {
        log.info("[ClientCaseController] GET /engine/clientcase/{}", (Object)clientCaseId);
        return ResponseEntity.ok((Object)this.clientCaseService.getClientCase(clientCaseId));
    }

    @PutMapping
    public ResponseEntity<String> updateClientCase(@RequestBody ClientCaseContentsDTO clientCaseContentsDTO) {
        log.info("[ClientCaseController] PUT /engine/clientcase - c_id: {}", (Object)clientCaseContentsDTO.getC_id());
        return ResponseEntity.ok((Object)this.clientCaseService.updateClientCase(clientCaseContentsDTO));
    }

    @PostMapping
    public ResponseEntity<String> addClientCase(@RequestBody ClientCaseContentsDTO clientCaseContentsDTO) {
        log.info("[ClientCaseController] POST /engine/clientcase - c_id: {}", (Object)clientCaseContentsDTO.getC_id());
        return ResponseEntity.ok((Object)this.clientCaseService.addClientCase(clientCaseContentsDTO));
    }

    @DeleteMapping(value={"/{clientCaseId}"})
    public ResponseEntity<String> deleteClientCase(@PathVariable(name="clientCaseId") String clientCaseId) {
        log.info("[ClientCaseController] DELETE /engine/clientcase/{}", (Object)clientCaseId);
        return ResponseEntity.ok((Object)this.clientCaseService.deleteClientCase(clientCaseId));
    }

    @Generated
    public ClientCaseController(ClientCaseService clientCaseService) {
        this.clientCaseService = clientCaseService;
    }
}

