/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.controller;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOResponse;
import com.arms.api.issue.almapi.service.IssueService;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{connectId}/jira/issue"})
public class IssueController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueController.class);
    @Autowired
    private IssueService issueService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public AlmIssueVOResponse createIssue(@PathVariable(value="connectId") String connectId, @RequestBody AlmIssueDTO almIssueDTO) {
        if (almIssueDTO == null) {
            log.error("createIssue Error almIssueCreationDTO is null");
            throw new IllegalArgumentException("createIssue Error almIssueCreationDTO is null");
        }
        almIssueDTO.setServerId(connectId);
        return this.issueService.createIssue(almIssueDTO).toAlmIssueResponseVO();
    }

    @ResponseBody
    @RequestMapping(value={"/{issueKeyOrId}"}, method={RequestMethod.PUT})
    public Map<String, Object> \uc774\uc288_\uc218\uc815\ud558\uae30(@PathVariable(value="connectId") String connectId, @PathVariable(value="issueKeyOrId") String issueKeyOrId, @RequestBody AlmIssueDTO almIssueDTO) {
        log.info("\uc774\uc288_\uc218\uc815\ud558\uae30 :: connectId :: {} :: \uc9c0\ub77c\uc774\uc288\uc0dd\uc131_\ub370\uc774\ud130 :: {}", (Object)connectId, (Object)almIssueDTO.toString());
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);
        return this.issueService.updateIssue(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(value={"/{issueKeyOrId}/{statusId}"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Map<String, Object> \uc774\uc288_\uc0c1\ud0dc_\ubcc0\uacbd\ud558\uae30(@PathVariable(value="connectId") String connectId, @PathVariable(value="issueKeyOrId") String issueKeyOrId, @PathVariable(value="statusId") String statusId) {
        log.info("\uc774\uc288_\uc0c1\ud0dc_\ubcc0\uacbd\ud558\uae30 :: connectId :: {} :: issueKeyOrId :: {} :: \uc0c1\ud0dc_\uc544\uc774\ub514 :: {}", new Object[]{connectId, issueKeyOrId, statusId});
        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);
        almIssueDTO.setStatusId(statusId);
        return this.issueService.updateIssueStatus(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(value={"/{issueKeyOrId}"}, method={RequestMethod.DELETE})
    public Map<String, Object> \uc774\uc288_\uc0ad\uc81c\ud558\uae30(@PathVariable(value="connectId") String connectId, @PathVariable(value="issueKeyOrId") String issueKeyOrId) {
        log.info("\uc774\uc288_\uc0ad\uc81c\ud558\uae30 :: connectId :: {} :: issueKeyOrId :: {}", (Object)connectId, (Object)issueKeyOrId);
        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);
        return this.issueService.deleteIssue(almIssueDTO);
    }

    @ResponseBody
    @RequestMapping(value={"/{issueKeyOrId}"}, method={RequestMethod.GET})
    public AlmIssueVOResponse \uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30(@PathVariable(value="connectId") String connectId, @PathVariable(value="issueKeyOrId") String issueKeyOrId) {
        log.info("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30 :: connectId : {}, issueKeyOrId : {}", (Object)connectId, (Object)issueKeyOrId);
        AlmIssueDTO almIssueDTO = new AlmIssueDTO();
        almIssueDTO.setServerId(connectId);
        almIssueDTO.setIssueKeyOrId(issueKeyOrId);
        return this.issueService.getIssue(almIssueDTO).toAlmIssueResponseVO();
    }
}

