/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.strategy;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.IssueCreationFieldsDTO;
import com.arms.api.issue.almapi.model.dto.IssueDTO;
import com.arms.api.issue.almapi.model.dto.UserData;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOCollection;
import com.arms.api.issue.almapi.model.vo.IssueFieldData;
import com.arms.api.issue.almapi.model.vo.OnPremissRedmineIssueVO;
import com.arms.api.issue.almapi.model.vo.OnPremissRedmineVOCollection;
import com.arms.api.issue.almapi.service.CategoryMappingService;
import com.arms.api.issue.almapi.strategy.IssueSaveTemplate;
import com.arms.api.issue.almapi.strategy.IssueStrategy;
import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.status.dto.IssueStatusDTO;
import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.project.dto.ProjectDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.LRUMap;
import com.arms.api.util.alm.RedmineApi;
import com.arms.api.util.alm.RedmineUtil;
import com.arms.api.util.errors.ErrorCode;
import com.arms.api.util.errors.ErrorLogUtil;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.google.common.base.Function;
import com.taskadapter.redmineapi.Include;
import com.taskadapter.redmineapi.Params;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.internal.RequestParam;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.stereotype.Component;

@Component(value="REDMINE_ON_PREMISS")
public class OnPremiseRedmineIssueStrategy
implements IssueStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremiseRedmineIssueStrategy.class);
    private final RedmineUtil redmineUtil;
    private final RedmineApi redmineApi;
    private final CategoryMappingService categoryMappingService;
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final ServerInfoService serverInfoService;
    private final IssueSaveTemplate issueSaveTemplate;

    @Override
    public AlmIssueVO createIssue(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        IssueCreationFieldsDTO fieldsDTO = almIssueDTO.getFields();
        if (fieldsDTO == null) {
            String errorMessage = String.format("%s[%s] :: \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ub370\uc774\ud130\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
            log.error(errorMessage);
            throw new IllegalArgumentException(ErrorCode.REQUEST_BODY_ERROR_CHECK.getErrorMsg(new Object[0]) + " :: " + errorMessage);
        }
        String projectKeyOrId = null;
        String issueTypeId = null;
        if (fieldsDTO.getProject() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getProject().getId())) {
            projectKeyOrId = fieldsDTO.getProject().getId();
        }
        if (fieldsDTO.getIssuetype() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getIssuetype().getId())) {
            issueTypeId = fieldsDTO.getIssuetype().getId();
        }
        if (StringUtils.isEmpty(projectKeyOrId) || StringUtils.isEmpty(issueTypeId)) {
            String errorMessage = String.format("%s :: %s \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ud655\uc778\uc5d0 \ud544\uc694\ud55c \ud504\ub85c\uc81d\ud2b8 \uc544\uc774\ub514, \uc774\uc288\uc720\ud615 \uc544\uc774\ub514\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
            throw new IllegalArgumentException(errorMessage);
        }
        Tracker issueType = new Tracker().setId(Integer.valueOf(Integer.parseInt(issueTypeId)));
        Issue issue = new Issue(redmineManager.getTransport(), Integer.parseInt(projectKeyOrId)).setTracker(issueType);
        if (StringUtils.isNotEmpty((CharSequence)fieldsDTO.getSummary())) {
            issue.setSubject(fieldsDTO.getSummary());
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldsDTO.getDescription())) {
            issue.setDescription(fieldsDTO.getDescription());
        }
        if (fieldsDTO.getPriority() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getPriority().getId())) {
            issue.setPriorityId(Integer.valueOf(Integer.parseInt(fieldsDTO.getPriority().getId())));
        }
        if (fieldsDTO.getStartDate() != null) {
            issue.setStartDate(fieldsDTO.getStartDate());
        }
        if (fieldsDTO.getDueDate() != null) {
            issue.setDueDate(fieldsDTO.getDueDate());
        }
        try {
            issue = issue.create(new RequestParam[0]);
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), String.format("%s[%s],  \ud504\ub85c\uc81d\ud2b8[%s], \uc774\uc288\uc720\ud615[%s], \uc0dd\uc131 \ud544\ub4dc :: \uc774\uc288 \uc0dd\uc131\ud558\uae30 \uc911 \uc624\ub958", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId, issueTypeId, issue.toString()));
            throw new IllegalArgumentException(ErrorCode.ISSUE_CREATION_ERROR.getErrorMsg(new Object[0]) + " :: " + errorMessage);
        }
        User user = this.userList(new HashSet<User>(), issue.getAssigneeId(), redmineManager);
        OnPremissRedmineIssueVO onPremissRedmineIssueVO = OnPremissRedmineIssueVO.builder().issue(issue).user(user).serverInfo(serverInfo).build();
        return this.convertOnRedmineIssueToAlmIssue(onPremissRedmineIssueVO);
    }

    @Override
    public Map<String, Object> updateIssue(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        HashMap<String, Object> result = new HashMap<String, Object>();
        IssueCreationFieldsDTO fieldsDTO = almIssueDTO.getFields();
        String summary = fieldsDTO.getSummary();
        String description = fieldsDTO.getDescription();
        IssueStatusDTO issueStatusDTO = fieldsDTO.getStatus();
        try {
            Issue updatedIssue = redmineManager.getIssueManager().getIssueById(Integer.valueOf(Integer.parseInt(almIssueDTO.getIssueKeyOrId())), new Include[0]);
            if (summary != null && !summary.isEmpty()) {
                updatedIssue.setSubject(summary);
            }
            if (description != null) {
                updatedIssue.setDescription(description);
            }
            updatedIssue.update(new RequestParam[0]);
            if (issueStatusDTO != null && !StringUtils.isEmpty((CharSequence)issueStatusDTO.getId())) {
                this.updateIssueStatus(almIssueDTO);
            }
            result.put("success", true);
            result.put("message", "\uc774\uc288 \uc218\uc815 \uc131\uacf5");
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), "\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4 [" + serverInfo.getUri() + "] :: \uc774\uc288_\ud0a4_\ub610\ub294_\uc544\uc774\ub514 :: " + almIssueDTO.getIssueKeyOrId() + " :: \uc218\uc815\ub370\uc774\ud130 :: " + fieldsDTO.toString() + "\uc774\uc288_\uc218\uc815\ud558\uae30 \uc624\ub958");
            log.error(errorMessage);
            result.put("success", false);
            result.put("message", errorMessage);
        }
        return result;
    }

    @Override
    public Map<String, Object> updateIssueStatus(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        HashMap<String, Object> result = new HashMap<String, Object>();
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        String statusId = almIssueDTO.getStatusId();
        try {
            Issue updatedIssue = redmineManager.getIssueManager().getIssueById(Integer.valueOf(Integer.parseInt(issueKeyOrId)), new Include[0]);
            updatedIssue.setStatusId(Integer.valueOf(Integer.parseInt(statusId)));
            updatedIssue.update(new RequestParam[0]);
            boolean checkStatusChange = this.verifyIssueStatus(almIssueDTO);
            if (checkStatusChange) {
                result.put("success", true);
                result.put("message", "\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd \uc131\uacf5");
            } else {
                String errorMessage = "\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4 [" + serverInfo.getUri() + "] :: \uc774\uc288 \ud0a4[" + issueKeyOrId + "] :: \uc0c1\ud0dc \uc544\uc774\ub514[" + statusId + "] :: \ud574\ub2f9 \uc5c5\ubb34 \ud750\ub984\uc73c\ub85c \ubcc0\uacbd\uc774 \ubd88\uac00\ub2a5 \ud569\ub2c8\ub2e4.";
                log.error(errorMessage);
                result.put("success", false);
                result.put("message", "\ubcc0\uacbd\ud560 \uc774\uc288 \uc0c1\ud0dc\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), "\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4 [" + serverInfo.getUri() + "] :: \uc774\uc288_\ud0a4_\ub610\ub294_\uc544\uc774\ub514 :: " + issueKeyOrId + " :: \uc218\uc815\ub370\uc774\ud130 :: " + statusId + "\uc774\uc288_\uc0c1\ud0dc_\ubcc0\uacbd\ud558\uae30 \uc624\ub958");
            log.error(errorMessage);
            result.put("success", false);
            result.put("message", errorMessage);
        }
        return result;
    }

    public boolean verifyIssueStatus(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        String statusId = almIssueDTO.getStatusId();
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Issue updatedIssue = redmineManager.getIssueManager().getIssueById(Integer.valueOf(Integer.parseInt(issueKeyOrId)), new Include[0]);
            return Optional.ofNullable(updatedIssue).map(Issue::getStatusId).map(currentStatus -> StringUtils.equals((CharSequence)statusId, (CharSequence)String.valueOf(currentStatus))).orElse(false);
        }
        catch (RedmineException e) {
            ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), "\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4 [" + serverInfo.getUri() + "] :: \uc774\uc288_\ud0a4_\ub610\ub294_\uc544\uc774\ub514 :: " + issueKeyOrId + " :: \uc774\uc288_\uc0c1\ud0dc_\uac80\uc99d\ud558\uae30 \uc624\ub958");
            return false;
        }
    }

    @Override
    public Map<String, Object> deleteIssue(AlmIssueDTO almIssueDTO) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            redmineManager.getIssueManager().deleteIssue(Integer.valueOf(issueKeyOrId));
            result.put("success", true);
            result.put("message", "\uc774\uc288 \uc0ad\uc81c \uc131\uacf5");
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), "\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4 [" + serverInfo.getUri() + "] :: \uc774\uc288_\ud0a4_\ub610\ub294_\uc544\uc774\ub514 :: " + issueKeyOrId + " :: \uc774\uc288_\uc0ad\uc81c\ud558\uae30 \uc624\ub958");
            log.error(errorMessage);
            result.put("success", false);
            result.put("message", errorMessage);
        }
        return result;
    }

    @Override
    public boolean isExistIssue(AlmIssueDTO almIssueDTO) {
        try {
            AlmIssueVO issue = this.getIssueVO(almIssueDTO, false);
            return issue != null && issue.getKey().equals(almIssueDTO.getIssueKeyOrId());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO) {
        return this.getIssueVO(almIssueDTO, true);
    }

    private AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO, boolean convertFlag) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Issue issue = redmineManager.getIssueManager().getIssueById(Integer.valueOf(Integer.parseInt(issueKeyOrId)), new Include[0]);
            OnPremissRedmineIssueVO onPremissRedmineIssueVO = OnPremissRedmineIssueVO.builder().issue(issue).serverInfo(serverInfo).build();
            if (convertFlag) {
                return this.convertOnRedmineIssueToAlmIssue(onPremissRedmineIssueVO);
            }
            return AlmIssueVO.builder().key(String.valueOf(issue.getId())).build();
        }
        catch (Exception e) {
            ErrorLogUtil.exceptionLogging(e, this.getClass().getName(), "\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            throw new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public List<AlmIssueEntity> discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO) {
        LRUMap lruMap = new LRUMap(10000);
        return this.issueSaveTemplate.discoveryIncrementALmIssueAndGetReqAlmIssueEntities(almIssueIncrementDTO, (Function<AlmIssueIncrementDTO, AlmIssueVOCollection>)((Function)dto -> this.discoveryIssueAndGetReqEntities((AlmIssueIncrementDTO)dto, lruMap)));
    }

    private AlmIssueVOCollection discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO, Map<String, Issue> lruMap) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri() + "?v[updated_on][]=" + almIssueIncrementDTO.getStartDate(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List<Issue> issuesFromRedmine = this.fetchIssuesFromDate(almIssueIncrementDTO, redmineManager);
            issuesFromRedmine.forEach(a -> lruMap.put(String.valueOf(a.getId()), (Issue)a));
            List onPremissRedmineIssueVOS = issuesFromRedmine.stream().flatMap(cloudJiraIssueRawDataVO -> this.incrementTraceArmsIssueVOS(lruMap, (Issue)cloudJiraIssueRawDataVO, serverInfo, redmineManager).stream()).toList();
            OnPremissRedmineVOCollection onPremissRedmineVOCollection = new OnPremissRedmineVOCollection(onPremissRedmineIssueVOS.stream().map(onPremissRedmineIssueVO -> {
                if (!issuesFromRedmine.contains(onPremissRedmineIssueVO.getIssue())) {
                    return onPremissRedmineIssueVO.markAsExcludedFromSave();
                }
                return onPremissRedmineIssueVO;
            }).toList());
            List<OnPremissRedmineIssueVO> onPremissRedmineIssueVOs = onPremissRedmineVOCollection.appliedLinkedIssuePdServiceVO();
            this.deleteUnrelatedEntities(onPremissRedmineIssueVOs, issuesFromRedmine);
            return this.convertIncrementOnRedmineIssueToAlmIssues(onPremissRedmineIssueVOs);
        }
        catch (Exception e) {
            log.error("\uc99d\ubd84 \ub370\uc774\ud130 \uc218\uc9d1\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            ErrorLogUtil.exceptionLoggingAndReturn(e, this.getClass().getName(), "\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") \uc99d\ubd84 \uc774\uc288 \uc218\uc9d1 \uc911 \uc624\ub958");
            return new AlmIssueVOCollection(new ArrayList<AlmIssueVO>());
        }
    }

    private AlmIssueVOCollection convertIncrementOnRedmineIssueToAlmIssues(List<OnPremissRedmineIssueVO> onPremissRedmineIssueVOs) {
        return new AlmIssueVOCollection(onPremissRedmineIssueVOs.stream().map(this::convertOnRedmineIssueToAlmIssue).toList());
    }

    private AlmIssueVO convertOnRedmineIssueToAlmIssue(OnPremissRedmineIssueVO onPremissRedmineIssueVO) {
        ServerInfo serverInfo = onPremissRedmineIssueVO.getServerInfo();
        Issue issue = onPremissRedmineIssueVO.getIssue();
        String defaultPath = this.redmineUtil.checkServerInfoPath(serverInfo.getUri());
        AlmIssueVO.AlmIssueVOBuilder almIssueVOBuilder = AlmIssueVO.builder();
        almIssueVOBuilder.excludeFromSave(onPremissRedmineIssueVO.isExcludeFromSave());
        Optional.ofNullable(onPremissRedmineIssueVO.relationRecentIds()).ifPresent(almIssueVOBuilder::linkedIssue);
        almIssueVOBuilder.almIssueWithRequirementDTO(onPremissRedmineIssueVO.getAlmIssueWithRequirementDTO());
        Optional.ofNullable(issue.getId()).map(String::valueOf).ifPresent(\uc544\uc774\ub514 -> almIssueVOBuilder.id((String)\uc544\uc774\ub514).key((String)\uc544\uc774\ub514).self(defaultPath + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getIssue(), (String)\uc544\uc774\ub514)));
        Optional.ofNullable(issue.getParentId()).ifPresent(a -> almIssueVOBuilder.upperKey(String.valueOf(a)));
        Optional<String> rawData = this.redmineUtil.toJson(issue);
        rawData.ifPresent(almIssueVOBuilder::rawData);
        IssueFieldData IssueFieldData2 = this.\ub808\ub4dc\ub9c8\uc778\uc774\uc288_\uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130_\ub9e4\ud551(issue, defaultPath);
        User user = onPremissRedmineIssueVO.getUser();
        if (!(user == null || ObjectUtils.isEmpty((Object)issue.getAssigneeId()) && ObjectUtils.isEmpty((Object)issue.getAssigneeName()) && ObjectUtils.isEmpty((Object)user.getMail()))) {
            IssueFieldData2.setAssignee(UserData.builder().accountId(Optional.ofNullable(issue.getAssigneeId()).map(String::valueOf).orElse(null)).emailAddress(Optional.ofNullable(user.getMail()).map(String::valueOf).orElse(null)).displayName(issue.getAssigneeName()).build());
        }
        almIssueVOBuilder.fields(IssueFieldData2).armsStateCategory(this.getMappingCategory(serverInfo, IssueFieldData2)).linkedIssuePdServiceIds(onPremissRedmineIssueVO.getLinkedIssuePdServiceIds()).linkedIssuePdServiceVersions(onPremissRedmineIssueVO.getLinkedIssuePdServiceVersions());
        return almIssueVOBuilder.build();
    }

    private void deleteUnrelatedEntities(List<OnPremissRedmineIssueVO> onPremissRedmineIssueVOs, List<Issue> results) {
        results.stream().filter(a -> !onPremissRedmineIssueVOs.contains(OnPremissRedmineIssueVO.builder().issue((Issue)a).build())).forEach(a -> onPremissRedmineIssueVOs.stream().findFirst().ifPresent(b -> {
            AlmIssueEntity almIssueEntity = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)b.recentId(String.valueOf(a.getId()))));
            if (almIssueEntity.getId() != null) {
                this.esCommonRepositoryWrapper.deleteRecentDocById(almIssueEntity.getId());
            }
        }));
    }

    private List<Issue> fetchIssuesFromDate(AlmIssueIncrementDTO almIssueIncrementDTO, RedmineManager redmineManager) {
        String endDate = almIssueIncrementDTO.getEndDate();
        String projectKey = almIssueIncrementDTO.getProjectKey();
        int page = 1;
        int maxResults = 25;
        try {
            boolean hasMore = true;
            ArrayList<Issue> issueResult = new ArrayList<Issue>();
            while (hasMore) {
                Params params = new Params().add("f[]", "updated_on").add("v[updated_on][]", endDate).add("op[updated_on]", "><").add("page", String.valueOf(page)).add("project_id", projectKey);
                List results = redmineManager.getIssueManager().getIssues(params).getResults();
                List<Issue> resultsById = results.stream().map(a -> {
                    try {
                        return redmineManager.getIssueManager().getIssueById(a.getId(), new Include[]{Include.relations, Include.children, Include.journals});
                    }
                    catch (RedmineException e) {
                        throw new RuntimeException(e);
                    }
                }).toList();
                issueResult.addAll(resultsById);
                this.modifyIssueAlmToEs(almIssueIncrementDTO, resultsById);
                int fetchCount = results.size();
                if (fetchCount < maxResults) {
                    hasMore = false;
                    continue;
                }
                ++page;
            }
            return issueResult;
        }
        catch (RedmineException e) {
            throw new RuntimeException(e);
        }
    }

    private void modifyIssueAlmToEs(AlmIssueIncrementDTO almIssueIncrementDTO, List<Issue> results) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        for (Issue issue : results) {
            List<SearchHit<AlmIssueEntity>> hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter("jira_server_id", serverInfo.getConnectId()).andTermQueryFilter("key", issue.getId())).toHitDocs();
            ArrayList<AlmIssueEntity> almIssueRecentFalseList = new ArrayList<AlmIssueEntity>();
            for (SearchHit<AlmIssueEntity> hitDoc : hitDocs) {
                AlmIssueEntity almIssueEntity2 = (AlmIssueEntity)hitDoc.getContent();
                if (almIssueEntity2.getKey().equals(String.valueOf(issue.getId())) && almIssueEntity2.getProject().getKey().equals(String.valueOf(issue.getProjectId()))) continue;
                almIssueEntity2.setRecent(false);
                this.esCommonRepositoryWrapper.modifyWithIndexName(almIssueEntity2, hitDoc.getIndex());
                almIssueRecentFalseList.add(almIssueEntity2);
            }
            almIssueRecentFalseList.stream().filter(a -> a.getRecentId() != null).findFirst().ifPresent(almIssueEntity -> {
                almIssueEntity.modifyProjectKeyAndKey(String.valueOf(issue.getProjectId()), String.valueOf(issue.getId()));
                this.esCommonRepositoryWrapper.save((AlmIssueEntity)almIssueEntity);
            });
        }
    }

    private List<OnPremissRedmineIssueVO> incrementTraceArmsIssueVOS(Map<String, Issue> lruMap, Issue currentIssue, ServerInfo serverInfo, RedmineManager redmineManager) {
        LinkedList<IssueDTO> queue = new LinkedList<IssueDTO>();
        queue.add(this.createIssueDTO(currentIssue));
        lruMap.put(String.valueOf(currentIssue.getId()), currentIssue);
        HashSet<CallSite> recentIds = new HashSet<CallSite>();
        HashSet<String> visited = new HashSet<String>();
        while (!queue.isEmpty()) {
            try {
                IssueDTO issueDTO = (IssueDTO)queue.poll();
                Issue issue = this.issueList(lruMap, issueDTO, redmineManager);
                if (issue.getId() != null) {
                    lruMap.put(String.valueOf(issue.getId()), issue);
                    String recentId = serverInfo.getConnectId() + "_" + issue.getProjectId() + "_" + issue.getId();
                    recentIds.add((CallSite)((Object)recentId));
                }
                if (visited.contains(String.valueOf(issue.getId()))) continue;
                queue.add(this.createIssueParentTraceDTO(issue));
                List childList = issue.getChildren().stream().toList();
                for (Issue childIssue : childList) {
                    queue.add(this.createIssueDTO(childIssue));
                }
                this.linkedIssueQueueRegister(issue, queue, visited);
                visited.add(issueDTO.getKey());
            }
            catch (RedmineException e) {
                throw new RuntimeException(e);
            }
        }
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter("recent_id", recentIds.stream().toList()).andTermQueryFilter("isReq", true)).toDocs().stream().map(reqIssueEntity -> {
            String rootParentKey = this.findRootParentKey(lruMap, String.valueOf(currentIssue.getId()), redmineManager);
            User assigneeUser = null;
            Integer assigneeId = currentIssue.getAssigneeId();
            if (assigneeId != null) {
                try {
                    assigneeUser = redmineManager.getUserManager().getUserById(assigneeId);
                }
                catch (RedmineException e) {
                    log.warn("\ub2f4\ub2f9\uc790 \uc870\ud68c \uc2e4\ud328: {}", (Object)assigneeId, (Object)e);
                }
            }
            return OnPremissRedmineIssueVO.builder().issue(currentIssue).user(assigneeUser).almIssueWithRequirementDTO(Optional.ofNullable(this.isSelfCreatedIssue((AlmIssueEntity)reqIssueEntity, rootParentKey)).orElseGet(() -> new AlmIssueWithRequirementDTO((AlmIssueEntity)reqIssueEntity))).serverInfo(serverInfo).build();
        }).toList();
    }

    private AlmIssueWithRequirementDTO isSelfCreatedIssue(AlmIssueEntity almIssueEntity, String rootParentKey) {
        AlmIssueWithRequirementDTO reqDTO = new AlmIssueWithRequirementDTO(almIssueEntity, rootParentKey);
        AlmIssueEntity recentDocByRecentId = this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)reqDTO.recentId()));
        if (rootParentKey != null && (recentDocByRecentId.getKey() == null || recentDocByRecentId.izReqFalse())) {
            return reqDTO;
        }
        return null;
    }

    private String findRootParentKey(Map<String, Issue> lruMap, String startKey, RedmineManager redmineManager) {
        String findKey = startKey;
        String parentKey = null;
        while (findKey != null) {
            try {
                Issue issue = this.issueList(lruMap, IssueDTO.builder().key(findKey).build(), redmineManager);
                Integer currentParentId = issue.getParentId();
                if (currentParentId == null) break;
                findKey = parentKey = String.valueOf(currentParentId);
            }
            catch (RedmineException e) {
                break;
            }
        }
        return parentKey;
    }

    private IssueDTO createIssueDTO(Issue issue) {
        return IssueDTO.builder().key(String.valueOf(issue.getId())).fromKey(String.valueOf(issue.getId())).build();
    }

    private IssueDTO createIssueParentTraceDTO(Issue issue) {
        return IssueDTO.builder().key(String.valueOf(Optional.ofNullable(issue.getParentId()).orElseGet(() -> ((Issue)issue).getId()))).fromKey(String.valueOf(issue.getId())).build();
    }

    private void linkedIssueQueueRegister(Issue issue, Queue<IssueDTO> queue, Set<String> visited) {
        ArrayList issueRelations = new ArrayList(issue.getRelations());
        for (IssueRelation relation : issueRelations) {
            String issueToIdKey;
            String issueIdKey = String.valueOf(relation.getIssueId());
            if (!visited.contains(issueIdKey)) {
                queue.add(IssueDTO.builder().key(issueIdKey).fromKey(String.valueOf(relation.getIssueToId())).build());
            }
            if (visited.contains(issueToIdKey = String.valueOf(relation.getIssueToId()))) continue;
            queue.add(IssueDTO.builder().key(issueToIdKey).fromKey(String.valueOf(relation.getIssueId())).build());
        }
    }

    private Issue issueList(Map<String, Issue> lruMap, IssueDTO issueDTO, RedmineManager redmineManager) throws RedmineException {
        log.info("key cache:key=={},{}", (Object)issueDTO.getKey(), (Object)(lruMap.get(issueDTO.getKey()) != null ? 1 : 0));
        Issue issue = lruMap.get(issueDTO.getKey());
        if (issue != null) {
            return issue;
        }
        return redmineManager.getIssueManager().getIssueById(Integer.valueOf(Integer.parseInt(Objects.requireNonNull(issueDTO.getKey()))), new Include[]{Include.relations, Include.children});
    }

    private User userList(Set<User> userSet, Integer assigneeId, RedmineManager redmineManager) {
        Optional<User> optionalUser = userSet.stream().filter(a -> a.getId().equals(assigneeId)).findFirst();
        if (optionalUser.isPresent()) {
            return optionalUser.get();
        }
        return Optional.ofNullable(assigneeId).map(a -> this.redmineUtil.getUserInfo(redmineManager, String.valueOf(a))).orElse(null);
    }

    private IssueFieldData \ub808\ub4dc\ub9c8\uc778\uc774\uc288_\uc9c0\ub77c\uc774\uc288\ud544\ub4dc_\ub370\uc774\ud130_\ub9e4\ud551(Issue \uc774\uc288, String \uae30\ubcf8\uacbd\ub85c) {
        IssueFieldData IssueFieldData2 = new IssueFieldData();
        Optional.ofNullable(\uc774\uc288.getProjectId()).map(\uc544\uc774\ub514 -> String.valueOf(\uc544\uc774\ub514)).ifPresent(\uc544\uc774\ub514 -> {
            String \ud504\ub85c\uc81d\ud2b8_\uacbd\ub85c = \uae30\ubcf8\uacbd\ub85c + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getProject(), (String)\uc544\uc774\ub514);
            IssueFieldData2.setProject(new ProjectDTO(\ud504\ub85c\uc81d\ud2b8_\uacbd\ub85c, (String)\uc544\uc774\ub514, (String)\uc544\uc774\ub514, \uc774\uc288.getProjectName()));
        });
        Optional.ofNullable(\uc774\uc288.getTracker().getId()).map(\uc544\uc774\ub514 -> String.valueOf(\uc544\uc774\ub514)).ifPresent(\uc544\uc774\ub514 -> {
            String \uc774\uc288\uc720\ud615_\uacbd\ub85c = \uae30\ubcf8\uacbd\ub85c + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getIssuetype(), (String)\uc544\uc774\ub514);
            IssueFieldData2.setIssuetype(new IssueTypeDTO(\uc774\uc288\uc720\ud615_\uacbd\ub85c, (String)\uc544\uc774\ub514, \uc774\uc288.getTracker().getName()));
        });
        Optional.ofNullable(\uc774\uc288.getPriorityId()).map(\uc544\uc774\ub514 -> String.valueOf(\uc544\uc774\ub514)).ifPresent(\uc544\uc774\ub514 -> {
            String \uc6b0\uc120\uc21c\uc704_\uacbd\ub85c = \uae30\ubcf8\uacbd\ub85c + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getPriority(), (String)\uc544\uc774\ub514);
            IssueFieldData2.setPriority(new IssuePriorityDTO(\uc6b0\uc120\uc21c\uc704_\uacbd\ub85c, (String)\uc544\uc774\ub514, \uc774\uc288.getPriorityText()));
        });
        Optional.ofNullable(\uc774\uc288.getStatusId()).map(\uc544\uc774\ub514 -> String.valueOf(\uc544\uc774\ub514)).ifPresent(\uc544\uc774\ub514 -> {
            String \uc774\uc288\uc0c1\ud0dc_\uacbd\ub85c = \uae30\ubcf8\uacbd\ub85c + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getIssuestatus(), (String)\uc544\uc774\ub514);
            IssueFieldData2.setStatus(new IssueStatusDTO(\uc774\uc288\uc0c1\ud0dc_\uacbd\ub85c, (String)\uc544\uc774\ub514, \uc774\uc288.getStatusName()));
        });
        Optional.ofNullable(\uc774\uc288.getAuthorId()).map(\uc544\uc774\ub514 -> String.valueOf(\uc544\uc774\ub514)).ifPresent(\uc544\uc774\ub514 -> {
            UserData \uc0ac\uc6a9\uc790_\ub370\uc774\ud130 = UserData.builder().accountId((String)\uc544\uc774\ub514).displayName(\uc774\uc288.getAuthorName()).build();
            IssueFieldData2.setCreator(\uc0ac\uc6a9\uc790_\ub370\uc774\ud130);
            IssueFieldData2.setReporter(\uc0ac\uc6a9\uc790_\ub370\uc774\ud130);
        });
        Optional.ofNullable(\uc774\uc288.getCreatedOn()).map(\uc0dd\uc131\uc77c -> this.\ub0a0\uc9dc\ubcc0\ud658((Date)\uc0dd\uc131\uc77c)).ifPresent(IssueFieldData2::setCreated);
        Optional.ofNullable(\uc774\uc288.getUpdatedOn()).map(\uc5c5\ub370\uc774\ud2b8\uc77c -> this.\ub0a0\uc9dc\ubcc0\ud658((Date)\uc5c5\ub370\uc774\ud2b8\uc77c)).ifPresent(IssueFieldData2::setUpdated);
        Optional.ofNullable(\uc774\uc288.getClosedOn()).map(\ud574\uacb0\ucc45 -> this.\ub0a0\uc9dc\ubcc0\ud658((Date)\ud574\uacb0\ucc45)).ifPresent(IssueFieldData2::setResolutiondate);
        IssueFieldData2.setSummary(\uc774\uc288.getSubject());
        return IssueFieldData2;
    }

    private String \ub0a0\uc9dc\ubcc0\ud658(Date \uc6d0\ubcf8_\ub0a0\uc9dc) {
        DateTimeFormatter originalFormatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        ZonedDateTime \ub0a0\uc9dc\uc2dc\uac04 = ZonedDateTime.parse(String.valueOf(\uc6d0\ubcf8_\ub0a0\uc9dc), originalFormatter);
        String \ubcc0\ud658\ub41c_\ub0a0\uc9dc\uc2dc\uac04 = \ub0a0\uc9dc\uc2dc\uac04.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return \ubcc0\ud658\ub41c_\ub0a0\uc9dc\uc2dc\uac04;
    }

    private String getMappingCategory(ServerInfo serverInfo, IssueFieldData IssueFieldData2) {
        return this.categoryMappingService.getMappingCategory(serverInfo, IssueFieldData2.getAlmStatusId());
    }

    @Generated
    public OnPremiseRedmineIssueStrategy(RedmineUtil redmineUtil, RedmineApi redmineApi, CategoryMappingService categoryMappingService, EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, ServerInfoService serverInfoService, IssueSaveTemplate issueSaveTemplate) {
        this.redmineUtil = redmineUtil;
        this.redmineApi = redmineApi;
        this.categoryMappingService = categoryMappingService;
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.serverInfoService = serverInfoService;
        this.issueSaveTemplate = issueSaveTemplate;
    }
}

