/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.status.controller;

import com.arms.api.issue.status.service.IssueStatusService;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{connectId}/jira/issuestatus"})
public class IssueStatusController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueStatusController.class);
    private final IssueStatusService issueStatusService;

    @Autowired
    public IssueStatusController(IssueStatusService issueStatusService) {
        this.issueStatusService = issueStatusService;
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public List<IssueStatusVO> getIssueStatusList(@PathVariable(value="connectId") String connectId) {
        if (connectId == null) {
            log.error("getIssueStatusList Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueStatusList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        return this.issueStatusService.getIssueStatusList(connectId);
    }

    @ResponseBody
    @RequestMapping(value={"/project/{projectId}"}, method={RequestMethod.GET})
    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(@PathVariable(value="connectId") String connectId, @PathVariable(value="projectId") String projectId) {
        if (connectId == null) {
            log.error("getIssueStatusListByProject Error: connectId {}", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueStatusListByProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            log.error("getIssueStatusListByProject Error projectId {}", (Object)ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("getIssueStatusListByProject Error projectId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg(new Object[0]));
        }
        return this.issueStatusService.getIssueStatusListByProject(connectId, projectId);
    }
}

