/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.status.strategy;

import com.arms.api.issue.status.strategy.IssueStatusStrategy;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.RedmineApi;
import com.arms.api.util.alm.RedmineUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.IssueStatus;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OnPremiseRedmineIssueStatusStrategy
implements IssueStatusStrategy {
    private final RedmineUtil redmineUtil;
    private final RedmineApi redmineApi;
    private final ServerInfoService serverInfoService;

    @Override
    public List<IssueStatusVO> getIssueStatusList(ServerInfo serverInfo) {
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List redmineIssueStatusList = redmineManager.getIssueManager().getStatuses();
            List<IssueStatusVO> issueStatusList = redmineIssueStatusList.stream().map(issueStatus -> this.convertIssueStatusVO((IssueStatus)issueStatus, serverInfo.getUri())).filter(Objects::nonNull).collect(Collectors.toList());
            return issueStatusList;
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), this.getClass().getName(), String.format("%s[%s] :: getIssueStatusList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(ServerInfo serverInfo, String projectId) {
        return null;
    }

    private IssueStatusVO convertIssueStatusVO(IssueStatus issueStatus, String serverUri) {
        String self = this.redmineUtil.checkServerInfoPath(serverUri) + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getIssuestatus(), String.valueOf(issueStatus.getId()));
        return IssueStatusVO.builder().self(self).id(issueStatus.getId().toString()).name(issueStatus.getName()).build();
    }

    @Generated
    public OnPremiseRedmineIssueStatusStrategy(RedmineUtil redmineUtil, RedmineApi redmineApi, ServerInfoService serverInfoService) {
        this.redmineUtil = redmineUtil;
        this.redmineApi = redmineApi;
        this.serverInfoService = serverInfoService;
    }
}

