/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.search_engine.controller;

import com.arms.api.fluentd.model.vo.ScheduleHistoryVO;
import com.arms.api.fluentd.service.FluentdSearch;
import com.arms.api.search_engine.dto.BaseSearchAggrDTO;
import com.arms.api.search_engine.dto.SearchDTO;
import com.arms.api.search_engine.service.AlmIssueSearch;
import com.arms.api.search_engine.vo.SearchAggrResultVO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/search"})
public class SearchController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchController.class);
    @Autowired
    private AlmIssueSearch almIssueSearch;
    @Autowired
    private FluentdSearch fluentdSearch;

    @PostMapping(value={"/almIssue"})
    public ResponseEntity<?> searchAlmIssue(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: AlmIssueSearch] :: searchString => {}", (Object)searchDTO.getSearchString());
        return ResponseEntity.ok(this.almIssueSearch.searchAlmIssue(searchDTO));
    }

    @PostMapping(value={"/log"})
    public ResponseEntity<?> searchFluentdLog(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: searchFluentdLog] :: searchString => {}", (Object)searchDTO.getSearchString());
        return ResponseEntity.ok(this.fluentdSearch.searchFluentdLog(searchDTO));
    }

    @PostMapping(value={"/almIssue/project-aggr-top5"})
    public ResponseEntity<SearchAggrResultVO> findAlmIssueAggregationDataByAlmProjectName(@RequestBody BaseSearchAggrDTO searchAggrDTO) {
        log.info("[SearchController :: findAlmIssueAggregationDataByAlmProjectName]");
        return ResponseEntity.ok((Object)this.almIssueSearch.aggregateByAlmProjectName(searchAggrDTO));
    }

    @PostMapping(value={"/log/aggr-top5"})
    public ResponseEntity<SearchAggrResultVO> findFluentdLogAggregationDataByLogName(@RequestBody BaseSearchAggrDTO searchAggrDTO) {
        log.info("[SearchController :: findFluentdLogAggregationDataByLogName]");
        return ResponseEntity.ok((Object)this.fluentdSearch.aggregateByFluentdLogName(searchAggrDTO));
    }

    @PostMapping(value={"/schedule-history-log"})
    public ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: getScheduleHistory]");
        return ResponseEntity.ok(this.fluentdSearch.getScheduleHistory(searchDTO));
    }
}

