/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.repository.common;

import com.arms.api.util.ApplicationContextProvider;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchIndex;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.annotation.RecentId;
import com.arms.egovframework.javaservice.esframework.annotation.RollingIndexName;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.factory.SearchDocQueryFactory;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SearchDocDTO;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentAggregations;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.RecentFieldConvertor;
import com.arms.egovframework.javaservice.esframework.repository.common.SimpleElasticsearchWrapperRepository;
import com.arms.egovframework.javaservice.esframework.util.ReflectionUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.Response;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.NativeSearchQueryBuilder;
import org.opensearch.data.client.orhlc.OpenSearchRestTemplate;
import org.opensearch.data.core.OpenSearchOperations;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.ReindexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;

public class EsCommonRepositoryImpl<T, U extends Serializable>
extends SimpleElasticsearchWrapperRepository<T, U> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EsCommonRepositoryImpl.class);
    private final Class<T> entityClazz;
    private final OpenSearchOperations openSearchOperations;
    private final SimpleDateFormat defaultFormater;

    public EsCommonRepositoryImpl(ElasticsearchEntityInformation<T, U> metadata, OpenSearchOperations openSearchOperations) {
        super(metadata, (ElasticsearchOperations)openSearchOperations);
        this.entityClazz = metadata.getJavaType();
        this.openSearchOperations = openSearchOperations;
        this.defaultFormater = new SimpleDateFormat(this.findDateFormat(this.rollingIndexNameSuffix()));
    }

    @Override
    public DocumentAggregations aggregateRecentDocs(Query query) {
        return new DocumentAggregations(this.openSearchOperations.search(query, this.entityClazz));
    }

    @Override
    public DocumentAggregations aggregateDocs(Query query) {
        return new DocumentAggregations(this.openSearchOperations.search(query, this.entityClazz));
    }

    @Override
    public DocumentResultWrapper<T> findAllHits() {
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withMaxResults(Integer.valueOf(10000));
        return new DocumentResultWrapper<T>(this.openSearchOperations.search((Query)nativeSearchQueryBuilder.build(), this.entityClazz), this.entityClazz);
    }

    @Override
    public DocumentResultWrapper<T> findHits(Query query) {
        return new DocumentResultWrapper<T>(this.openSearchOperations.search(query, this.entityClazz), this.entityClazz);
    }

    @Override
    public DocumentResultWrapper<T> findRecentAllHits() {
        String recentFieldName = Optional.of(ReflectionUtil.fieldInfo(this.entityClazz, Recent.class).getAnnotation(Field.class).name()).filter(s -> !s.isEmpty()).orElse(ReflectionUtil.fieldInfo(this.entityClazz, Recent.class).getName());
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)recentFieldName, (Object[])new Object[]{true});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)termsQueryBuilder);
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)boolQueryBuilder);
        nativeSearchQueryBuilder.withMaxResults(Integer.valueOf(10000));
        return new DocumentResultWrapper<T>(this.openSearchOperations.search((Query)nativeSearchQueryBuilder.build(), this.entityClazz), this.entityClazz);
    }

    @Override
    public DocumentResultWrapper<T> findRecentHits(Query query) {
        try {
            return new DocumentResultWrapper<T>(this.openSearchOperations.search(query, this.entityClazz), this.entityClazz);
        }
        catch (NoSuchIndexException e) {
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.contains("no such index")) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public T findRecentDocByRecentId(U u) {
        try {
            String recentIdFieldName = Optional.of(ReflectionUtil.fieldInfo(this.entityClazz, RecentId.class).getAnnotation(Field.class).name()).filter(s -> !s.isEmpty()).orElse(ReflectionUtil.fieldInfo(this.entityClazz, RecentId.class).getName());
            String recentFieldName = Optional.of(ReflectionUtil.fieldInfo(this.entityClazz, Recent.class).getAnnotation(Field.class).name()).filter(s -> !s.isEmpty()).orElse(ReflectionUtil.fieldInfo(this.entityClazz, Recent.class).getName());
            SearchDocDTO searchDocDTO = SimpleQuery.termQueryFilter(recentIdFieldName, u).andTermQueryFilter(recentFieldName, true).toSearchDoc();
            DocumentResultWrapper<T> documentSearchResult = new DocumentResultWrapper<T>(this.openSearchOperations.search((Query)SearchDocQueryFactory.searchDoc(searchDocDTO).create(), this.entityClazz), this.entityClazz);
            return documentSearchResult.fetchOnlyOne();
        }
        catch (NoSuchIndexException e) {
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.contains("no such index")) {
                throw new IllegalArgumentException(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public T findDocById(U u) {
        return (T)this.openSearchOperations.get(String.valueOf(u), this.entityClazz);
    }

    @Override
    public DocumentResultWrapper<T> findRecentDocById(U u) {
        Query query = this.openSearchOperations.idsQuery(List.of(String.valueOf(u)));
        return new DocumentResultWrapper<T>(this.openSearchOperations.search(query, this.entityClazz), this.entityClazz);
    }

    @Override
    public <S extends T> S saveEmpty(S entity) {
        return (S)this.openSearchOperations.save(entity, this.rollingIndexName());
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return StreamSupport.stream(entities.spliterator(), false).toList().stream().map(this::save).collect(Collectors.toList());
    }

    @Override
    public <S extends T> S modifyWithIndexName(S entity, String indexName) {
        return (S)this.openSearchOperations.save(entity, IndexCoordinates.of((String[])new String[]{indexName}));
    }

    @Override
    public <S extends T> S save(S entity) {
        Iterable<S> s;
        String createDateName;
        Date value;
        ElasticSearchIndex elasticSearchIndexAnnotation = (ElasticSearchIndex)AnnotationUtils.findAnnotation(this.entityClazz, ElasticSearchIndex.class);
        if (ReflectionUtil.isExistFieldWithAnnotation(this.entityClass, ElasticSearchCreatedDate.class).booleanValue() && (value = (Date)ReflectionUtil.getValue(entity, createDateName = ReflectionUtil.fieldInfo(this.entityClazz, ElasticSearchCreatedDate.class).getName())) == null) {
            ReflectionUtil.setValue(entity, createDateName, this.generateDate(new Date()));
        }
        if (ReflectionUtil.isExistFieldWithAnnotation(this.entityClass, ElasticSearchUpdateDate.class).booleanValue()) {
            String updateDateName = ReflectionUtil.fieldInfo(this.entityClazz, ElasticSearchUpdateDate.class).getName();
            ReflectionUtil.setValue(entity, updateDateName, this.generateDate(new Date()));
        }
        if (elasticSearchIndexAnnotation == null) {
            return (S)this.openSearchOperations.save(entity);
        }
        if (ReflectionUtil.isExistFieldWithAnnotation(this.entityClass, Id.class).booleanValue()) {
            String idName = ReflectionUtil.fieldInfo(this.entityClazz, Id.class).getName();
            ReflectionUtil.setValue(entity, idName, null);
        }
        if (!(s = this.saveSupport(List.of(entity))).iterator().hasNext()) {
            log.info("\uc800\uc7a5\ud560 \ub370\uc774\ud130\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return entity;
    }

    private Date generateDate(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC+9"));
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of("UTC+9"));
        return Date.from(zonedDateTime.toInstant());
    }

    private <S extends T> Iterable<S> saveSupport(Iterable<S> entities) {
        RecentFieldConvertor<S, Object> recentFieldConvertor;
        log.info("[ \uacf5\ud1b5\uc800\uc7a5\uc18c_\uad6c\ud604\uccb4 :: saveSupport ] entities = {}", entities);
        try {
            recentFieldConvertor = new RecentFieldConvertor<S, Object>(entities, this.entityClass, this.openSearchOperations);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            return entities;
        }
        Map<String, List<S>> recentFalseListIfNotEqual = recentFieldConvertor.listMapGroupByIndex(recentFieldConvertor::setRecentFalseIfNotEqual);
        this.saveRecentFalseList(recentFalseListIfNotEqual);
        Map<String, List<S>> recentFalseListIfDuplicate = recentFieldConvertor.listMapGroupByIndex(recentFieldConvertor::setRecentFalseIfDuplicate);
        this.saveRecentFalseList(recentFalseListIfDuplicate);
        List<Object> recentTrueList = StreamSupport.stream(entities.spliterator(), false).filter(Objects::nonNull).map(recentFieldConvertor::recentTrue).filter(Objects::nonNull).toList();
        return recentTrueList.stream().map(doc -> this.openSearchOperations.save(doc, this.rollingIndexName())).collect(Collectors.toList());
    }

    private <S> void saveRecentFalseList(Map<String, List<S>> recentFalseListMap) {
        recentFalseListMap.forEach((key, values) -> values.forEach(value -> this.openSearchOperations.save(value, IndexCoordinates.of((String[])new String[]{key}))));
    }

    @Override
    public List<T> findRecentDocsByScrollApi(Query query) {
        OpenSearchRestTemplate template = (OpenSearchRestTemplate)this.openSearchOperations;
        IndexCoordinates indexCoordinatesFor = template.getIndexCoordinatesFor(this.entityClazz);
        SearchScrollHits scroll = template.searchScrollStart(60000L, query, this.entityClazz, indexCoordinatesFor);
        String scrollId = scroll.getScrollId();
        ArrayList<Object> entities = new ArrayList<Object>();
        while (scroll.hasSearchHits()) {
            entities.addAll(scroll.getSearchHits().stream().map(SearchHit::getContent).toList());
            scrollId = scroll.getScrollId();
            scroll = template.searchScrollContinue(scrollId, 60000L, this.entityClazz, indexCoordinatesFor);
        }
        assert (scrollId != null);
        template.searchScrollClear(List.of(scrollId));
        return entities;
    }

    @Override
    public List<T> findDocsByScrollApi(Query query) {
        NativeSearchQuery nativeSearchQuery = (NativeSearchQuery)query;
        OpenSearchRestTemplate template = (OpenSearchRestTemplate)this.openSearchOperations;
        IndexCoordinates indexCoordinatesFor = template.getIndexCoordinatesFor(this.entityClazz);
        SearchScrollHits scroll = template.searchScrollStart(60000L, (Query)nativeSearchQuery, this.entityClazz, indexCoordinatesFor);
        String scrollId = scroll.getScrollId();
        ArrayList<Object> entities = new ArrayList<Object>();
        while (scroll.hasSearchHits()) {
            entities.addAll(scroll.getSearchHits().stream().map(SearchHit::getContent).toList());
            scrollId = scroll.getScrollId();
            scroll = template.searchScrollContinue(scrollId, 60000L, this.entityClazz, indexCoordinatesFor);
        }
        assert (scrollId != null);
        template.searchScrollClear(List.of(scrollId));
        return entities;
    }

    @Override
    public DocumentResultWrapper<T> findRecentDocsBySearchAfter(Query query, List<Object> searchAfter) {
        if (searchAfter == null) {
            searchAfter = new ArrayList<Object>();
        }
        SearchHits search = this.openSearchOperations.search(query, this.entityClazz);
        return new DocumentResultWrapper<T>(search, this.entityClazz);
    }

    @Override
    public DocumentResultWrapper<T> findDocsBySearchAfter(Query query, List<Object> searchAfter) {
        if (searchAfter == null) {
            searchAfter = new ArrayList<Object>();
        }
        NativeSearchQuery nativeSearchQuery = (NativeSearchQuery)query;
        if (!searchAfter.isEmpty()) {
            nativeSearchQuery.setSearchAfter(searchAfter);
        }
        SearchHits search = this.openSearchOperations.search((Query)nativeSearchQuery, this.entityClazz);
        return new DocumentResultWrapper<T>(search, this.entityClazz);
    }

    @Override
    public String indexAliasName() {
        IndexCoordinates indexCoordinatesFor = this.openSearchOperations.getIndexCoordinatesFor(this.entityClazz);
        return indexCoordinatesFor.getIndexName();
    }

    @Override
    public void deleteIndexWithDayRange(int day) {
        this.indexWithDayRange(day).forEach(indexName -> {
            log.info("delete-index->{}", indexName);
            this.deleteIndex(IndexCoordinates.of((String[])new String[]{indexName}));
        });
    }

    @Override
    public String deleteDocByEntity(T t) {
        return this.openSearchOperations.delete(t);
    }

    @Override
    public U deleteRecentDocById(U u) {
        this.deleteAllById(List.of(u));
        return u;
    }

    private IndexCoordinates rollingIndexName() {
        Document document = (Document)AnnotationUtils.findAnnotation(this.entityClazz, Document.class);
        if (document != null) {
            IndexCoordinates indexCoordinatesFor = this.openSearchOperations.getIndexCoordinatesFor(this.entityClazz);
            String indexName = indexCoordinatesFor.getIndexName();
            try {
                Method method = ReflectionUtil.methodInfo(this.entityClazz, RollingIndexName.class);
                if (method != null) {
                    Constructor<T> constructor = this.entityClazz.getConstructor(new Class[0]);
                    T t = constructor.newInstance(new Object[0]);
                    return IndexCoordinates.of((String[])new String[]{indexName + "-" + String.valueOf(method.invoke(t, new Object[0]))});
                }
                return IndexCoordinates.of((String[])new String[]{indexName});
            }
            catch (Exception e) {
                return IndexCoordinates.of((String[])new String[]{indexName});
            }
        }
        throw new IllegalArgumentException("\uc778\ub371\uc2a4\uba85\uc744 \ud655\uc778\ud574\uc8fc\uc2dc\uae38 \ubc14\ub78d\ub2c8\ub2e4.");
    }

    private String rollingIndexNameSuffix() {
        String indexName = this.rollingIndexName().getIndexName();
        return Optional.of(indexName.split("-", 2)).filter(a -> ((String[])a).length > 1).map(a -> a[1]).orElse("0000-00-00");
    }

    @Override
    public void mergeWithReindex(int day) {
        Map<String, String[]> indexNameGroupByMonth = this.indexWithDayRange(day).stream().collect(Collectors.groupingBy(str -> str.substring(0, str.length() - 2) + "00")).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toArray(new String[0])));
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setTimeout(TimeValue.MAX_VALUE);
        reindexRequest.setRefresh(true);
        log.info("reindex \uc2dc\uc791");
        indexNameGroupByMonth.forEach((key, value) -> {
            for (String docIndexName : value) {
                try {
                    reindexRequest.setSourceIndices(new String[]{docIndexName});
                    reindexRequest.setDestIndex(key);
                    this.reindexRequest(reindexRequest, 0);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        log.info("reindex \uc885\ub8cc");
        log.info("reindex \uc774\ud6c4 delete \uc2dc\uc791");
        indexNameGroupByMonth.forEach((key, value) -> {
            for (String docIndexName : value) {
                try {
                    this.deleteIndex(IndexCoordinates.of((String[])new String[]{docIndexName}));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        log.info("reindex \uc774\ud6c4 delete \uc885\ub8cc");
    }

    private void reindexRequest(ReindexRequest reindexRequest, int count) {
        try {
            RestHighLevelClient restHighLevelClient = ApplicationContextProvider.getBean(RestHighLevelClient.class);
            restHighLevelClient.reindex(reindexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (count > 9) {
                log.warn("\uc778\ub371\uc2a4 \uba38\uc9c0 \uc694\uccad \uc2dc\ub3c4 \ucc98\ub9ac \ucd08\uacfc");
                log.warn("\uc778\ub371\uc2a4 \uc694\uccad \ubcf8\ubb38 : {}", (Object)reindexRequest);
                throw new IllegalArgumentException(e.getMessage());
            }
            log.info("\uc694\uccad \uc7ac\uc2dc\ub3c4 : {}", (Object)(++count));
            log.info("\uc778\ub371\uc2a4 \uc694\uccad \ubcf8\ubb38 : {}", (Object)reindexRequest);
            this.reindexRequest(reindexRequest, count);
        }
    }

    @Override
    public List<CatIndexVO> catIndexVOList() {
        IndexCoordinates indexCoordinatesFor = this.openSearchOperations.getIndexCoordinatesFor(this.entityClazz);
        String indexName = indexCoordinatesFor.getIndexName();
        RestHighLevelClient restHighLevelClient = ApplicationContextProvider.getBean(RestHighLevelClient.class);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Response response = restHighLevelClient.getLowLevelClient().performRequest(new Request("GET", "/_cat/indices/" + indexName + "?format=json"));
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return (List)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<CatIndexVO>>(this){});
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public Long indexCount() {
        RestHighLevelClient restHighLevelClient = ApplicationContextProvider.getBean(RestHighLevelClient.class);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Response response = restHighLevelClient.getLowLevelClient().performRequest(new Request("GET", "/_alias/" + this.indexAliasName()));
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            return ((HashMap)objectMapper.readValue(responseBody, HashMap.class)).size();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Set<String> indexNames() {
        IndexCoordinates indexCoordinatesFor = this.openSearchOperations.getIndexCoordinatesFor(this.entityClazz);
        String indexName = indexCoordinatesFor.getIndexName();
        IndexOperations indexOperations = this.openSearchOperations.indexOps(IndexCoordinates.of((String[])new String[]{indexName}));
        return indexOperations.getAliasesForIndex(new String[]{indexName}).keySet();
    }

    private List<String> indexWithDayRange(int day) {
        Set<String> indexNames = this.indexNames();
        List<String> days = this.dayList(day);
        return indexNames.stream().filter(indexName -> !days.contains(indexName) && indexName.split("-", 2)[1].replace("-", "").lastIndexOf("00") != 6).collect(Collectors.toList());
    }

    private void deleteIndex(IndexCoordinates indexCoordinates) {
        IndexOperations indexOperations = this.openSearchOperations.indexOps(indexCoordinates);
        indexOperations.delete();
    }

    private String findDateFormat(String date) {
        int n = 0;
        String[] formats = new String[]{"yyyy-MM-dd", "yyyyMMdd"};
        String[] stringArray = formats;
        int n2 = stringArray.length;
        if (n < n2) {
            String format = stringArray[n];
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            try {
                sdf.parse(date);
                return format;
            }
            catch (ParseException ignored) {
                return formats[0];
            }
        }
        return formats[0];
    }

    private List<String> dayList(int range) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -(Math.abs(range) - 1));
        Date daysAgo = calendar.getTime();
        calendar.setTime(daysAgo);
        return IntStream.range(0, range).boxed().map(a -> {
            String day = this.defaultFormater.format(calendar.getTime());
            calendar.add(5, 1);
            return this.indexAliasName() + "-" + day;
        }).collect(Collectors.toList());
    }
}

