/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.account.service;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.account.strategy.AccountStrategy;
import com.arms.api.account.strategy.AlmSelector;
import com.arms.api.account.strategy.CloudJiraAccountStrategy;
import com.arms.api.account.strategy.OnPromiseJiraAccountStrategy;
import com.arms.api.account.strategy.OnPromiseRedmineAccountStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.model.enums.ServerType;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.errors.ErrorCode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountStrategyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccountStrategyService.class);
    private final AlmSelector almSelector;
    private final CloudJiraAccountStrategy cloudJiraAccountStrategy;
    private final OnPromiseJiraAccountStrategy onPromiseJiraAccountStrategy;
    private final OnPromiseRedmineAccountStrategy onPromiseRedmineAccountStrategy;
    private final ServerInfoService serverInfoService;

    public AccountStrategy accountSelector(ServerInfo serverInfo) {
        if (serverInfo == null || serverInfo.getType().isEmpty()) {
            log.error("AccountStrategyService::accountSelector::\uacc4\uc815 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 {}", (Object)ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uacc4\uc815 \uc804\ub7b5 \ub4f1\ub85d Error: serverInfo_\uc720\ud615 " + ErrorCode.SERVER_TYPE_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        ServerType serverType = ServerType.typeValueOf((String)serverInfo.getType());
        if (serverType == ServerType.CLOUD) {
            return this.cloudJiraAccountStrategy;
        }
        if (serverType == ServerType.ON_PREMISS) {
            return this.onPromiseJiraAccountStrategy;
        }
        if (serverType == ServerType.REDMINE_ON_PREMISS) {
            return this.onPromiseRedmineAccountStrategy;
        }
        throw new IllegalArgumentException("\uc11c\ubc84 \uc720\ud615\uc5d0 \uc874\uc7ac \ud558\uc9c0 \uc54a\ub294 \uc694\uccad\uc785\ub2c8\ub2e4.");
    }

    public AlmAccount verifyAccount(ServerInfo serverInfo) throws Exception {
        if (serverInfo == null) {
            log.error("AccountStrategyService::verifyAccount::\uacc4\uc815 \uc815\ubcf4 \uac80\uc99d\ud558\uae30 Error: \uc11c\ubc84\uc8fc\uc18c {}", (Object)ErrorCode.SEARCH_INFO_ERROR.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uacc4\uc815 \uc815\ubcf4 \uac80\uc99d\ud558\uae30  Error: \uc11c\ubc84\uc8fc\uc18c " + ErrorCode.SEARCH_INFO_ERROR.getErrorMsg(new Object[0]));
        }
        this.validateField(serverInfo.getUri(), ErrorCode.SERVER_URI_INFO_ERROR, "\uc11c\ubc84\uc8fc\uc18c");
        this.validateField(serverInfo.getType(), ErrorCode.SERVER_TYPE_INFO_ERROR, "\uc11c\ubc84\uc720\ud615");
        this.validateField(this.serverInfoService.getDecryptPasswordOrToken(serverInfo), ErrorCode.SERVER_PW_OR_API_TOKEN_INFO_ERROR, "API \ud1a0\ud070 \uc815\ubcf4");
        this.validateField(serverInfo.getUserId(), ErrorCode.SERVER_ID_INFO_ERROR, "\uc0ac\uc6a9\uc790 \uc544\uc774\ub514");
        return this.almSelector.verifyAccount(this.accountSelector(serverInfo), serverInfo);
    }

    public AlmAccount getAccount(String connectId) throws Exception {
        if (connectId == null) {
            log.error("AccountStrategyService::getAccount::\uacc4\uc815 \uc815\ubcf4 \uac00\uc838\uc624\uae30 Error: \uc5f0\uacb0_\uc544\uc774\ub514 {} ", (Object)ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uacc4\uc815 \uc815\ubcf4 \uac00\uc838\uc624\uae30  Error: \uc5f0\uacb0_\uc544\uc774\ub514 " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
        }
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        return this.almSelector.getAccount(this.accountSelector(serverInfo), connectId);
    }

    private void validateField(String field, ErrorCode errorCode, String fieldName) {
        if (field == null || field.isEmpty()) {
            log.error("AccountStrategyService::validateField::\uacc4\uc815 \uc815\ubcf4 \uac80\uc99d\ud558\uae30 Error: {} {}", (Object)fieldName, (Object)errorCode.getErrorMsg(new Object[0]));
            throw new IllegalArgumentException("\uacc4\uc815 \uc815\ubcf4 \uac80\uc99d\ud558\uae30 Error: " + fieldName + " " + errorCode.getErrorMsg(new Object[0]));
        }
    }

    @Generated
    public AccountStrategyService(AlmSelector almSelector, CloudJiraAccountStrategy cloudJiraAccountStrategy, OnPromiseJiraAccountStrategy onPromiseJiraAccountStrategy, OnPromiseRedmineAccountStrategy onPromiseRedmineAccountStrategy, ServerInfoService serverInfoService) {
        this.almSelector = almSelector;
        this.cloudJiraAccountStrategy = cloudJiraAccountStrategy;
        this.onPromiseJiraAccountStrategy = onPromiseJiraAccountStrategy;
        this.onPromiseRedmineAccountStrategy = onPromiseRedmineAccountStrategy;
        this.serverInfoService = serverInfoService;
    }
}

