/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.account.strategy;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.account.strategy.AccountStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorCode;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnPromiseJiraAccountStrategy
implements AccountStrategy {
    private final Logger \ub85c\uadf8 = LoggerFactory.getLogger(this.getClass());
    private final ServerInfoService serverInfoService;
    private final JiraUtil jiraUtil;

    @Autowired
    public OnPromiseJiraAccountStrategy(ServerInfoService ServerInfoService2, JiraUtil JiraUtil2) {
        this.serverInfoService = ServerInfoService2;
        this.jiraUtil = JiraUtil2;
    }

    public AlmAccount verifyAccount(ServerInfo serverInfo) {
        this.\ub85c\uadf8.info("\uc628\ud504\ub77c\ubbf8\uc2a4_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac80\uc99d");
        return this.\uacc4\uc815\uc815\ubcf4_\uc870\ud68c(serverInfo);
    }

    public AlmAccount getAccount(String connectId) {
        this.\ub85c\uadf8.info("\uc628\ud504\ub77c\ubbf8\uc2a4_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac00\uc838\uc624\uae30, \uc5f0\uacb0_\uc544\uc774\ub514: {}", (Object)connectId);
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        return this.\uacc4\uc815\uc815\ubcf4_\uc870\ud68c(serverInfo);
    }

    private AlmAccount \uacc4\uc815\uc815\ubcf4_\uc870\ud68c(ServerInfo serverInfo) {
        try {
            String uri = serverInfo.getUri();
            String serverType = serverInfo.getType();
            String apiToken = this.serverInfoService.getDecryptPasswordOrToken(serverInfo);
            String userId = serverInfo.getUserId();
            this.\ub85c\uadf8.info("\uc628\ud504\ub77c\ubbf8\uc2a4_\uc9c0\ub77c_\uacc4\uc815\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uc870\ud68c, \uc11c\ubc84 \uc8fc\uc18c: {}, \uc11c\ubc84 \ud0c0\uc785: {}, apiToken: {}, \uc720\uc800 \uc544\uc774\ub514: {}", new Object[]{uri, serverType, apiToken, userId});
            JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(uri, userId, this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            User \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc = (User)restClient.getUserClient().getUser(userId).claim();
            if (\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc == null) {
                this.\ub85c\uadf8.error("\uc628\ud504\ub77c\ubbf8\uc2a4 \uc9c0\ub77c \uacc4\uc815 \uc870\ud68c \uacb0\uacfc\uac00 Null\uc785\ub2c8\ub2e4.");
                throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
            }
            return this.\uacc4\uc815\uc815\ubcf4_\ub370\uc774\ud130\ub85c_\ubcc0\ud658(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc);
        }
        catch (Exception e) {
            this.\ub85c\uadf8.error("\uc628\ud504\ub77c\ubbf8\uc2a4 \uacc4\uc815 \uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage());
            throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
        }
    }

    private AlmAccount \uacc4\uc815\uc815\ubcf4_\ub370\uc774\ud130\ub85c_\ubcc0\ud658(User \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc) {
        AlmAccount AlmAccount2 = new AlmAccount();
        AlmAccount2.setSelf(String.valueOf(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getSelf()));
        AlmAccount2.setName(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getName());
        AlmAccount2.setEmailAddress(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getEmailAddress());
        AlmAccount2.setDisplayName(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getDisplayName());
        AlmAccount2.setActive(Boolean.valueOf(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.isActive()));
        return AlmAccount2;
    }
}

