/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.analysis.time.controller;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.analysis.time.dto.TimeDTO;
import com.arms.api.analysis.time.service.AnalysisTime;
import com.arms.api.analysis.time.vo.AlmIssueStatVO;
import com.arms.api.analysis.time.vo.HeatMapVO;
import com.arms.api.analysis.time.vo.RidgeLineVO;
import com.arms.api.analysis.time.vo.ScatterChartVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/analysis-time"})
public class AnalysisTimeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisTimeController.class);
    private final AnalysisTime analysisTime;

    @PostMapping(value={"/updated-issue/scatter-data"})
    public ResponseEntity<List<ScatterChartVO>> getScatterData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getScatterData(timeDTO));
    }

    @PostMapping(value={"/updated-issue/heatmap-data"})
    public ResponseEntity<HeatMapVO> getHeatMapDataByUpdated(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getHeatMapDataByUpdated(timeDTO));
    }

    @PostMapping(value={"/updated-issue/heatmap-data-cardinality"})
    public ResponseEntity<?> getHeatmapData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getDateHistogramCardinalityData(timeDTO));
    }

    @PostMapping(value={"/updated-issue/multi-combination-data"})
    public ResponseEntity<List<AlmIssueStatVO>> getMultiCombinationChartData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getMultiCombinationChartData(timeDTO));
    }

    @PostMapping(value={"/updated-timeline"})
    public ResponseEntity<List<AlmIssueEntity>> getUpdatedReqIssueByDateRange(@RequestBody TimeAggrDTO timeAggrDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getUpdatedReqIssueByDateRange(timeAggrDTO));
    }

    @PostMapping(value={"/updated-ridgeline"})
    public ResponseEntity<List<RidgeLineVO>> getRidgeLineData(@RequestBody TimeDTO timeDTO) {
        return ResponseEntity.ok((Object)this.analysisTime.getRidgeLineData(timeDTO));
    }

    @Generated
    public AnalysisTimeController(AnalysisTime analysisTime) {
        this.analysisTime = analysisTime;
    }
}

