/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.strategy;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.CloudJiraIssueCreationDTO;
import com.arms.api.issue.almapi.model.dto.CloudJiraIssueFieldDTO;
import com.arms.api.issue.almapi.model.dto.HistoriesDTO;
import com.arms.api.issue.almapi.model.dto.IssueCreationFieldsDTO;
import com.arms.api.issue.almapi.model.dto.IssueDTO;
import com.arms.api.issue.almapi.model.dto.ParentDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOCollection;
import com.arms.api.issue.almapi.model.vo.CloudJiraIssueVO;
import com.arms.api.issue.almapi.model.vo.CloudJiraIssueVOCollection;
import com.arms.api.issue.almapi.model.vo.CloudJiraIssues;
import com.arms.api.issue.almapi.model.vo.IssueFieldData;
import com.arms.api.issue.almapi.model.vo.IssueLink;
import com.arms.api.issue.almapi.model.vo.JiraIssueMigData;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.ChangeLogVO;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.CloudJiraIssueRawDataVO;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.InwardIssue;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.OutwardIssue;
import com.arms.api.issue.almapi.service.CategoryMappingService;
import com.arms.api.issue.almapi.strategy.IssueSaveTemplate;
import com.arms.api.issue.almapi.strategy.IssueStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.LRUMap;
import com.arms.api.util.StreamUtil;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.alm.dto.CloudJiraIssueCreationFieldMetadata;
import com.arms.api.util.aspect.SlackSendAlarm;
import com.arms.api.util.errors.ErrorCode;
import com.arms.api.util.errors.ErrorLogUtil;
import com.arms.api.util.response.CommonResponse;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@Component(value="CLOUD")
public class CloudJiraIssueStrategy
implements IssueStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJiraIssueStrategy.class);
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final CategoryMappingService categoryMappingService;
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final ServerInfoService serverInfoService;
    private final IssueSaveTemplate issueSaveTemplate;

    public AlmIssueVO createIssue(AlmIssueDTO almIssueDTO) {
        AlmIssueVO almIssueVO;
        IssueCreationFieldsDTO issueCreationFieldsDTO = almIssueDTO.getFields();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        if (issueCreationFieldsDTO == null) {
            String errorMessage = String.format("%s :: %s \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ub370\uc774\ud130\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
            throw new IllegalArgumentException(ErrorCode.REQUEST_BODY_ERROR_CHECK.getErrorMsg(new Object[0]) + " :: " + errorMessage);
        }
        String projectKeyOrId = null;
        String issueTypeId = null;
        if (issueCreationFieldsDTO.getProject() != null && StringUtils.isNotEmpty((CharSequence)issueCreationFieldsDTO.getProject().getId())) {
            projectKeyOrId = issueCreationFieldsDTO.getProject().getId();
        }
        if (issueCreationFieldsDTO.getIssuetype() != null && StringUtils.isNotEmpty((CharSequence)issueCreationFieldsDTO.getIssuetype().getId())) {
            issueTypeId = issueCreationFieldsDTO.getIssuetype().getId();
        }
        if (StringUtils.isEmpty(projectKeyOrId) || StringUtils.isEmpty(issueTypeId)) {
            String errorMessage = String.format("%s :: %s \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ud655\uc778\uc5d0 \ud544\uc694\ud55c \ud504\ub85c\uc81d\ud2b8 \uc544\uc774\ub514, \uc774\uc288\uc720\ud615 \uc544\uc774\ub514\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
            throw new IllegalArgumentException(errorMessage);
        }
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        Map fieldMetadataMap = this.jiraUtil.checkFieldMetadata(webClient, projectKeyOrId, issueTypeId);
        CloudJiraIssueFieldDTO fieldDTO = this.validateAndAddFields(issueCreationFieldsDTO, fieldMetadataMap, serverInfo, projectKeyOrId, issueTypeId);
        CloudJiraIssueCreationDTO issueCreationDTO = new CloudJiraIssueCreationDTO();
        issueCreationDTO.setFields(fieldDTO);
        String endpoint = this.jiraApi.getEndpoint().getIssue().getBase();
        try {
            almIssueVO = (AlmIssueVO)this.jiraUtil.post(webClient, endpoint, (Object)issueCreationDTO, AlmIssueVO.class).block();
            log.info("{}[{}], \ud504\ub85c\uc81d\ud2b8 : {}, \uc774\uc288\uc720\ud615 : {}, \uc0dd\uc131 \ud544\ub4dc : {}, \uc774\uc288 \uc0dd\uc131\ud558\uae30", new Object[]{serverInfo.getType(), serverInfo.getUri(), projectKeyOrId, issueTypeId, issueCreationDTO});
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s],  \ud504\ub85c\uc81d\ud2b8[%s], \uc774\uc288\uc720\ud615[%s], \uc0dd\uc131 \ud544\ub4dc :: \uc774\uc288 \uc0dd\uc131\ud558\uae30 \uc911 \uc624\ub958", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId, issueTypeId));
            throw new IllegalArgumentException(errorMessage);
        }
        if (almIssueVO == null) {
            String errorMessage = String.format("%s[%s], \ud504\ub85c\uc81d\ud2b8[%s], \uc774\uc288\uc720\ud615[%s], \uc0dd\uc131 \ud544\ub4dc :: {}, \uc0dd\uc131\ub41c \uc774\uc288 \ub370\uc774\ud130\uac00 NULL \uc785\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId, issueTypeId);
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        return almIssueVO;
    }

    public Map<String, Object> updateIssue(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueKeyOrId;
            HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
            IssueCreationFieldsDTO \ud544\ub4dc_\ub370\uc774\ud130 = almIssueDTO.getFields();
            CloudJiraIssueCreationDTO \uc218\uc815_\ub370\uc774\ud130 = new CloudJiraIssueCreationDTO();
            CloudJiraIssueFieldDTO \ud074\ub77c\uc6b0\ub4dc_\ud544\ub4dc_\ub370\uc774\ud130 = new CloudJiraIssueFieldDTO();
            if (\ud544\ub4dc_\ub370\uc774\ud130.getSummary() != null) {
                \ud074\ub77c\uc6b0\ub4dc_\ud544\ub4dc_\ub370\uc774\ud130.setSummary(\ud544\ub4dc_\ub370\uc774\ud130.getSummary());
            }
            if (\ud544\ub4dc_\ub370\uc774\ud130.getDescription() != null) {
                \ud074\ub77c\uc6b0\ub4dc_\ud544\ub4dc_\ub370\uc774\ud130.setDescription(this.\ub0b4\uc6a9_\ubcc0\ud658(\ud544\ub4dc_\ub370\uc774\ud130.getDescription()));
            }
            if (\ud544\ub4dc_\ub370\uc774\ud130.getLabels() != null) {
                \ud074\ub77c\uc6b0\ub4dc_\ud544\ub4dc_\ub370\uc774\ud130.setLabels(\ud544\ub4dc_\ub370\uc774\ud130.getLabels());
            }
            \uc218\uc815_\ub370\uc774\ud130.setFields(\ud074\ub77c\uc6b0\ub4dc_\ud544\ub4dc_\ub370\uc774\ud130);
            CommonResponse.ApiResult \uc751\ub2f5_\uacb0\uacfc = this.jiraUtil.executePut(webClient, endpoint, (Object)\uc218\uc815_\ub370\uc774\ud130);
            if (\uc751\ub2f5_\uacb0\uacfc.isSuccess()) {
                \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                \uacb0\uacfc.put("message", "\uc774\uc288 \uc218\uc815 \uc131\uacf5");
            } else {
                \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                \uacb0\uacfc.put("message", \uc751\ub2f5_\uacb0\uacfc.getError().getMessage());
            }
            return \uacb0\uacfc;
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc774\uc288_\uc218\uc815\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException(ErrorCode.ISSUE_MODIFICATION_ERROR.getErrorMsg(new Object[0]) + " :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    public Map<String, Object> updateIssueStatus(AlmIssueDTO almIssueDTO) {
        String \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 = null;
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueKeyOrId + "/transitions";
            HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
            \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 = this.\uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30(almIssueDTO);
            if (\uc774\uc288\uc804\ud658_\uc544\uc774\ub514 != null) {
                JiraIssueMigData.Transition \uc804\ud658 = JiraIssueMigData.Transition.builder().id(\uc774\uc288\uc804\ud658_\uc544\uc774\ub514).build();
                JiraIssueMigData \uc218\uc815_\ub370\uc774\ud130 = JiraIssueMigData.builder().transition(\uc804\ud658).build();
                CommonResponse.ApiResult \uc751\ub2f5_\uacb0\uacfc = this.jiraUtil.executePost(webClient, endpoint, (Object)\uc218\uc815_\ub370\uc774\ud130);
                if (\uc751\ub2f5_\uacb0\uacfc.isSuccess()) {
                    \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                    \uacb0\uacfc.put("message", "\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd \uc131\uacf5");
                } else {
                    \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                    \uacb0\uacfc.put("message", \uc751\ub2f5_\uacb0\uacfc.getError().getMessage());
                }
            } else {
                String \uc5d0\ub7ec\ub85c\uadf8 = "\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + almIssueDTO.getStatusId() + ") :: \ud574\ub2f9 \uc5c5\ubb34 \ud750\ub984\uc73c\ub85c \ubcc0\uacbd\uc774 \ubd88\uac00\ub2a5 \ud569\ub2c8\ub2e4.";
                log.error(\uc5d0\ub7ec\ub85c\uadf8);
                \uacb0\uacfc.put("success", false);
                \uacb0\uacfc.put("message", "\ubcc0\uacbd\ud560 \uc774\uc288 \uc0c1\ud0dc\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            return \uacb0\uacfc;
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + almIssueDTO.getStatusId() + ") :: \uc804\ud658 \uc544\uc774\ub514(" + \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 + ") :: \uc774\uc288_\uc0c1\ud0dc_\ubcc0\uacbd\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException(ErrorCode.ISSUE_TRANSITION_ERROR.getErrorMsg(new Object[0]) + " :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    public String \uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30(AlmIssueDTO almIssueDTO) {
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        String statusId = almIssueDTO.getStatusId();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueKeyOrId + "/transitions";
            JiraIssueMigData jiraIssueMigData = (JiraIssueMigData)this.jiraUtil.get(webClient, endpoint, JiraIssueMigData.class).block();
            return Optional.ofNullable(jiraIssueMigData).map(JiraIssueMigData::getTransitions).orElse(Collections.emptyList()).stream().filter(data -> {
                if (data.getTo() != null && !StringUtils.isBlank((CharSequence)data.getTo().getId())) {
                    return statusId.equals(data.getTo().getId());
                }
                return false;
            }).findFirst().map(JiraIssueMigData.Transition::getId).orElse(null);
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + statusId + ") :: \uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException(ErrorCode.ISSUE_TRANSITION_RETRIEVAL_ERROR.getErrorMsg(new Object[0]) + " :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    public Map<String, Object> deleteIssue(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            boolean \ud558\uc704\uc774\uc288_\uc0ad\uc81c\uc720\ubb34 = this.jiraApi.getParameter().isDeleteSubtasks();
            String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueKeyOrId + "?deleteSubtasks=" + \ud558\uc704\uc774\uc288_\uc0ad\uc81c\uc720\ubb34;
            HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
            CommonResponse.ApiResult \uc751\ub2f5_\uacb0\uacfc = this.jiraUtil.executeDelete(webClient, endpoint);
            if (\uc751\ub2f5_\uacb0\uacfc.isSuccess()) {
                \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                \uacb0\uacfc.put("message", "\uc774\uc288 \uc0ad\uc81c \uc131\uacf5");
            } else {
                \uacb0\uacfc.put("success", \uc751\ub2f5_\uacb0\uacfc.isSuccess());
                \uacb0\uacfc.put("message", \uc751\ub2f5_\uacb0\uacfc.getError().getMessage());
            }
            return \uacb0\uacfc;
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc774\uc288_\uc218\uc815\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException(ErrorCode.ISSUE_MODIFICATION_ERROR.getErrorMsg(new Object[0]) + " :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    public CloudJiraIssueFieldDTO.\ub0b4\uc6a9 \ub0b4\uc6a9_\ubcc0\ud658(String \uc785\ub825_\ub370\uc774\ud130) {
        ArrayList<CloudJiraIssueFieldDTO.\ucf58\ud150\uce20> \ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8 = new ArrayList<CloudJiraIssueFieldDTO.\ucf58\ud150\uce20>();
        String URL_\uad6c\ubd84\uc790 = "\uc790\uc138\ud55c \uc694\uad6c\uc0ac\ud56d \ub0b4\uc6a9 \ud655\uc778 \u21d2";
        String \ucd94\ucd9c\ub41c_URL = this.extractRequirementUrl(\uc785\ub825_\ub370\uc774\ud130);
        if (\ucd94\ucd9c\ub41c_URL != null && \uc785\ub825_\ub370\uc774\ud130.contains(URL_\uad6c\ubd84\uc790)) {
            int URL_\uad6c\ubd84\uc790_\uc704\uce58 = \uc785\ub825_\ub370\uc774\ud130.indexOf(URL_\uad6c\ubd84\uc790);
            String \uc55e\ubd80\ubd84_\ud14d\uc2a4\ud2b8 = \uc785\ub825_\ub370\uc774\ud130.substring(0, URL_\uad6c\ubd84\uc790_\uc704\uce58).trim();
            int URL_\ub05d_\uc704\uce58 = \uc785\ub825_\ub370\uc774\ud130.indexOf(\ucd94\ucd9c\ub41c_URL) + \ucd94\ucd9c\ub41c_URL.length();
            String \ub4b7\ubd80\ubd84_\ud14d\uc2a4\ud2b8 = \uc785\ub825_\ub370\uc774\ud130.substring(URL_\ub05d_\uc704\uce58).trim();
            if (!\uc55e\ubd80\ubd84_\ud14d\uc2a4\ud2b8.isEmpty()) {
                \ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8.add(this.\ud14d\uc2a4\ud2b8_\ucf58\ud150\uce20_\uc0dd\uc131(\uc55e\ubd80\ubd84_\ud14d\uc2a4\ud2b8));
            }
            ArrayList<CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c> \ub9c1\ud06c_\ucf58\ud150\uce20_\uc544\uc774\ud15c_\ub9ac\uc2a4\ud2b8 = new ArrayList<CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c>();
            \ub9c1\ud06c_\ucf58\ud150\uce20_\uc544\uc774\ud15c_\ub9ac\uc2a4\ud2b8.add(CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c.builder().text(URL_\uad6c\ubd84\uc790 + " ").type("text").build());
            CloudJiraIssueFieldDTO.\ub9c8\ud06c_\uc18d\uc131 \ub9c1\ud06c_\uc18d\uc131 = CloudJiraIssueFieldDTO.\ub9c8\ud06c_\uc18d\uc131.builder().href(\ucd94\ucd9c\ub41c_URL).build();
            CloudJiraIssueFieldDTO.\ub9c8\ud06c \ub9c1\ud06c_\ub9c8\ud06c = CloudJiraIssueFieldDTO.\ub9c8\ud06c.builder().type("link").attrs(\ub9c1\ud06c_\uc18d\uc131).build();
            \ub9c1\ud06c_\ucf58\ud150\uce20_\uc544\uc774\ud15c_\ub9ac\uc2a4\ud2b8.add(CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c.builder().text(\ucd94\ucd9c\ub41c_URL).type("text").marks(List.of(\ub9c1\ud06c_\ub9c8\ud06c)).build());
            \ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8.add(CloudJiraIssueFieldDTO.\ucf58\ud150\uce20.builder().content(\ub9c1\ud06c_\ucf58\ud150\uce20_\uc544\uc774\ud15c_\ub9ac\uc2a4\ud2b8).type("paragraph").build());
            if (!\ub4b7\ubd80\ubd84_\ud14d\uc2a4\ud2b8.isEmpty()) {
                \ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8.add(this.\ud14d\uc2a4\ud2b8_\ucf58\ud150\uce20_\uc0dd\uc131(\ub4b7\ubd80\ubd84_\ud14d\uc2a4\ud2b8));
            }
        } else {
            \ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8.add(this.\ud14d\uc2a4\ud2b8_\ucf58\ud150\uce20_\uc0dd\uc131(\uc785\ub825_\ub370\uc774\ud130));
        }
        return CloudJiraIssueFieldDTO.\ub0b4\uc6a9.builder().content(\ucf58\ud150\uce20_\ub9ac\uc2a4\ud2b8).type("doc").version(Integer.valueOf(1)).build();
    }

    private CloudJiraIssueFieldDTO.\ucf58\ud150\uce20 \ud14d\uc2a4\ud2b8_\ucf58\ud150\uce20_\uc0dd\uc131(String \ud14d\uc2a4\ud2b8) {
        CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c \ucf58\ud150\uce20_\uc544\uc774\ud15c2 = CloudJiraIssueFieldDTO.\ucf58\ud150\uce20_\uc544\uc774\ud15c.builder().text(\ud14d\uc2a4\ud2b8).type("text").build();
        return CloudJiraIssueFieldDTO.\ucf58\ud150\uce20.builder().content(List.of(\ucf58\ud150\uce20_\uc544\uc774\ud15c2)).type("paragraph").build();
    }

    public boolean isExistIssue(AlmIssueDTO almIssueDTO) {
        try {
            AlmIssueVO issue = this.getIssueVO(almIssueDTO, false);
            return issue != null && issue.getKey().equals(almIssueDTO.getIssueKeyOrId());
        }
        catch (Exception e) {
            return false;
        }
    }

    public AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO) {
        return this.getIssueVO(almIssueDTO, true);
    }

    private AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO, boolean convertFlag) {
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueKeyOrId + "?" + this.jiraApi.getParameter().getFields();
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO = (CloudJiraIssueRawDataVO)this.jiraUtil.getWithRawData(webClient, endpoint, CloudJiraIssueRawDataVO.class);
            if (convertFlag) {
                return CloudJiraIssueVO.builder().cloudJiraIssueRawDataVO(cloudJiraIssueRawDataVO).build().toAlmIssueVO();
            }
            return AlmIssueVO.builder().key(Optional.ofNullable(cloudJiraIssueRawDataVO).map(CloudJiraIssueRawDataVO::getKey).orElseThrow(() -> new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."))).build();
        }
        catch (Exception e) {
            ErrorLogUtil.exceptionLogging((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<AlmIssueEntity> discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO) {
        LRUMap lruMap = new LRUMap(10000);
        LRUMap lruParentKeyTraceMap = new LRUMap(10000);
        return this.issueSaveTemplate.discoveryIncrementALmIssueAndGetReqAlmIssueEntities(almIssueIncrementDTO, arg_0 -> this.lambda$discoveryIssueAndGetReqEntities$2((Map)lruMap, (Map)lruParentKeyTraceMap, arg_0));
    }

    private AlmIssueVOCollection discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO, Map<String, CloudJiraIssueRawDataVO> lruMap, Map<String, List<CloudJiraIssueRawDataVO>> parentKeyTraceMap) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List cloudJiraIssueRawDataVOS = this.fetchIssuesFromDate(almIssueIncrementDTO, webClient);
            cloudJiraIssueRawDataVOS.forEach(a -> lruMap.put(a.getKey(), (CloudJiraIssueRawDataVO)a));
            List almIssueEntities = cloudJiraIssueRawDataVOS.stream().flatMap(a -> this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)this.recentIdByNewKey(serverInfo, a.getKey()))).toDocs().stream()).toList();
            List listByParentReqKey = almIssueEntities.stream().filter(AlmIssueEntity::izReqFalse).filter(a -> !ObjectUtils.isEmpty((Object)a.getParentReqKey())).flatMap(hit -> this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)hit.getParentReqKey()).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs().stream()).toList();
            ArrayList<AlmIssueEntity> isReqList = new ArrayList<AlmIssueEntity>(almIssueEntities.stream().filter(AlmIssueEntity::izReqTrue).toList());
            isReqList.addAll(listByParentReqKey);
            List isReqListDistinct = isReqList.stream().distinct().toList();
            HashSet<String> visited = new HashSet<String>();
            for (AlmIssueEntity almIssueEntity : isReqListDistinct) {
                LinkedList<String> queue = new LinkedList<String>();
                Optional.ofNullable(almIssueEntity.getLinkedIssues()).ifPresent(queue::addAll);
                queue.add(almIssueEntity.getRecentId());
                while (!queue.isEmpty()) {
                    String queueValue = (String)queue.poll();
                    String key = Optional.ofNullable(queueValue).map(element -> {
                        if (element.split("_").length == 3) {
                            return element.split("_")[2];
                        }
                        return element;
                    }).orElse(queueValue);
                    if (!visited.contains(key) && !ObjectUtils.isEmpty((Object)key)) {
                        String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + key + "?" + this.jiraApi.getParameter().getFields();
                        try {
                            IssueDTO issueDTO = IssueDTO.builder().key(key).build();
                            CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO2 = this.issueList(lruMap, issueDTO, webClient, endpoint);
                            lruMap.put(cloudJiraIssueRawDataVO2.getKey(), cloudJiraIssueRawDataVO2);
                        }
                        catch (WebClientResponseException.NotFound e) {
                            log.info("cloud jira not found key : {} ", (Object)key);
                            List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toHitDocs();
                            for (SearchHit hitDoc : hitDocs) {
                                AlmIssueEntity content = (AlmIssueEntity)hitDoc.getContent();
                                content.setRecent(false);
                                log.info("delete:key:{}", (Object)content.getKey());
                                this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, hitDoc.getIndex());
                            }
                        }
                        List docsByParentReqKey = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"parentReqKey", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs();
                        docsByParentReqKey.forEach(doc -> {
                            queue.add(doc.getRecentId());
                            queue.addAll(doc.getLinkedIssues());
                        });
                        List docsByKey = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs();
                        docsByKey.forEach(doc -> queue.add(doc.getUpperKey()));
                    }
                    visited.add(key);
                    Optional.ofNullable(lruMap.get(key)).ifPresent(cloudJiraIssueRawDataVOS::add);
                }
            }
            CloudJiraIssueVOCollection cloudJiraIssueVOCollection = new CloudJiraIssueVOCollection(cloudJiraIssueRawDataVOS.stream().distinct().flatMap(cloudJiraIssueRawDataVO -> this.incrementTraceArmsIssueVOS(lruMap, parentKeyTraceMap, cloudJiraIssueRawDataVO, serverInfo, webClient).stream()).map(cloudJiraIssueVO -> {
                if (!cloudJiraIssueRawDataVOS.contains(cloudJiraIssueVO.getCloudJiraIssueRawDataVO())) {
                    return cloudJiraIssueVO.markAsExcludedFromSave();
                }
                return cloudJiraIssueVO;
            }).toList());
            List cloudJiraIssueVOS = cloudJiraIssueVOCollection.appliedLinkedIssuePdServiceVO();
            this.deleteUnrelatedEntities(cloudJiraIssueVOS, cloudJiraIssueRawDataVOS);
            return this.convertIncrementCloudJiraIssueToAlmIssue(cloudJiraIssueVOS);
        }
        catch (Exception e) {
            log.error("\uc99d\ubd84 \ub370\uc774\ud130 \uc218\uc9d1\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") \uc99d\ubd84 \uc774\uc288 \uc218\uc9d1 \uc911 \uc624\ub958"));
            throw new IllegalArgumentException("\uc99d\ubd84 \ub370\uc774\ud130 \uc218\uc9d1\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private AlmIssueVOCollection convertIncrementCloudJiraIssueToAlmIssue(List<CloudJiraIssueVO> cloudJiraIssueVOs) {
        return new AlmIssueVOCollection(cloudJiraIssueVOs.stream().map(arg_0 -> this.convertIncrementCloudJiraIssueToAlmIssue(arg_0)).toList());
    }

    private AlmIssueVO convertIncrementCloudJiraIssueToAlmIssue(CloudJiraIssueVO cloudJiraIssueVO) {
        String armsStateCategory = this.getArmsStateCategory(cloudJiraIssueVO.getServerInfo(), cloudJiraIssueVO.cloudJiraIssueField());
        return cloudJiraIssueVO.toAlmIssueVOByStateCategory(armsStateCategory);
    }

    private void deleteUnrelatedEntities(List<CloudJiraIssueVO> cloudJiraIssueVOS, List<CloudJiraIssueRawDataVO> results) {
        results.stream().filter(a -> !cloudJiraIssueVOS.contains(CloudJiraIssueVO.builder().cloudJiraIssueRawDataVO(a).build())).forEach(a -> cloudJiraIssueVOS.stream().findFirst().ifPresent(b -> {
            List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)b.recentId(String.valueOf(a.getKey())))).toHitDocs();
            for (SearchHit hitDoc : hitDocs) {
                AlmIssueEntity content = (AlmIssueEntity)hitDoc.getContent();
                content.setRecent(false);
                log.info("delete:::key:::{}", (Object)content.getKey());
                this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, hitDoc.getIndex());
            }
        }));
    }

    private List<CloudJiraIssueVO> incrementTraceArmsIssueVOS(Map<String, CloudJiraIssueRawDataVO> lruMap, Map<String, List<CloudJiraIssueRawDataVO>> parentKeyTraceMap, CloudJiraIssueRawDataVO currentIssue, ServerInfo serverInfo, WebClient webClient) {
        LinkedList<IssueDTO> queue = new LinkedList<IssueDTO>();
        queue.add(this.createIssueDTO(currentIssue));
        lruMap.put(currentIssue.getKey(), currentIssue);
        HashSet<CallSite> recentIds = new HashSet<CallSite>();
        HashSet<String> visited = new HashSet<String>();
        while (!queue.isEmpty()) {
            try {
                IssueDTO issueDTO = (IssueDTO)queue.poll();
                String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + issueDTO.getKey() + "?" + this.jiraApi.getParameter().getFields();
                CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO = this.issueList(lruMap, issueDTO, webClient, endpoint);
                if (cloudJiraIssueRawDataVO.getKey() != null) {
                    lruMap.put(cloudJiraIssueRawDataVO.getKey(), cloudJiraIssueRawDataVO);
                    String recentId = serverInfo.getConnectId() + "_" + cloudJiraIssueRawDataVO.getFields().getProject().getKey() + "_" + cloudJiraIssueRawDataVO.getKey();
                    recentIds.add((CallSite)((Object)recentId));
                }
                if (visited.contains(cloudJiraIssueRawDataVO.getKey())) continue;
                queue.add(this.createIssueParentTraceDTO(cloudJiraIssueRawDataVO));
                this.fetchSubTaskIssuesByKey(parentKeyTraceMap, cloudJiraIssueRawDataVO.getKey(), webClient).forEach(issue -> queue.add(this.createIssueDTO(issue)));
                this.linkedIssueQueueRegister(cloudJiraIssueRawDataVO, queue, visited);
                visited.add(cloudJiraIssueRawDataVO.getKey());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"recent_id", recentIds.stream().toList()).andTermQueryFilter("isReq", (Object)true)).toDocs().stream().map(reqIssueEntity -> {
            String rootParentKey = this.findRootParentKey(lruMap, currentIssue.getKey(), webClient);
            return CloudJiraIssueVO.builder().cloudJiraIssueRawDataVO(currentIssue).almIssueWithRequirementDTO(Optional.ofNullable(this.isSelfCreatedIssue(reqIssueEntity, rootParentKey)).orElseGet(() -> new AlmIssueWithRequirementDTO(reqIssueEntity))).serverInfo(serverInfo).build();
        }).toList();
    }

    private AlmIssueWithRequirementDTO isSelfCreatedIssue(AlmIssueEntity almIssueEntity, String rootParentKey) {
        AlmIssueWithRequirementDTO reqDTO = new AlmIssueWithRequirementDTO(almIssueEntity, rootParentKey);
        AlmIssueEntity recentDocByRecentId = (AlmIssueEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)reqDTO.recentId()));
        if (rootParentKey != null && (recentDocByRecentId.getKey() == null || recentDocByRecentId.izReqFalse())) {
            return reqDTO;
        }
        return null;
    }

    private String findRootParentKey(Map<String, CloudJiraIssueRawDataVO> lruMap, String startKey, WebClient webClient) {
        String findKey = startKey;
        String parentKey = null;
        while (findKey != null) {
            String endpoint = this.jiraApi.getEndpoint().getIssue().getBase() + "/" + findKey + "?" + this.jiraApi.getParameter().getFields();
            CloudJiraIssueRawDataVO issue = this.issueList(lruMap, IssueDTO.builder().key(findKey).build(), webClient, endpoint);
            if (!this.isExistParentKey(issue)) break;
            findKey = parentKey = issue.getParentKey();
        }
        return parentKey;
    }

    private boolean isExistParentKey(CloudJiraIssueRawDataVO issue) {
        return issue.getParentKey() != null;
    }

    private IssueDTO createIssueDTO(CloudJiraIssueRawDataVO issue) {
        return IssueDTO.builder().key(String.valueOf(issue.getKey())).fromKey(String.valueOf(issue.getKey())).build();
    }

    private IssueDTO createIssueParentTraceDTO(CloudJiraIssueRawDataVO issue) {
        return IssueDTO.builder().key(String.valueOf(Optional.ofNullable(issue.getFields()).map(a -> {
            ParentDTO parent = issue.getFields().getParent();
            if (parent != null) {
                return parent.getKey();
            }
            return issue.getKey();
        }).orElseGet(() -> ((CloudJiraIssueRawDataVO)issue).getKey()))).fromKey(String.valueOf(issue.getKey())).build();
    }

    private void linkedIssueQueueRegister(CloudJiraIssueRawDataVO issue, Queue<IssueDTO> queue, Set<String> visited) {
        List<IssueLink> issueRelations = StreamUtil.toStream((Iterable)issue.getFields().getIssuelinks()).toList();
        issueRelations.forEach(element -> {
            InwardIssue inwardIssue;
            OutwardIssue outwardIssue = element.getOutwardIssue();
            if (outwardIssue != null) {
                IssueDTO reverseRelation;
                String relationKey = outwardIssue.getKey();
                IssueDTO relation = new IssueDTO(String.valueOf(relationKey), "relation", String.valueOf(issue.getKey()));
                if (!visited.contains(relation.getKey())) {
                    queue.add(relation);
                }
                if (!visited.contains((reverseRelation = new IssueDTO(String.valueOf(issue.getKey()), "relation", String.valueOf(relationKey))).getKey())) {
                    queue.add(reverseRelation);
                }
            }
            if ((inwardIssue = element.getInwardIssue()) != null) {
                IssueDTO reverseRelation;
                String relationKey = inwardIssue.getKey();
                IssueDTO relation = new IssueDTO(String.valueOf(relationKey), "relation", String.valueOf(issue.getKey()));
                if (!visited.contains(relation.getKey())) {
                    queue.add(relation);
                }
                if (!visited.contains((reverseRelation = new IssueDTO(String.valueOf(issue.getKey()), "relation", String.valueOf(relationKey))).getKey())) {
                    queue.add(reverseRelation);
                }
            }
        });
    }

    private List<CloudJiraIssueRawDataVO> fetchIssuesFromDate(AlmIssueIncrementDTO almIssueIncrementDTO, WebClient webClient) {
        String startDate = almIssueIncrementDTO.getStartDate();
        String endDate = almIssueIncrementDTO.getEndDate();
        String projectKey = almIssueIncrementDTO.getProjectKey();
        int maxResults = this.jiraApi.getParameter().getMaxResults();
        String endPoint = this.jiraApi.getEndpoint().getIssue().getIncrement().getManualDate().replace("{\uc218\ub3d9\ub0a0\uc9dc}", "updated > '" + startDate + "' AND updated < '" + String.valueOf(this.jiraUtil.getNextDate(endDate)) + "' AND project = '" + projectKey + "'") + "&maxResults=" + maxResults + "&expand=changelog";
        boolean hasMore = true;
        ArrayList<CloudJiraIssueRawDataVO> issueResult = new ArrayList<CloudJiraIssueRawDataVO>();
        String nextPageToken = null;
        while (hasMore) {
            CloudJiraIssues cloudJiraIssues = (CloudJiraIssues)this.jiraUtil.getWithRawData(webClient, endPoint + (String)Optional.ofNullable(nextPageToken).orElse(""), CloudJiraIssues.class);
            List issues = Optional.ofNullable(cloudJiraIssues).map(CloudJiraIssues::getIssues).orElseThrow(() -> new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            this.modifyIssueAlmToEs(almIssueIncrementDTO, issues);
            issueResult.addAll(issues);
            if (issueResult.isEmpty() || cloudJiraIssues.getIsLast()) {
                hasMore = false;
                continue;
            }
            nextPageToken = "&nextPageToken=" + Optional.ofNullable(cloudJiraIssues.getNextPageToken()).orElse("");
        }
        return issueResult;
    }

    private void modifyIssueAlmToEs(AlmIssueIncrementDTO almIssueIncrementDTO, List<CloudJiraIssueRawDataVO> issues) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        for (CloudJiraIssueRawDataVO issue : issues) {
            ChangeLogVO changelog = issue.getChangelog();
            if (changelog == null) continue;
            ArrayList almIssueRecentFalseList = new ArrayList();
            changelog.getHistories().stream().sorted(Comparator.comparing(HistoriesDTO::getCreated).reversed()).forEach(history -> Optional.ofNullable(history.getItems()).orElse(List.of()).stream().filter(a -> "Key".equals(a.getField())).forEach(itemsDTO -> {
                String fromKey = itemsDTO.getFromString();
                List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)this.recentIdByNewKey(serverInfo, fromKey)).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toHitDocs();
                hitDocs.forEach(hitDoc -> {
                    AlmIssueEntity almIssueEntity = (AlmIssueEntity)hitDoc.getContent();
                    almIssueEntity.setRecent(false);
                    log.info("delete:key:{}", (Object)almIssueEntity.getKey());
                    this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)almIssueEntity, hitDoc.getIndex());
                    almIssueRecentFalseList.add(almIssueEntity);
                });
            }));
            almIssueRecentFalseList.stream().filter(a -> a.getRecentId() != null).findFirst().ifPresent(almIssueEntity -> {
                almIssueEntity.modifyProjectKeyAndKey(issue.getFields().getAlmProjectKey(), issue.getKey());
                this.esCommonRepositoryWrapper.save((BaseEntity)almIssueEntity);
            });
        }
    }

    private String recentIdByNewKey(ServerInfo serverInfo, String newKey) {
        Object[] array = Arrays.stream(newKey.split("-")).toArray();
        return serverInfo.getConnectId() + "_" + String.valueOf(array[0]) + "_" + newKey;
    }

    private CloudJiraIssueRawDataVO issueList(Map<String, CloudJiraIssueRawDataVO> lruMap, IssueDTO issueDTO, WebClient webClient, String endpoint) {
        log.info("key cache:key=={},{}", (Object)issueDTO.getKey(), (Object)(lruMap.get(issueDTO.getKey()) != null ? 1 : 0));
        CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO = lruMap.get(issueDTO.getKey());
        if (cloudJiraIssueRawDataVO != null) {
            return cloudJiraIssueRawDataVO;
        }
        return Objects.requireNonNull((CloudJiraIssueRawDataVO)this.jiraUtil.getWithRawData(webClient, endpoint, CloudJiraIssueRawDataVO.class));
    }

    private List<CloudJiraIssueRawDataVO> fetchSubTaskIssuesByKey(Map<String, List<CloudJiraIssueRawDataVO>> parentKeyTraceMap, String parentKey, WebClient webClient) {
        log.info("parentKey cache:parentKey=={},{}", (Object)parentKey, (Object)(parentKeyTraceMap.get(parentKey) != null ? 1 : 0));
        if (parentKeyTraceMap.containsKey(parentKey)) {
            return parentKeyTraceMap.get(parentKey);
        }
        int maxResults = this.jiraApi.getParameter().getMaxResults();
        String endPoint = this.jiraApi.\uc774\uc288\ud0a4_\ub300\uccb4\ud558\uae30(this.jiraApi.getEndpoint().getIssue().getFull().getSubtask(), parentKey) + "&maxResults=" + maxResults + "&expand=changelog";
        boolean hasMore = true;
        ArrayList<CloudJiraIssueRawDataVO> issueResult = new ArrayList<CloudJiraIssueRawDataVO>();
        String nextPageToken = null;
        while (hasMore) {
            CloudJiraIssues cloudJiraIssues = (CloudJiraIssues)this.jiraUtil.getWithRawData(webClient, endPoint + (String)Optional.ofNullable(nextPageToken).orElse(""), CloudJiraIssues.class);
            issueResult.addAll(Optional.ofNullable(cloudJiraIssues).map(CloudJiraIssues::getIssues).orElseThrow(() -> new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.")));
            if (issueResult.isEmpty() || cloudJiraIssues.getIsLast()) {
                hasMore = false;
                continue;
            }
            nextPageToken = "&nextPageToken=" + Optional.ofNullable(cloudJiraIssues.getNextPageToken()).orElse("");
        }
        parentKeyTraceMap.put(parentKey, issueResult);
        return issueResult;
    }

    public CloudJiraIssueFieldDTO validateAndAddFields(IssueCreationFieldsDTO IssueCreationFieldsDTO2, Map<String, CloudJiraIssueCreationFieldMetadata.FieldMetadata> fieldMetadataMap, ServerInfo serverInfo, String projectKeyOrId, String issueTypeId) {
        if (fieldMetadataMap == null) {
            String \uc5d0\ub7ec\ub85c\uadf8 = "\ud544\ub4dc\uac80\uc99d_\ubc0f_\ucd94\uac00\ud558\uae30 \ud544\ub4dc_\uba54\ud0c0\ub370\uc774\ud130_\ubaa9\ub85d Null \uc624\ub958 \ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") ::  \ud504\ub85c\uc81d\ud2b8 :: " + projectKeyOrId + " :: \uc774\uc288\uc720\ud615 :: " + issueTypeId + " :: \uc0dd\uc131 \ud544\ub4dc :: " + IssueCreationFieldsDTO2.toString();
            log.error(\uc5d0\ub7ec\ub85c\uadf8);
            throw new IllegalArgumentException(\uc5d0\ub7ec\ub85c\uadf8);
        }
        CloudJiraIssueFieldDTO CloudJiraIssueFieldDTO2 = new CloudJiraIssueFieldDTO();
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getProject()) && IssueCreationFieldsDTO2.getProject() != null) {
            CloudJiraIssueFieldDTO2.setProject(IssueCreationFieldsDTO2.getProject());
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getProject());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getIssuetype()) && IssueCreationFieldsDTO2.getIssuetype() != null) {
            CloudJiraIssueFieldDTO2.setIssuetype(IssueCreationFieldsDTO2.getIssuetype());
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getIssuetype());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getSummary()) && IssueCreationFieldsDTO2.getSummary() != null) {
            CloudJiraIssueFieldDTO2.setSummary(IssueCreationFieldsDTO2.getSummary());
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getSummary());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getDescription()) && IssueCreationFieldsDTO2.getDescription() != null) {
            CloudJiraIssueFieldDTO2.setDescription(this.\ub0b4\uc6a9_\ubcc0\ud658(IssueCreationFieldsDTO2.getDescription()));
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getDescription());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getReporter())) {
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getReporter());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getPriority()) && IssueCreationFieldsDTO2.getPriority() != null) {
            CloudJiraIssueFieldDTO2.setPriority(IssueCreationFieldsDTO2.getPriority());
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getPriority());
        }
        if (fieldMetadataMap.containsKey(this.jiraApi.getMetadata().getFields().getDuedate()) && IssueCreationFieldsDTO2.getDueDate() != null) {
            String \uc885\ub8cc\uae30\ud55c\uc77c\uc790 = DateUtils.formatDate((Date)IssueCreationFieldsDTO2.getDueDate(), (String)"yyyy-MM-dd");
            CloudJiraIssueFieldDTO2.setDuedate(\uc885\ub8cc\uae30\ud55c\uc77c\uc790);
            fieldMetadataMap.remove(this.jiraApi.getMetadata().getFields().getDuedate());
        }
        fieldMetadataMap.forEach((key, \ud544\ub4dc_\uba54\ud0c0) -> {
            if (\ud544\ub4dc_\uba54\ud0c0.isRequired()) {
                String \uc5d0\ub7ec\ub85c\uadf8 = "\ud544\uc218 \ud544\ub4dc \ud655\uc778 \ubc0f \ucd94\uac00 \uc911 \uc624\ub958 [" + key + "] \ud544\ub4dc\uac00 \ud544\uc218\ub85c \uc9c0\uc815\ub418\uc5b4\uc788\uc2b5\ub2c8\ub2e4. A-RMS\uc5d0\uc11c \uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud544\ub4dc\uc785\ub2c8\ub2e4. ";
                String \uad00\ub828\uc815\ubcf4 = "\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c(" + serverInfo.getUri() + ") ::  \ud504\ub85c\uc81d\ud2b8 :: " + projectKeyOrId + " :: \uc774\uc288\uc720\ud615 :: " + issueTypeId + " :: \uc0dd\uc131 \ud544\ub4dc :: " + IssueCreationFieldsDTO2.toString();
                log.error(\uc5d0\ub7ec\ub85c\uadf8 + \uad00\ub828\uc815\ubcf4);
                throw new IllegalArgumentException(\uc5d0\ub7ec\ub85c\uadf8 + \uad00\ub828\uc815\ubcf4);
            }
        });
        return CloudJiraIssueFieldDTO2;
    }

    private String getArmsStateCategory(ServerInfo serverInfo, IssueFieldData IssueFieldData2) {
        return this.categoryMappingService.getMappingCategory(serverInfo, IssueFieldData2.getAlmProjectKey(), IssueFieldData2.getAlmIssueTypeId(), IssueFieldData2.getAlmStatusId());
    }

    @Async
    @SlackSendAlarm(messageOnStart="\ud074\ub77c\uc6b0\ub4dc \uc9c0\ub77c API \ud14c\uc2a4\ud2b8")
    public void cloudJiraTestApiRequest() {
        ServerInfo serverInfo;
        WebClient webClient;
        AlmIssueIncrementDTO almIssueIncrementDTO = AlmIssueIncrementDTO.builder().startDate("2025-11-10").endDate("2025-11-10").serverId("936493109998294575").projectKey("ARMSTEST").build();
        List cloudJiraIssueRawDataVOS = this.fetchIssuesFromDate(almIssueIncrementDTO, webClient = this.jiraUtil.createJiraCloudCommunicator((serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId())).getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo)));
        if (cloudJiraIssueRawDataVOS.isEmpty()) {
            throw new IllegalArgumentException("fetchIssuesFromDate :: API \ud655\uc778 \ud544\uc694");
        }
        List cloudJiraIssueRawDataVOS1 = this.fetchSubTaskIssuesByKey(new HashMap(), "ARMSTEST-106", webClient);
        if (cloudJiraIssueRawDataVOS1.isEmpty()) {
            throw new IllegalArgumentException("fetchSubTaskIssuesByKey :: API \ud655\uc778 \ud544\uc694");
        }
    }

    private String extractRequirementUrl(String text) {
        Pattern pattern = Pattern.compile("\uc790\uc138\ud55c \uc694\uad6c\uc0ac\ud56d \ub0b4\uc6a9 \ud655\uc778 \u21d2\\s*([^\\s\\n]+)");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Generated
    public CloudJiraIssueStrategy(JiraUtil jiraUtil, JiraApi jiraApi, CategoryMappingService categoryMappingService, EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, ServerInfoService serverInfoService, IssueSaveTemplate issueSaveTemplate) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.categoryMappingService = categoryMappingService;
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.serverInfoService = serverInfoService;
        this.issueSaveTemplate = issueSaveTemplate;
    }

    private /* synthetic */ AlmIssueVOCollection lambda$discoveryIssueAndGetReqEntities$2(Map lruMap, Map lruParentKeyTraceMap, AlmIssueIncrementDTO dto) {
        return this.discoveryIssueAndGetReqEntities(dto, lruMap, lruParentKeyTraceMap);
    }
}

