/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.strategy;

import com.arms.api.issue.almapi.model.dto.AlmIssueDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.IssueCreationFieldsDTO;
import com.arms.api.issue.almapi.model.dto.IssueDTO;
import com.arms.api.issue.almapi.model.dto.UserData;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVO;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOCollection;
import com.arms.api.issue.almapi.model.vo.IssueFieldData;
import com.arms.api.issue.almapi.model.vo.IssueWorkLogData;
import com.arms.api.issue.almapi.model.vo.JiraIssueMigData;
import com.arms.api.issue.almapi.model.vo.OnPremissJiraIssueVO;
import com.arms.api.issue.almapi.model.vo.OnPremissJiraIssueVOCollection;
import com.arms.api.issue.almapi.service.CategoryMappingService;
import com.arms.api.issue.almapi.strategy.IssueSaveTemplate;
import com.arms.api.issue.almapi.strategy.IssueStrategy;
import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.resolution.model.IssueResolutionData;
import com.arms.api.issue.status.dto.IssueStatusDTO;
import com.arms.api.issue.type.dto.IssueTypeDTO;
import com.arms.api.project.dto.ProjectDTO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.LRUMap;
import com.arms.api.util.ParseUtil;
import com.arms.api.util.StreamUtil;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorCode;
import com.arms.api.util.errors.ErrorLogUtil;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.ChangelogGroup;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.api.domain.Subtask;
import com.atlassian.jira.rest.client.api.domain.Worklog;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.atlassian.util.concurrent.Promise;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.client.WebClient;

@Component(value="ON_PREMISS")
public class OnPremiseJiraIssueStrategy
implements IssueStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnPremiseJiraIssueStrategy.class);
    private static final long PROMISE_TIMEOUT_SECONDS = 30L;
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final CategoryMappingService categoryMappingService;
    private final ServerInfoService serverInfoService;
    private final IssueSaveTemplate issueSaveTemplate;

    private void closeRestClient(JiraRestClient restClient) {
        if (restClient != null) {
            try {
                restClient.close();
            }
            catch (IOException e) {
                log.warn("JiraRestClient \uc885\ub8cc \uc911 \uc624\ub958: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlmIssueVO createIssue(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            BasicIssue basicIssue;
            IssueCreationFieldsDTO fieldsDTO = almIssueDTO.getFields();
            if (fieldsDTO == null) {
                String errorMessage = String.format("%s[%s] :: \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ub370\uc774\ud130\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
                log.error(errorMessage);
                throw new IllegalArgumentException(ErrorCode.REQUEST_BODY_ERROR_CHECK.getErrorMsg(new Object[0]) + " :: " + errorMessage);
            }
            String projectKeyOrId = null;
            Long issueTypeId = null;
            String summary = null;
            if (fieldsDTO.getProject() != null && StringUtils.isNotBlank((CharSequence)fieldsDTO.getProject().getKey())) {
                projectKeyOrId = fieldsDTO.getProject().getKey();
            }
            if (fieldsDTO.getIssuetype() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getIssuetype().getId())) {
                issueTypeId = Long.valueOf(fieldsDTO.getIssuetype().getId());
            }
            if (StringUtils.isEmpty(projectKeyOrId) || issueTypeId == null) {
                String errorMessage = String.format("%s[%s] :: \uc774\uc288 \uc0dd\uc131 \ud544\ub4dc \ud655\uc778\uc5d0 \ud544\uc694\ud55c \ud504\ub85c\uc81d\ud2b8 \uc544\uc774\ub514, \uc774\uc288\uc720\ud615 \uc544\uc774\ub514\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri());
                throw new IllegalArgumentException(errorMessage);
            }
            if (StringUtils.isNotEmpty((CharSequence)fieldsDTO.getSummary())) {
                summary = fieldsDTO.getSummary();
            }
            IssueInputBuilder issueInputBuilder = new IssueInputBuilder(projectKeyOrId, issueTypeId, summary);
            if (StringUtils.isNotEmpty((CharSequence)fieldsDTO.getDescription())) {
                issueInputBuilder.setDescription(fieldsDTO.getDescription());
            }
            if (fieldsDTO.getReporter() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getReporter().getAccountId())) {
                issueInputBuilder.setReporterName(fieldsDTO.getReporter().getAccountId());
            }
            if (fieldsDTO.getPriority() != null && StringUtils.isNotEmpty((CharSequence)fieldsDTO.getPriority().getId())) {
                issueInputBuilder.setPriorityId(Long.valueOf(fieldsDTO.getPriority().getId()));
            }
            if (fieldsDTO.getDueDate() != null) {
                DateTime dateTime = new DateTime((Object)fieldsDTO.getDueDate());
                issueInputBuilder.setDueDate(dateTime);
            }
            IssueInput issueInput = issueInputBuilder.build();
            try {
                basicIssue = (BasicIssue)restClient.getIssueClient().createIssue(issueInput).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Jira \uc774\uc288 \uc0dd\uc131 API \ud638\ucd9c \uc624\ub958", e);
            }
            if (basicIssue == null) {
                String errorMessage = String.format("%s[%s], \ud504\ub85c\uc81d\ud2b8[%s], \uc774\uc288\uc720\ud615[%s], \uc0dd\uc131 \ud544\ub4dc :: %s \uc0dd\uc131\ub41c \uc774\uc288\uac00 \uc874\uc7ac \ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId, issueTypeId, issueInput.toString());
                log.error(errorMessage);
                throw new IllegalArgumentException(ErrorCode.ISSUE_CREATION_ERROR.getErrorMsg(new Object[0]) + errorMessage);
            }
            AlmIssueVO almIssueVO = AlmIssueVO.builder().id(String.valueOf(basicIssue.getId())).key(basicIssue.getKey()).self(String.valueOf(basicIssue.getSelf())).build();
            return almIssueVO;
        }
        finally {
            this.closeRestClient(restClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> updateIssue(AlmIssueDTO almIssueDTO) {
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
        IssueCreationFieldsDTO \ud544\ub4dc_\ub370\uc774\ud130 = almIssueDTO.getFields();
        try {
            IssueInputBuilder \uc785\ub825_\uc0dd\uc131 = new IssueInputBuilder();
            if (\ud544\ub4dc_\ub370\uc774\ud130.getSummary() != null) {
                \uc785\ub825_\uc0dd\uc131.setSummary(\ud544\ub4dc_\ub370\uc774\ud130.getSummary());
            }
            if (\ud544\ub4dc_\ub370\uc774\ud130.getDescription() != null) {
                \uc785\ub825_\uc0dd\uc131.setDescription(\ud544\ub4dc_\ub370\uc774\ud130.getDescription());
            }
            if (\ud544\ub4dc_\ub370\uc774\ud130.getLabels() != null) {
                \uc785\ub825_\uc0dd\uc131.setFieldValue("labels", (Object)\ud544\ub4dc_\ub370\uc774\ud130.getLabels());
            }
            IssueInput \uc218\uc815_\ub370\uc774\ud130 = \uc785\ub825_\uc0dd\uc131.build();
            Promise \uc218\uc815\uacb0\uacfc = restClient.getIssueClient().updateIssue(issueKeyOrId, \uc218\uc815_\ub370\uc774\ud130);
            \uc218\uc815\uacb0\uacfc.get(30L, TimeUnit.SECONDS);
            \uacb0\uacfc.put("success", true);
            \uacb0\uacfc.put("message", "\uc774\uc288 \uc218\uc815 \uc131\uacf5");
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") ::  \uc0dd\uc131 \ud544\ub4dc :: " + \ud544\ub4dc_\ub370\uc774\ud130.toString() + ", :: \uc774\uc288_\uc218\uc815\ud558\uae30 \uc911 \uc624\ub958 :: " + issueKeyOrId));
            log.error(\uc5d0\ub7ec\ub85c\uadf8);
            \uacb0\uacfc.put("success", false);
            \uacb0\uacfc.put("message", \uc5d0\ub7ec\ub85c\uadf8);
        }
        finally {
            this.closeRestClient(restClient);
        }
        return \uacb0\uacfc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> updateIssueStatus(AlmIssueDTO almIssueDTO) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
        String \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 = null;
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        String statusId = almIssueDTO.getStatusId();
        try {
            Issue \uc9c0\ub77c\uc774\uc288 = (Issue)restClient.getIssueClient().getIssue(issueKeyOrId).get(30L, TimeUnit.SECONDS);
            \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 = this.\uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30(almIssueDTO);
            if (\uc774\uc288\uc804\ud658_\uc544\uc774\ub514 != null) {
                TransitionInput transitionInput = new TransitionInput(Integer.parseInt(\uc774\uc288\uc804\ud658_\uc544\uc774\ub514));
                Promise \ubcc0\uacbd\uacb0\uacfc = restClient.getIssueClient().transition(\uc9c0\ub77c\uc774\uc288, transitionInput);
                \ubcc0\uacbd\uacb0\uacfc.get(30L, TimeUnit.SECONDS);
                \uacb0\uacfc.put("success", true);
                \uacb0\uacfc.put("message", "\uc774\uc288 \uc0c1\ud0dc \ubcc0\uacbd \uc131\uacf5");
            } else {
                String \uc5d0\ub7ec\ub85c\uadf8 = "\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + statusId + ") :: \ud574\ub2f9 \uc5c5\ubb34 \ud750\ub984\uc73c\ub85c \ubcc0\uacbd\uc774 \ubd88\uac00\ub2a5 \ud569\ub2c8\ub2e4.";
                log.error(\uc5d0\ub7ec\ub85c\uadf8);
                \uacb0\uacfc.put("success", false);
                \uacb0\uacfc.put("message", "\ubcc0\uacbd\ud560 \uc774\uc288 \uc0c1\ud0dc\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + statusId + ") :: \uc804\ud658 \uc544\uc774\ub514(" + \uc774\uc288\uc804\ud658_\uc544\uc774\ub514 + ") :: \uc774\uc288_\uc0c1\ud0dc_\ubcc0\uacbd\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            \uacb0\uacfc.put("success", false);
            \uacb0\uacfc.put("message", \uc5d0\ub7ec\ub85c\uadf8);
        }
        finally {
            this.closeRestClient(restClient);
        }
        return \uacb0\uacfc;
    }

    private String \uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30(AlmIssueDTO almIssueDTO) {
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        String statusId = almIssueDTO.getStatusId();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        try {
            WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            String endpoint = "/rest/api/2/issue/" + issueKeyOrId + "/transitions";
            JiraIssueMigData \uc774\uc288\uc804\ud658_\ub370\uc774\ud130 = (JiraIssueMigData)this.jiraUtil.get(webClient, endpoint, JiraIssueMigData.class).block();
            return Optional.ofNullable(\uc774\uc288\uc804\ud658_\ub370\uc774\ud130).map(JiraIssueMigData::getTransitions).orElse(Collections.emptyList()).stream().filter(\ub370\uc774\ud130 -> {
                if (\ub370\uc774\ud130.getTo() != null && !StringUtils.isBlank((CharSequence)\ub370\uc774\ud130.getTo().getId())) {
                    return statusId.equals(\ub370\uc774\ud130.getTo().getId());
                }
                return false;
            }).findFirst().map(JiraIssueMigData.Transition::getId).orElse(null);
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288 \ud0a4(" + issueKeyOrId + ") :: \uc0c1\ud0dc \uc544\uc774\ub514(" + statusId + ") :: \uc774\uc288\uc804\ud658_\uc544\uc774\ub514_\uc870\ud68c\ud558\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4."));
            throw new IllegalArgumentException(ErrorCode.ISSUE_TRANSITION_RETRIEVAL_ERROR.getErrorMsg(new Object[0]) + " :: " + \uc5d0\ub7ec\ub85c\uadf8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> deleteIssue(AlmIssueDTO almIssueDTO) {
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        HashMap<String, Object> \uacb0\uacfc = new HashMap<String, Object>();
        try {
            boolean \ud558\uc704\uc774\uc288_\uc0ad\uc81c\uc720\ubb34 = this.jiraApi.getParameter().isDeleteSubtasks();
            Promise \uc0ad\uc81c\uacb0\uacfc = restClient.getIssueClient().deleteIssue(issueKeyOrId, \ud558\uc704\uc774\uc288_\uc0ad\uc81c\uc720\ubb34);
            \uc0ad\uc81c\uacb0\uacfc.get(30L, TimeUnit.SECONDS);
            \uacb0\uacfc.put("success", true);
            \uacb0\uacfc.put("message", "\uc774\uc288 \uc0ad\uc81c \uc131\uacf5");
        }
        catch (Exception e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") :: \uc774\uc288_\uc0ad\uc81c\ud558\uae30 \uc911 \uc624\ub958 :: " + issueKeyOrId));
            log.error(\uc5d0\ub7ec\ub85c\uadf8);
            \uacb0\uacfc.put("success", false);
            \uacb0\uacfc.put("message", \uc5d0\ub7ec\ub85c\uadf8);
        }
        finally {
            this.closeRestClient(restClient);
        }
        return \uacb0\uacfc;
    }

    public boolean isExistIssue(AlmIssueDTO almIssueDTO) {
        try {
            AlmIssueVO issue = this.getIssueVO(almIssueDTO, false);
            return issue != null && issue.getKey().equals(almIssueDTO.getIssueKeyOrId());
        }
        catch (Exception e) {
            return false;
        }
    }

    public AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO) {
        return this.getIssueVO(almIssueDTO, true);
    }

    private AlmIssueVO getIssueVO(AlmIssueDTO almIssueDTO, boolean convertFlag) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueDTO.getServerId());
        String issueKeyOrId = almIssueDTO.getIssueKeyOrId();
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Issue issue = (Issue)restClient.getIssueClient().getIssue(issueKeyOrId).get(30L, TimeUnit.SECONDS);
            if (convertFlag) {
                AlmIssueVO almIssueVO = this.convertOnPremiseJiraIssueToAlmIssue(OnPremissJiraIssueVO.builder().issue(issue).serverInfo(serverInfo).build());
                return almIssueVO;
            }
            AlmIssueVO almIssueVO = AlmIssueVO.builder().key(issue.getKey()).build();
            return almIssueVO;
        }
        catch (Exception e) {
            ErrorLogUtil.exceptionLogging((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") ::  \uc774\uc288_\ud0a4_\ub610\ub294_\uc544\uc774\ub514 :: " + issueKeyOrId + ", \uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30 \uc911 \uc624\ub958"));
            throw new IllegalArgumentException("\uc774\uc288_\uc0c1\uc138\uc815\ubcf4_\uac00\uc838\uc624\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        finally {
            this.closeRestClient(restClient);
        }
    }

    public List<AlmIssueEntity> discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO) {
        LRUMap lruMap = new LRUMap(10000);
        return this.issueSaveTemplate.discoveryIncrementALmIssueAndGetReqAlmIssueEntities(almIssueIncrementDTO, arg_0 -> this.lambda$discoveryIssueAndGetReqEntities$1((Map)lruMap, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlmIssueVOCollection discoveryIssueAndGetReqEntities(AlmIssueIncrementDTO almIssueIncrementDTO, Map<String, Issue> lruMap) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        JiraRestClient restClient = this.jiraUtil.createJiraOnPremiseCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List issuesFromJiraIssue = this.fetchIssuesFromDate(almIssueIncrementDTO, restClient);
            issuesFromJiraIssue.forEach(a -> lruMap.put(a.getKey(), (Issue)a));
            List almIssueEntities = issuesFromJiraIssue.stream().flatMap(a -> this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)this.recentIdByNewKey(serverInfo, a.getKey()))).toDocs().stream()).toList();
            List listByParentReqKey = almIssueEntities.stream().filter(AlmIssueEntity::izReqFalse).filter(a -> !ObjectUtils.isEmpty((Object)a.getParentReqKey())).flatMap(hit -> this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)hit.getParentReqKey()).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs().stream()).toList();
            ArrayList<AlmIssueEntity> isReqList = new ArrayList<AlmIssueEntity>(almIssueEntities.stream().filter(AlmIssueEntity::izReqTrue).toList());
            isReqList.addAll(listByParentReqKey);
            List isReqListDistinct = isReqList.stream().distinct().toList();
            HashSet<String> visited = new HashSet<String>();
            for (AlmIssueEntity almIssueEntity : isReqListDistinct) {
                LinkedList<String> queue = new LinkedList<String>();
                Optional.ofNullable(almIssueEntity.getLinkedIssues()).ifPresent(queue::addAll);
                queue.add(almIssueEntity.getRecentId());
                while (!queue.isEmpty()) {
                    String poll = (String)queue.poll();
                    String key = Optional.ofNullable(poll).map(a -> {
                        if (a.split("_").length == 3) {
                            return a.split("_")[2];
                        }
                        return a;
                    }).orElse(poll);
                    if (!visited.contains(key) && !ObjectUtils.isEmpty((Object)key)) {
                        try {
                            IssueDTO issueDTO = IssueDTO.builder().key(key).build();
                            Issue issue = this.issueList(lruMap, issueDTO, restClient);
                            lruMap.put(issue.getKey(), issue);
                        }
                        catch (RestClientException e) {
                            com.google.common.base.Optional statusCode = e.getStatusCode();
                            if (statusCode.isPresent() && (Integer)statusCode.get() == 404) {
                                log.info("onPremise jira not found key : {} ", (Object)key);
                                List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toHitDocs();
                                for (SearchHit hitDoc : hitDocs) {
                                    AlmIssueEntity content = (AlmIssueEntity)hitDoc.getContent();
                                    content.setRecent(false);
                                    log.info("delete:key:{}", (Object)content.getKey());
                                    this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, hitDoc.getIndex());
                                }
                            }
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                        List docsByParentReqKey = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"parentReqKey", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs();
                        docsByParentReqKey.forEach(doc -> {
                            queue.add(doc.getKey());
                            queue.addAll(doc.getLinkedIssues());
                        });
                        List docsByKey = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"key", (Object)key).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toDocs();
                        docsByKey.forEach(doc -> queue.add(doc.getUpperKey()));
                    }
                    visited.add(key);
                    Optional.ofNullable(lruMap.get(key)).ifPresent(issuesFromJiraIssue::add);
                }
            }
            List onPremissJiraIssueVOS = issuesFromJiraIssue.stream().distinct().flatMap(cloudJiraIssueRawDataVO -> this.incrementTraceArmsIssueVOS(lruMap, cloudJiraIssueRawDataVO, serverInfo, restClient).stream()).toList();
            OnPremissJiraIssueVOCollection onPremissJiraIssueVOCollection = new OnPremissJiraIssueVOCollection(onPremissJiraIssueVOS.stream().map(onPremissJiraIssueVO -> {
                if (!issuesFromJiraIssue.contains(onPremissJiraIssueVO.getIssue())) {
                    return onPremissJiraIssueVO.markAsExcludedFromSave();
                }
                return onPremissJiraIssueVO;
            }).toList());
            List onPremissJiraIssueVOs = onPremissJiraIssueVOCollection.appliedLinkedIssuePdServiceVO();
            this.deleteUnrelatedEntities(onPremissJiraIssueVOs, issuesFromJiraIssue);
            AlmIssueVOCollection almIssueVOCollection = this.convertIncrementOnPremiseJiraIssueToAlmIssues(onPremissJiraIssueVOs);
            return almIssueVOCollection;
        }
        catch (Exception e) {
            log.error("\uc99d\ubd84 \ub370\uc774\ud130 \uc218\uc9d1\uc5d0 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.", (Throwable)e);
            ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c(" + serverInfo.getUri() + ") \uc99d\ubd84 \uc774\uc288 \uc218\uc9d1 \uc911 \uc624\ub958"));
            AlmIssueVOCollection almIssueVOCollection = new AlmIssueVOCollection(new ArrayList());
            return almIssueVOCollection;
        }
        finally {
            this.closeRestClient(restClient);
        }
    }

    private AlmIssueVOCollection convertIncrementOnPremiseJiraIssueToAlmIssues(List<OnPremissJiraIssueVO> onPremissJiraIssueVOs) {
        return new AlmIssueVOCollection(onPremissJiraIssueVOs.stream().map(arg_0 -> this.convertOnPremiseJiraIssueToAlmIssue(arg_0)).toList());
    }

    private AlmIssueVO convertOnPremiseJiraIssueToAlmIssue(OnPremissJiraIssueVO onPremissJiraIssueVO) {
        AlmIssueVO.AlmIssueVOBuilder almIssueVOBuilder = AlmIssueVO.builder();
        IssueFieldData IssueFieldData2 = new IssueFieldData();
        Issue issue = onPremissJiraIssueVO.getIssue();
        ServerInfo serverInfo = onPremissJiraIssueVO.getServerInfo();
        Optional.ofNullable(onPremissJiraIssueVO.relationRecentIds()).ifPresent(arg_0 -> ((AlmIssueVO.AlmIssueVOBuilder)almIssueVOBuilder).linkedIssue(arg_0));
        almIssueVOBuilder.almIssueWithRequirementDTO(onPremissJiraIssueVO.getAlmIssueWithRequirementDTO()).id(String.valueOf(issue.getId())).excludeFromSave(onPremissJiraIssueVO.isExcludeFromSave()).key(issue.getKey()).self(String.valueOf(issue.getSelf()));
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JodaModule());
            String rawData = objectMapper.writeValueAsString((Object)issue);
            almIssueVOBuilder.rawData(rawData);
        }
        catch (JsonProcessingException e) {
            String \uc5d0\ub7ec\ub85c\uadf8 = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), (String)this.getClass().getName(), (String)("\uc628\ud504\ub808\ubbf8\uc2a4 \uc9c0\ub77c :: \uc9c0\ub77c\uc774\uc288_\ub370\uc774\ud130\ub85c_\ubcc0\ud658 \uc911 \uc624\ub958 :: " + issue.getKey()));
            log.error(\uc5d0\ub7ec\ub85c\uadf8);
        }
        for (IssueField issueField : issue.getFields()) {
            if (!issueField.getId().equals("parent")) continue;
            JSONObject value = (JSONObject)issueField.getValue();
            try {
                Optional.ofNullable(value.get("key")).ifPresent(a -> almIssueVOBuilder.upperKey(String.valueOf(a)));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        ProjectDTO \ud504\ub85c\uc81d\ud2b8 = ProjectDTO.builder().build();
        UserData \ubcf4\uace0\uc790 = new UserData();
        UserData \ub2f4\ub2f9\uc790 = new UserData();
        if (issue.getProject() != null) {
            \ud504\ub85c\uc81d\ud2b8.setSelf(String.valueOf(issue.getProject().getSelf()));
            \ud504\ub85c\uc81d\ud2b8.setId(String.valueOf(issue.getProject().getId()));
            \ud504\ub85c\uc81d\ud2b8.setKey(issue.getProject().getKey());
            \ud504\ub85c\uc81d\ud2b8.setName(issue.getProject().getName());
            IssueFieldData2.setProject(\ud504\ub85c\uc81d\ud2b8);
        }
        if (issue.getIssueType() != null) {
            String \uc774\uc288\uc720\ud615_\uc8fc\uc18c = String.valueOf(issue.getIssueType().getSelf());
            String \uc774\uc288\uc720\ud615_\uc544\uc774\ub514 = String.valueOf(issue.getIssueType().getId());
            String \uc774\uc288\uc720\ud615_\uc774\ub984 = issue.getIssueType().getName();
            String \uc774\uc288\uc720\ud615_\ub0b4\uc6a9 = issue.getIssueType().getDescription();
            Boolean \uc774\uc288\uc720\ud615_\uc11c\ube0c\ud14c\uc2a4\ud06c\uc5ec\ubd80 = issue.getIssueType().isSubtask();
            IssueTypeDTO \uc774\uc288\uc720\ud615 = new IssueTypeDTO();
            \uc774\uc288\uc720\ud615.setSelf(\uc774\uc288\uc720\ud615_\uc8fc\uc18c);
            \uc774\uc288\uc720\ud615.setId(\uc774\uc288\uc720\ud615_\uc544\uc774\ub514);
            \uc774\uc288\uc720\ud615.setName(\uc774\uc288\uc720\ud615_\uc774\ub984);
            \uc774\uc288\uc720\ud615.setDescription(\uc774\uc288\uc720\ud615_\ub0b4\uc6a9);
            \uc774\uc288\uc720\ud615.setSubtask(\uc774\uc288\uc720\ud615_\uc11c\ube0c\ud14c\uc2a4\ud06c\uc5ec\ubd80);
            IssueFieldData2.setIssuetype(\uc774\uc288\uc720\ud615);
        }
        if (issue.getReporter() != null) {
            \ubcf4\uace0\uc790.setAccountId(issue.getReporter().getName());
            \ubcf4\uace0\uc790.setEmailAddress(issue.getReporter().getEmailAddress());
            \ubcf4\uace0\uc790.setDisplayName(issue.getReporter().getDisplayName());
            IssueFieldData2.setReporter(\ubcf4\uace0\uc790);
        }
        if (issue.getAssignee() != null) {
            \ub2f4\ub2f9\uc790.setAccountId(issue.getAssignee().getName());
            \ub2f4\ub2f9\uc790.setEmailAddress(issue.getAssignee().getEmailAddress());
            \ub2f4\ub2f9\uc790.setDisplayName(issue.getAssignee().getDisplayName());
            IssueFieldData2.setAssignee(\ub2f4\ub2f9\uc790);
        }
        if (issue.getLabels() != null) {
            Set \ub77c\ubca8_\ubaa9\ub85d = issue.getLabels();
            ArrayList \uc774\uc288\ub77c\ubca8 = new ArrayList(\ub77c\ubca8_\ubaa9\ub85d);
            IssueFieldData2.setLabels(\uc774\uc288\ub77c\ubca8);
        }
        if (issue.getPriority() != null) {
            String \uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc8fc\uc18c = String.valueOf(issue.getPriority().getSelf());
            String \uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc544\uc774\ub514 = String.valueOf(issue.getPriority().getId());
            String \uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc774\ub984 = issue.getPriority().getName();
            IssuePriorityDTO \uc774\uc288\uc6b0\uc120\uc21c\uc704 = new IssuePriorityDTO();
            \uc774\uc288\uc6b0\uc120\uc21c\uc704.setSelf(\uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc8fc\uc18c);
            \uc774\uc288\uc6b0\uc120\uc21c\uc704.setId(\uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc544\uc774\ub514);
            \uc774\uc288\uc6b0\uc120\uc21c\uc704.setName(\uc774\uc288\uc6b0\uc120\uc21c\uc704_\uc774\ub984);
            IssueFieldData2.setPriority(\uc774\uc288\uc6b0\uc120\uc21c\uc704);
        }
        if (issue.getStatus() != null) {
            String \uc774\uc288\uc0c1\ud0dc_\uc8fc\uc18c = String.valueOf(issue.getStatus().getSelf());
            String \uc774\uc288\uc0c1\ud0dc_\uc544\uc774\ub514 = String.valueOf(issue.getStatus().getId());
            String \uc774\uc288\uc0c1\ud0dc_\uc774\ub984 = issue.getStatus().getName();
            String \uc774\uc288\uc0c1\ud0dc_\uc124\uba85 = issue.getStatus().getDescription();
            IssueStatusDTO \uc774\uc288\uc0c1\ud0dc = new IssueStatusDTO();
            \uc774\uc288\uc0c1\ud0dc.setSelf(\uc774\uc288\uc0c1\ud0dc_\uc8fc\uc18c);
            \uc774\uc288\uc0c1\ud0dc.setId(\uc774\uc288\uc0c1\ud0dc_\uc544\uc774\ub514);
            \uc774\uc288\uc0c1\ud0dc.setName(\uc774\uc288\uc0c1\ud0dc_\uc774\ub984);
            \uc774\uc288\uc0c1\ud0dc.setDescription(\uc774\uc288\uc0c1\ud0dc_\uc124\uba85);
            IssueFieldData2.setStatus(\uc774\uc288\uc0c1\ud0dc);
        }
        if (issue.getResolution() != null) {
            String \uc774\uc288\ud574\uacb0\ucc45_\uc8fc\uc18c = String.valueOf(issue.getResolution().getSelf());
            String \uc774\uc288\ud574\uacb0\ucc45_\uc544\uc774\ub514 = String.valueOf(issue.getResolution().getId());
            String \uc774\uc288\ud574\uacb0\ucc45_\uc774\ub984 = issue.getResolution().getName();
            String \uc774\uc288\ud574\uacb0\ucc45_\uc124\uba85 = issue.getResolution().getDescription();
            IssueResolutionData \uc774\uc288\ud574\uacb0\ucc45 = new IssueResolutionData();
            \uc774\uc288\ud574\uacb0\ucc45.setSelf(\uc774\uc288\ud574\uacb0\ucc45_\uc8fc\uc18c);
            \uc774\uc288\ud574\uacb0\ucc45.setId(\uc774\uc288\ud574\uacb0\ucc45_\uc544\uc774\ub514);
            \uc774\uc288\ud574\uacb0\ucc45.setName(\uc774\uc288\ud574\uacb0\ucc45_\uc774\ub984);
            \uc774\uc288\ud574\uacb0\ucc45.setDescription(\uc774\uc288\ud574\uacb0\ucc45_\uc124\uba85);
            IssueFieldData2.setResolution(\uc774\uc288\ud574\uacb0\ucc45);
        }
        for (IssueField \ud544\ub4dc : issue.getFields()) {
            if (\ud544\ub4dc == null || \ud544\ub4dc.getId().isEmpty() || !\ud544\ub4dc.getId().equals("resolutiondate")) continue;
            if (\ud544\ub4dc.getValue().toString() == null) break;
            IssueFieldData2.setResolutiondate(\ud544\ub4dc.getValue().toString());
            break;
        }
        if (issue.getCreationDate() != null) {
            String \uc774\uc288\uc0dd\uc131\ub0a0\uc9dc = String.valueOf(issue.getCreationDate());
            IssueFieldData2.setCreated(\uc774\uc288\uc0dd\uc131\ub0a0\uc9dc);
        }
        if (issue.getUpdateDate() != null) {
            String \uc774\uc288\uc218\uc815\ub0a0\uc9dc = String.valueOf(issue.getUpdateDate());
            IssueFieldData2.setUpdated(\uc774\uc288\uc218\uc815\ub0a0\uc9dc);
        }
        if (issue.getWorklogs() != null) {
            ArrayList<IssueWorkLogData> \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\ubaa9\ub85d = new ArrayList<IssueWorkLogData>();
            Iterable \uc804\uccb4\uc774\uc288\uc6cc\ud06c\ub85c\uadf8 = issue.getWorklogs();
            for (Worklog \uc6cc\ud06c\ub85c\uadf8 : \uc804\uccb4\uc774\uc288\uc6cc\ud06c\ub85c\uadf8) {
                UserData \uc791\uc131\uc790 = new UserData();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc8fc\uc18c = \uc6cc\ud06c\ub85c\uadf8.getSelf().toString();
                BasicUser \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc791\uc131\uc790 = \uc6cc\ud06c\ub85c\uadf8.getAuthor();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc791\uc131\uc790\uc544\uc774\ub514 = \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc791\uc131\uc790.getName();
                BasicUser \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\uc791\uc131\uc790 = \uc6cc\ud06c\ub85c\uadf8.getUpdateAuthor();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\uc791\uc131\uc790\uc544\uc774\ub514 = \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\uc791\uc131\uc790.getName();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc0dd\uc131\ub0a0\uc9dc = \uc6cc\ud06c\ub85c\uadf8.getCreationDate().toString();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\ub0a0\uc9dc = \uc6cc\ud06c\ub85c\uadf8.getUpdateDate().toString();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc2dc\uc791\ub0a0\uc9dc = \uc6cc\ud06c\ub85c\uadf8.getStartDate().toString();
                String \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc18c\uc694\uc2dc\uac04_\ud3ec\ub9f7 = ParseUtil.timeFormat((int)\uc6cc\ud06c\ub85c\uadf8.getMinutesSpent());
                Integer \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc18c\uc694\uc2dc\uac04 = \uc6cc\ud06c\ub85c\uadf8.getMinutesSpent() * 60;
                String[] \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc544\uc774\ub514 = \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc8fc\uc18c.split("/");
                IssueWorkLogData \uc774\uc288\uc6cc\ud06c\ub85c\uadf8 = new IssueWorkLogData();
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setSelf(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc8fc\uc18c);
                \uc791\uc131\uc790.setAccountId(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc791\uc131\uc790\uc544\uc774\ub514);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setAuthor(\uc791\uc131\uc790);
                \uc791\uc131\uc790.setAccountId(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\uc791\uc131\uc790\uc544\uc774\ub514);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setUpdateAuthor(\uc791\uc131\uc790);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setCreated(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc0dd\uc131\ub0a0\uc9dc);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setUpdated(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc218\uc815\ub0a0\uc9dc);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setStarted(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc2dc\uc791\ub0a0\uc9dc);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setTimeSpent(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc18c\uc694\uc2dc\uac04_\ud3ec\ub9f7);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setTimeSpentSeconds(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc18c\uc694\uc2dc\uac04);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setId(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc544\uc774\ub514[\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\uc544\uc774\ub514.length - 1]);
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8.setIssueId(String.valueOf(issue.getId()));
                \uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\ubaa9\ub85d.add(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8);
            }
            IssueFieldData2.setWorklogs(\uc774\uc288\uc6cc\ud06c\ub85c\uadf8_\ubaa9\ub85d);
        }
        if (issue.getTimeTracking().getTimeSpentMinutes() != null) {
            Integer \uc774\uc288\uc18c\uc694\uc2dc\uac04 = issue.getTimeTracking().getTimeSpentMinutes() * 60;
            IssueFieldData2.setTimespent(\uc774\uc288\uc18c\uc694\uc2dc\uac04);
        }
        if (issue.getSummary() != null) {
            IssueFieldData2.setSummary(issue.getSummary());
        }
        almIssueVOBuilder.fields(IssueFieldData2).armsStateCategory(this.getMappingCategory(serverInfo, IssueFieldData2.getAlmStatusId())).linkedIssuePdServiceIds(onPremissJiraIssueVO.getLinkedIssuePdServiceIds()).linkedIssuePdServiceVersions(onPremissJiraIssueVO.getLinkedIssuePdServiceVersions());
        return almIssueVOBuilder.build();
    }

    private void deleteUnrelatedEntities(List<OnPremissJiraIssueVO> onPremissJiraIssueVOS, List<Issue> results) {
        results.stream().filter(a -> !onPremissJiraIssueVOS.contains(OnPremissJiraIssueVO.builder().issue(a).build())).forEach(a -> onPremissJiraIssueVOS.stream().findFirst().ifPresent(b -> {
            List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)b.recentId(String.valueOf(a.getKey())))).toHitDocs();
            for (SearchHit hitDoc : hitDocs) {
                AlmIssueEntity content = (AlmIssueEntity)hitDoc.getContent();
                content.setRecent(false);
                log.info("delete:::key:::{}", (Object)content.getKey());
                this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, hitDoc.getIndex());
            }
        }));
    }

    private List<Issue> fetchIssuesFromDate(AlmIssueIncrementDTO almIssueIncrementDTO, JiraRestClient jiraRestClient) throws ExecutionException, InterruptedException {
        String startDate = almIssueIncrementDTO.getStartDate();
        String endDate = almIssueIncrementDTO.getEndDate();
        String projectKey = almIssueIncrementDTO.getProjectKey();
        String updateJql = this.jiraApi.getParameter().getJql().getUpdated();
        if (startDate != null && endDate != null) {
            updateJql = this.jiraApi.getParameter().getJql().getManualDate();
            updateJql = updateJql.replace("{\uc218\ub3d9\ub0a0\uc9dc}", "updated > '" + startDate + "' AND updated < '" + String.valueOf(this.jiraUtil.getNextDate(endDate)) + "' AND project = '" + projectKey + "'");
        }
        String jql = updateJql;
        int page = 0;
        int maxResults = this.jiraApi.getParameter().getMaxResults();
        HashSet<String> fields = new HashSet<String>(List.of("*all"));
        boolean hasMore = true;
        ArrayList<Issue> issueResult = new ArrayList<Issue>();
        while (hasMore) {
            List results = StreamUtil.toStream((Iterable)((SearchResult)jiraRestClient.getSearchClient().searchJql(jql, Integer.valueOf(maxResults), Integer.valueOf(page), fields).get()).getIssues()).toList();
            this.modifyIssueAlmToEs(almIssueIncrementDTO, jiraRestClient, results);
            int fetchCount = results.size();
            if (fetchCount < maxResults) {
                hasMore = false;
            } else {
                ++page;
            }
            issueResult.addAll(results);
        }
        return issueResult;
    }

    private void modifyIssueAlmToEs(AlmIssueIncrementDTO almIssueIncrementDTO, JiraRestClient jiraRestClient, List<Issue> issues) {
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(almIssueIncrementDTO.getServerId());
        for (Issue issue : issues) {
            List changelog;
            try {
                changelog = StreamSupport.stream(Objects.requireNonNull(((Issue)jiraRestClient.getIssueClient().getIssue(issue.getKey(), List.of(IssueRestClient.Expandos.CHANGELOG)).get(30L, TimeUnit.SECONDS)).getChangelog()).spliterator(), false).toList();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("Jira \uc774\uc288 \ubcc0\uacbd\ub85c\uadf8 \uc870\ud68c \uc624\ub958: {}", (Object)issue.getKey(), (Object)e);
                continue;
            }
            if (ObjectUtils.isEmpty(changelog)) continue;
            ArrayList almIssueRecentFalseList = new ArrayList();
            changelog.stream().sorted(Comparator.comparing(ChangelogGroup::getCreated).reversed()).forEach(history -> StreamSupport.stream(history.getItems().spliterator(), false).filter(a -> "Key".equals(a.getField())).forEach(itemsDTO -> {
                String fromKey = itemsDTO.getFromString();
                List hitDocs = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"recent_id", (Object)this.recentIdByNewKey(serverInfo, fromKey)).andTermQueryFilter("jira_server_id", (Object)serverInfo.getConnectId())).toHitDocs();
                hitDocs.forEach(hitDoc -> {
                    AlmIssueEntity almIssueEntity = (AlmIssueEntity)hitDoc.getContent();
                    almIssueEntity.setRecent(false);
                    this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)almIssueEntity, hitDoc.getIndex());
                    almIssueRecentFalseList.add(almIssueEntity);
                });
            }));
            almIssueRecentFalseList.stream().filter(a -> a.getRecentId() != null).findFirst().ifPresent(almIssueEntity -> {
                almIssueEntity.modifyProjectKeyAndKey(issue.getProject().getKey(), issue.getKey());
                this.esCommonRepositoryWrapper.save((BaseEntity)almIssueEntity);
            });
        }
    }

    private String recentIdByNewKey(ServerInfo serverInfo, String newKey) {
        Object[] array = Arrays.stream(newKey.split("-")).toArray();
        return serverInfo.getConnectId() + "_" + String.valueOf(array[0]) + "_" + newKey;
    }

    private List<OnPremissJiraIssueVO> incrementTraceArmsIssueVOS(Map<String, Issue> lruMap, Issue currentIssue, ServerInfo serverInfo, JiraRestClient restClient) {
        LinkedList<IssueDTO> queue = new LinkedList<IssueDTO>();
        queue.add(this.createIssueDTO(currentIssue));
        lruMap.put(currentIssue.getKey(), currentIssue);
        HashSet<CallSite> recentIds = new HashSet<CallSite>();
        HashSet<String> visited = new HashSet<String>();
        while (!queue.isEmpty()) {
            try {
                IssueDTO issueDTO = (IssueDTO)queue.poll();
                Issue issue = this.issueList(lruMap, issueDTO, restClient);
                if (issue.getKey() != null) {
                    lruMap.put(issue.getKey(), issue);
                    String recentId = serverInfo.getConnectId() + "_" + issue.getProject().getKey() + "_" + issue.getKey();
                    recentIds.add((CallSite)((Object)recentId));
                }
                if (visited.contains(issue.getKey())) continue;
                queue.add(this.createIssueParentTraceDTO(issue));
                Iterable subtasks = issue.getSubtasks();
                if (subtasks != null) {
                    for (Subtask subtask : Objects.requireNonNull(subtasks)) {
                        queue.add(this.createIssueDTO(subtask));
                    }
                }
                this.linkedIssueQueueRegister(issue, queue, visited);
                visited.add(issue.getKey());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termsQueryFilter((String)"recent_id", recentIds.stream().toList()).andTermQueryFilter("isReq", (Object)true)).toDocs().stream().map(reqIssueEntity -> {
            String rootParentKey = this.findRootParentKey(lruMap, currentIssue.getKey(), restClient);
            return OnPremissJiraIssueVO.builder().issue(currentIssue).almIssueWithRequirementDTO(Optional.ofNullable(this.isSelfCreatedIssue(reqIssueEntity, rootParentKey)).orElseGet(() -> new AlmIssueWithRequirementDTO(reqIssueEntity))).serverInfo(serverInfo).build();
        }).toList();
    }

    private AlmIssueWithRequirementDTO isSelfCreatedIssue(AlmIssueEntity almIssueEntity, String rootParentKey) {
        AlmIssueWithRequirementDTO reqDTO = new AlmIssueWithRequirementDTO(almIssueEntity, rootParentKey);
        AlmIssueEntity recentDocByRecentId = (AlmIssueEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)reqDTO.recentId()));
        if (rootParentKey != null && (recentDocByRecentId.getKey() == null || recentDocByRecentId.izReqFalse())) {
            return reqDTO;
        }
        return null;
    }

    private String findRootParentKey(Map<String, Issue> lruMap, String startKey, JiraRestClient restClient) {
        Issue issue;
        String currentParentKey;
        String findKey = startKey;
        String parentKey = null;
        while (findKey != null && (currentParentKey = this.getParentKeyFromIssue(issue = this.issueList(lruMap, IssueDTO.builder().key(findKey).build(), restClient))) != null) {
            findKey = parentKey = currentParentKey;
        }
        return parentKey;
    }

    private String getParentKeyFromIssue(Issue issue) {
        return Optional.ofNullable(issue.getFields()).map(fields -> {
            for (IssueField issueField : fields) {
                if (!issueField.getId().equals("parent")) continue;
                JSONObject value = (JSONObject)issueField.getValue();
                try {
                    return String.valueOf(value.get("key"));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }).orElse(null);
    }

    private IssueDTO createIssueDTO(Issue issue) {
        return IssueDTO.builder().key(String.valueOf(issue.getKey())).fromKey(String.valueOf(issue.getKey())).build();
    }

    private IssueDTO createIssueDTO(Subtask subtask) {
        return IssueDTO.builder().key(String.valueOf(subtask.getIssueKey())).fromKey(String.valueOf(subtask.getIssueKey())).build();
    }

    private IssueDTO createIssueParentTraceDTO(Issue issue) {
        return IssueDTO.builder().key(Optional.ofNullable(issue.getFields()).map(a -> {
            for (IssueField issueField : a) {
                if (!issueField.getId().equals("parent")) continue;
                JSONObject value = (JSONObject)issueField.getValue();
                try {
                    return String.valueOf(value.get("key"));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return issue.getKey();
        }).orElseGet(() -> ((Issue)issue).getKey())).fromKey(String.valueOf(issue.getKey())).build();
    }

    private void linkedIssueQueueRegister(Issue issue, Queue<IssueDTO> queue, Set<String> visited) {
        List<IssueLink> issueRelations = StreamUtil.toStream((Iterable)issue.getIssueLinks()).toList();
        issueRelations.forEach(element -> {
            IssueDTO reverseRelation;
            IssueDTO relation = IssueDTO.builder().key(element.getTargetIssueKey()).fromKey(issue.getKey()).build();
            if (!visited.contains(relation.getKey())) {
                queue.add(relation);
            }
            if (!visited.contains((reverseRelation = IssueDTO.builder().key(issue.getKey()).fromKey(element.getTargetIssueKey()).build()).getKey())) {
                queue.add(reverseRelation);
            }
        });
    }

    private Issue issueList(Map<String, Issue> lruMap, IssueDTO issueDTO, JiraRestClient jiraRestClient) {
        log.info("key cache:key=={},{}", (Object)issueDTO.getKey(), (Object)(lruMap.get(issueDTO.getKey()) != null ? 1 : 0));
        Issue issue = lruMap.get(issueDTO.getKey());
        if (issue != null) {
            return issue;
        }
        try {
            return (Issue)jiraRestClient.getIssueClient().getIssue(issueDTO.getKey(), List.of(IssueRestClient.Expandos.CHANGELOG)).get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Jira API \ud638\ucd9c \uc624\ub958: " + issueDTO.getKey(), e);
        }
    }

    private String getMappingCategory(ServerInfo serverInfo, String statusId) {
        return this.categoryMappingService.getMappingCategory(serverInfo, statusId);
    }

    @Generated
    public OnPremiseJiraIssueStrategy(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, JiraUtil jiraUtil, JiraApi jiraApi, CategoryMappingService categoryMappingService, ServerInfoService serverInfoService, IssueSaveTemplate issueSaveTemplate) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.categoryMappingService = categoryMappingService;
        this.serverInfoService = serverInfoService;
        this.issueSaveTemplate = issueSaveTemplate;
    }

    private /* synthetic */ AlmIssueVOCollection lambda$discoveryIssueAndGetReqEntities$1(Map lruMap, AlmIssueIncrementDTO dto) {
        return this.discoveryIssueAndGetReqEntities(dto, lruMap);
    }
}

