/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.priority.controller;

import com.arms.api.issue.priority.model.IssuePriorityDTO;
import com.arms.api.issue.priority.service.IssuePriorityService;
import com.arms.api.util.errors.ErrorCode;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/{connectId}/jira/issuepriority"})
public class IssuePriorityController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuePriorityController.class);
    private final IssuePriorityService issuePriorityService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public List<IssuePriorityDTO> getIssuePriorityList(@PathVariable(value="connectId") String connectId) {
        if (connectId == null) {
            String errorMessage = String.format("getIssuePriorityList Error: connectId %s", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg(new Object[0]));
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        return this.issuePriorityService.getIssuePriorityList(connectId);
    }

    @Generated
    public IssuePriorityController(IssuePriorityService issuePriorityService) {
        this.issuePriorityService = issuePriorityService;
    }
}

