/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.poc.controller;

import com.arms.api.poc.model.dto.PocDTO;
import com.arms.api.poc.model.entity.PocEntity;
import com.arms.api.poc.model.vo.PocVO;
import com.arms.api.poc.service.PocService;
import com.arms.api.util.response.CommonResponse;
import feign.Param;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine/poc"})
public class PocController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PocController.class);
    private final PocService pocService;

    @PostMapping
    public ResponseEntity<CommonResponse.ApiResult<String>> savePoc(@RequestBody PocDTO pocDTO) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.createPoc(pocDTO)));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CommonResponse.ApiResult<PocEntity>> findPoc(@PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.getPoc(id)));
    }

    @GetMapping
    public ResponseEntity<CommonResponse.ApiResult<PocVO>> pocList(@Param(value="baseDTO") PocDTO pocDTO) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.getPocList(pocDTO)));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> update(@PathVariable(value="id") String id, @RequestBody PocDTO pocDTO) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.updatePoc(pocDTO)));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<CommonResponse.ApiResult<String>> deleteById(@PathVariable(value="id") String id) {
        return ResponseEntity.ok((Object)CommonResponse.success((Object)this.pocService.deletePoc(id)));
    }

    @Generated
    public PocController(PocService pocService) {
        this.pocService = pocService;
    }
}

