/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.project.strategy;

import com.arms.api.project.strategy.ProjectStrategy;
import com.arms.api.project.vo.ProjectVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.RedmineApi;
import com.arms.api.util.alm.RedmineUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Project;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OnpremiseRedmineProjectStrategy
implements ProjectStrategy {
    private final RedmineUtil redmineUtil;
    private final RedmineApi redmineApi;
    private final ServerInfoService serverInfoService;

    public ProjectVO getProject(ServerInfo serverInfo, String projectKeyOrId) {
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            Project project = redmineManager.getProjectManager().getProjectById(Integer.parseInt(projectKeyOrId));
            return this.convertProjectVO(project, null, serverInfo.getUri());
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), (String)this.getClass().getName(), (String)String.format("%s[%s] :: getProject Error \ud504\ub85c\uc81d\ud2b8[%s] ", serverInfo.getType(), serverInfo.getUri(), projectKeyOrId));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public List<ProjectVO> getProjectList(ServerInfo serverInfo) {
        List redmineProjectList;
        RedmineManager redmineManager = this.redmineUtil.createRedmineOnPremiseCommunicator(serverInfo.getUri(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            redmineProjectList = redmineManager.getProjectManager().getProjects();
        }
        catch (RedmineException e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)((Object)e), (String)this.getClass().getName(), (String)String.format("%s[%s] :: getProjectList Error", serverInfo.getType(), serverInfo.getUri()));
            throw new IllegalArgumentException(errorMessage);
        }
        Map projectMap = redmineProjectList.stream().collect(Collectors.toMap(Project::getId, Function.identity()));
        List<ProjectVO> projectVOS = redmineProjectList.stream().filter(Objects::nonNull).map(\ud504\ub85c\uc81d\ud2b8 -> {
            String \uc804\uccb4_\ud504\ub85c\uc81d\ud2b8\uba85 = this.\uc0c1\uc704_\ud504\ub85c\uc81d\ud2b8\uba85_\uc124\uc815(\ud504\ub85c\uc81d\ud2b8, projectMap);
            return this.convertProjectVO(\ud504\ub85c\uc81d\ud2b8, \uc804\uccb4_\ud504\ub85c\uc81d\ud2b8\uba85, serverInfo.getUri());
        }).collect(Collectors.toList());
        return projectVOS;
    }

    public String \uc0c1\uc704_\ud504\ub85c\uc81d\ud2b8\uba85_\uc124\uc815(Project project, Map<Integer, Project> projectMap) {
        return Optional.ofNullable(project.getParentId()).map(parentId -> this.\uc0c1\uc704_\ud504\ub85c\uc81d\ud2b8\uba85_\uc124\uc815((Project)projectMap.get(parentId), projectMap) + "&nbsp;-&nbsp;" + project.getName()).orElse(project.getName());
    }

    private ProjectVO convertProjectVO(Project project, String projectName, String serverUrl) {
        if (project == null) {
            return null;
        }
        return ProjectVO.builder().id(String.valueOf(project.getId())).key(String.valueOf(project.getId())).name(Optional.ofNullable(projectName).orElse(project.getName())).self(this.redmineUtil.checkServerInfoPath(serverUrl) + this.redmineApi.replaceID(this.redmineApi.getEndpoint().getProject(), String.valueOf(project.getId()))).build();
    }

    @Generated
    public OnpremiseRedmineProjectStrategy(RedmineUtil redmineUtil, RedmineApi redmineApi, ServerInfoService serverInfoService) {
        this.redmineUtil = redmineUtil;
        this.redmineApi = redmineApi;
        this.serverInfoService = serverInfoService;
    }
}

