/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.wiki.service;

import com.arms.api.wiki.model.WikiDTO;
import com.arms.api.wiki.model.WikiEntity;
import com.arms.api.wiki.model.WikiVO;
import com.arms.api.wiki.model.WikiVersionVO;
import com.arms.api.wiki.model.WikiVersionsVO;
import com.arms.api.wiki.service.WikiService;
import com.arms.api.wiki.service.WikiServiceImpl;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import com.arms.egovframework.javaservice.esframework.model.dto.esquery.SortDTO;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WikiServiceImpl
implements WikiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WikiServiceImpl.class);
    private final EsCommonRepositoryWrapper<WikiEntity> esCommonRepositoryWrapper;

    public WikiVO getWiki(String wikiId) {
        WikiEntity docs = (WikiEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiId));
        return WikiConverter.toVO((WikiEntity)docs);
    }

    public WikiVO getWiki(String wikiId, Long version) {
        WikiEntity docs = (WikiEntity)this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter((String)"wiki_id", (Object)wikiId).andTermQueryFilter("version", (Object)version)).findFirst();
        return WikiConverter.toVO((WikiEntity)docs);
    }

    public WikiVersionsVO getWikiVersions(String wikiId, int size, int page) {
        WikiDTO wikiDTO = new WikiDTO();
        wikiDTO.setSize(size);
        wikiDTO.setPage(page);
        wikiDTO.setFieldIncludes(new String[]{"wiki_id", "version", "author", "recent", "created_date", "updated_date"});
        DocumentResultWrapper wiki = this.esCommonRepositoryWrapper.findHits(SimpleQuery.search((SearchRequestDTO)wikiDTO).andTermQueryFilter("wiki_id", (Object)wikiId).orderBy(new SortDTO[]{SortDTO.builder().field("updated_date").sortType("desc").build()}));
        Long totalHits = wiki.getTotalHits();
        List docs = wiki.toDocs();
        ArrayList<WikiVersionVO> wikiVersions = new ArrayList<WikiVersionVO>();
        for (WikiEntity wikiEntity : docs) {
            wikiVersions.add(WikiVersionVO.builder().wikiId(wikiEntity.getWikiId()).version(wikiEntity.getVersion()).author(wikiEntity.getAuthor()).recent(wikiEntity.isRecent()).createdDate(wikiEntity.getCreatedDate()).updatedDate(wikiEntity.getUpdatedDate()).build());
        }
        return WikiVersionsVO.builder().totalHits(totalHits).wikiVersions(wikiVersions).build();
    }

    public String createWiki(WikiDTO wikiDTO) {
        WikiEntity savedEntity = (WikiEntity)this.esCommonRepositoryWrapper.save((BaseEntity)wikiDTO.createEntity());
        return savedEntity.generateIdWithVersion();
    }

    public String updateWiki(WikiDTO wikiDTO) {
        WikiEntity fetchedWiki = (WikiEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiDTO.getWikiId()));
        if (fetchedWiki == null) {
            throw new IllegalArgumentException("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 Wiki \ubb38\uc11c");
        }
        fetchedWiki.updateWikiEntity(wikiDTO.createEntityWithVersionUp(fetchedWiki.getVersion()));
        WikiEntity savedEntity = (WikiEntity)this.esCommonRepositoryWrapper.save((BaseEntity)fetchedWiki);
        return savedEntity.generateIdWithVersion();
    }

    public void changeRecent(WikiDTO wikiDTO) {
        DocumentResultWrapper currentRecent = this.esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter((String)"wiki_id", (Object)wikiDTO.getWikiId()));
        currentRecent.toHitDocs().forEach(a -> {
            String index = a.getIndex();
            WikiEntity content = (WikiEntity)a.getContent();
            content.setRecent(false);
            this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, index);
        });
        DocumentResultWrapper wiki = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryFilter((String)"wiki_id", (Object)wikiDTO.getWikiId()).andTermQueryFilter("version", (Object)wikiDTO.getVersion()));
        wiki.toHitDocs().forEach(a -> {
            String index = a.getIndex();
            WikiEntity content = (WikiEntity)a.getContent();
            content.setRecent(true);
            this.esCommonRepositoryWrapper.modifyWithIndexName((BaseEntity)content, index);
        });
    }

    public String deleteWiki(String wikiId) {
        WikiEntity wikiEntity = (WikiEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)wikiId));
        if (wikiEntity == null) {
            throw new IllegalArgumentException("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uc704\ud0a4 \ubb38\uc11c");
        }
        List docs = this.esCommonRepositoryWrapper.findHits(SimpleQuery.termQueryMust((String)"wikiId", (Object)wikiId)).toDocs();
        for (WikiEntity doc : docs) {
            this.esCommonRepositoryWrapper.deleteById((Serializable)((Object)doc.getId()));
        }
        return wikiId;
    }

    @Generated
    public WikiServiceImpl(EsCommonRepositoryWrapper<WikiEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

