/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.custom.client;

import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.geo.GeoDistance;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.data.client.orhlc.HighlightQueryBuilder;
import org.opensearch.data.client.orhlc.NativeSearchQuery;
import org.opensearch.data.client.orhlc.ScriptField;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.rescore.QueryRescoreMode;
import org.opensearch.search.rescore.QueryRescorerBuilder;
import org.opensearch.search.rescore.RescorerBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.GeoDistanceSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class CustomRequestFactory {
    private final ElasticsearchConverter elasticsearchConverter;

    public CustomRequestFactory(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    @Nullable
    public HighlightBuilder highlightBuilder(Query query) {
        NativeSearchQuery searchQuery;
        HighlightBuilder highlightBuilder = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext()).getHighlightBuilder(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        if (highlightBuilder == null && query instanceof NativeSearchQuery && ((searchQuery = (NativeSearchQuery)query).getHighlightFields() != null && searchQuery.getHighlightFields().length > 0 || searchQuery.getHighlightBuilder() != null)) {
            highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
        }
        return highlightBuilder;
    }

    public SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<?> clazz, IndexCoordinates index) {
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequest searchRequest = this.prepareSearchRequest(query, routing, clazz, index);
        QueryBuilder opensearchQuery = this.getQuery(query);
        QueryBuilder opensearchFilter = this.getFilter(query);
        searchRequest.source().query(opensearchQuery);
        if (opensearchFilter != null) {
            searchRequest.source().postFilter(opensearchFilter);
        }
        return searchRequest;
    }

    private SearchRequest prepareSearchRequest(Query query, @Nullable String routing, @Nullable Class<?> clazz, IndexCoordinates indexCoordinates) {
        SearchRequest request;
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (query.getPointInTime() == null) {
            Object[] indexNames = indexCoordinates.getIndexNames();
            Assert.notNull((Object)indexNames, (String)"No index defined for Query");
            Assert.notEmpty((Object[])indexNames, (String)"No index defined for Query");
            request = new SearchRequest((String[])indexNames);
        } else {
            request = new SearchRequest();
            PointInTimeBuilder pointInTimeBuilder = new PointInTimeBuilder(query.getPointInTime().id());
            pointInTimeBuilder.setKeepAlive(TimeValue.timeValueMillis((long)query.getPointInTime().keepAlive().toMillis()));
            sourceBuilder.pointInTimeBuilder(pointInTimeBuilder);
        }
        sourceBuilder.version(Boolean.valueOf(true));
        sourceBuilder.trackScores(query.getTrackScores());
        if (this.hasSeqNoPrimaryTermProperty(clazz)) {
            sourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        }
        sourceBuilder.from((int)(query.getPageable().isPaged() ? query.getPageable().getOffset() : 0L)).size(query.getRequestSize().intValue());
        if (query.getSourceFilter() != null) {
            sourceBuilder.fetchSource(this.getFetchSourceContext(query));
            SourceFilter sourceFilter = query.getSourceFilter();
            sourceBuilder.fetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getDocValueFields())) {
            List docValueFields = query.getDocValueFields();
            docValueFields.forEach(field -> sourceBuilder.docValueField(field.field()));
        }
        if (!query.getFields().isEmpty()) {
            query.getFields().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).fetchField(arg_0));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getStoredFields())) {
            sourceBuilder.storedFields(query.getStoredFields());
        }
        if (query.getIndicesOptions() != null) {
            request.indicesOptions(this.toOpenSearchIndicesOptions(query.getIndicesOptions()));
        }
        if (query.isLimiting()) {
            sourceBuilder.size(query.getMaxResults().intValue());
        }
        if (query.getMinScore() > 0.0f) {
            sourceBuilder.minScore(query.getMinScore());
        }
        if (query.getPreference() != null) {
            request.preference(query.getPreference());
        }
        request.searchType(SearchType.fromString((String)query.getSearchType().name().toLowerCase()));
        this.prepareSort(query, sourceBuilder, this.getPersistentEntity(clazz));
        HighlightBuilder highlightBuilder = this.highlightBuilder(query);
        if (highlightBuilder != null) {
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (query instanceof NativeSearchQuery) {
            this.prepareNativeSearch((NativeSearchQuery)query, sourceBuilder);
        }
        if (query.getTrackTotalHits() != null) {
            sourceBuilder.trackTotalHits(query.getTrackTotalHits().booleanValue());
        } else if (query.getTrackTotalHitsUpTo() != null) {
            sourceBuilder.trackTotalHitsUpTo(query.getTrackTotalHitsUpTo().intValue());
        }
        if (StringUtils.hasLength((String)query.getRoute())) {
            request.routing(query.getRoute());
        } else if (StringUtils.hasText((String)routing)) {
            request.routing(routing);
        }
        Duration timeout = query.getTimeout();
        if (timeout != null) {
            sourceBuilder.timeout(new TimeValue(timeout.toMillis()));
        }
        sourceBuilder.explain(Boolean.valueOf(query.getExplain()));
        if (query.getSearchAfter() != null) {
            sourceBuilder.searchAfter(query.getSearchAfter().toArray());
        }
        query.getRescorerQueries().forEach(rescorer -> sourceBuilder.addRescorer((RescorerBuilder)this.getQueryRescorerBuilder(rescorer)));
        if (query.getRequestCache() != null) {
            request.requestCache(query.getRequestCache());
        }
        if (query.getScrollTime() != null) {
            request.scroll(TimeValue.timeValueMillis((long)query.getScrollTime().toMillis()));
        }
        request.source(sourceBuilder);
        return request;
    }

    private void prepareNativeSearch(NativeSearchQuery query, SearchSourceBuilder sourceBuilder) {
        if (!query.getScriptFields().isEmpty()) {
            for (ScriptField scriptedField : query.getScriptFields()) {
                sourceBuilder.scriptField(scriptedField.fieldName(), scriptedField.script());
            }
        }
        if (query.getCollapseBuilder() != null) {
            sourceBuilder.collapse(query.getCollapseBuilder());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getIndicesBoost())) {
            for (IndexBoost indexBoost : query.getIndicesBoost()) {
                sourceBuilder.indexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)query.getAggregations())) {
            query.getAggregations().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (!CollectionUtils.isEmpty((Collection)query.getPipelineAggregations())) {
            query.getPipelineAggregations().forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (query.getSuggestBuilder() != null) {
            sourceBuilder.suggest(query.getSuggestBuilder());
        }
        if (!CollectionUtils.isEmpty((Collection)query.getSearchExtBuilders())) {
            sourceBuilder.ext(query.getSearchExtBuilders());
        }
    }

    private void prepareSort(Query query, SearchSourceBuilder sourceBuilder, @Nullable ElasticsearchPersistentEntity<?> entity) {
        NativeSearchQuery nativeSearchQuery;
        List sorts;
        if (query.getSort() != null) {
            query.getSort().forEach(order -> sourceBuilder.sort(this.getSortBuilder(order, entity)));
        }
        if (query instanceof NativeSearchQuery && (sorts = (nativeSearchQuery = (NativeSearchQuery)query).getOpenSearchSorts()) != null) {
            sorts.forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).sort(arg_0));
        }
    }

    private SortBuilder<?> getSortBuilder(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> entity) {
        String fieldName;
        SortOrder sortOrder = order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC;
        Order.Mode mode = null;
        String unmappedType = null;
        if (order instanceof Order) {
            Order o = (Order)order;
            mode = o.getMode();
            unmappedType = o.getUnmappedType();
        }
        if (mode == null) {
            mode = Order.Mode.min;
        }
        if ("_score".equals(order.getProperty())) {
            return SortBuilders.scoreSort().order(sortOrder);
        }
        ElasticsearchPersistentProperty property = entity != null ? (ElasticsearchPersistentProperty)entity.getPersistentProperty(order.getProperty()) : null;
        String string = fieldName = property != null ? property.getFieldName() : order.getProperty();
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            GeoDistanceSortBuilder sort = SortBuilders.geoDistanceSort((String)fieldName, (double)geoDistanceOrder.getGeoPoint().getLat(), (double)geoDistanceOrder.getGeoPoint().getLon());
            sort.geoDistance(GeoDistance.fromString((String)geoDistanceOrder.getDistanceType().name()));
            sort.sortMode(SortMode.fromString((String)mode.name()));
            sort.unit(DistanceUnit.fromString((String)geoDistanceOrder.getUnit()));
            if (geoDistanceOrder.getIgnoreUnmapped() != GeoDistanceOrder.DEFAULT_IGNORE_UNMAPPED) {
                sort.ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped().booleanValue());
            }
            return sort;
        }
        FieldSortBuilder sort = ((FieldSortBuilder)SortBuilders.fieldSort((String)fieldName).order(sortOrder)).sortMode(SortMode.fromString((String)mode.name()));
        if (unmappedType != null) {
            sort.unmappedType(unmappedType);
        }
        if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
            sort.missing((Object)"_first");
        } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
            sort.missing((Object)"_last");
        }
        return sort;
    }

    private QueryRescorerBuilder getQueryRescorerBuilder(RescorerQuery rescorerQuery) {
        QueryBuilder queryBuilder = this.getQuery(rescorerQuery.getQuery());
        Assert.notNull((Object)"queryBuilder", (String)"Could not build query for rescorerQuery");
        QueryRescorerBuilder builder = new QueryRescorerBuilder(queryBuilder);
        if (rescorerQuery.getScoreMode() != RescorerQuery.ScoreMode.Default) {
            builder.setScoreMode(QueryRescoreMode.valueOf((String)rescorerQuery.getScoreMode().name()));
        }
        if (rescorerQuery.getQueryWeight() != null) {
            builder.setQueryWeight(rescorerQuery.getQueryWeight().floatValue());
        }
        if (rescorerQuery.getRescoreQueryWeight() != null) {
            builder.setRescoreQueryWeight(rescorerQuery.getRescoreQueryWeight().floatValue());
        }
        if (rescorerQuery.getWindowSize() != null) {
            builder.windowSize(rescorerQuery.getWindowSize().intValue());
        }
        return builder;
    }

    @Nullable
    private QueryBuilder getQuery(Query query) {
        if (!(query instanceof NativeSearchQuery)) {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        NativeSearchQuery searchQuery = (NativeSearchQuery)query;
        QueryBuilder opensearchQuery = searchQuery.getQuery();
        return opensearchQuery;
    }

    @Nullable
    private QueryBuilder getFilter(Query query) {
        if (!(query instanceof NativeSearchQuery)) {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        NativeSearchQuery searchQuery = (NativeSearchQuery)query;
        QueryBuilder opensearchFilter = searchQuery.getFilter();
        return opensearchFilter;
    }

    @Nullable
    private FetchSourceContext getFetchSourceContext(Query searchQuery) {
        SourceFilter sourceFilter = searchQuery.getSourceFilter();
        if (sourceFilter != null) {
            Boolean fetchSource = sourceFilter.fetchSource();
            if (fetchSource != null && !fetchSource.booleanValue()) {
                return new FetchSourceContext(false);
            }
            return new FetchSourceContext(true, sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        return null;
    }

    public org.opensearch.action.support.IndicesOptions toOpenSearchIndicesOptions(IndicesOptions indicesOptions) {
        Assert.notNull((Object)indicesOptions, (String)"indicesOptions must not be null");
        Set options = indicesOptions.getOptions().stream().map(it -> IndicesOptions.Option.valueOf((String)it.name().toUpperCase())).collect(Collectors.toSet());
        Set wildcardStates = indicesOptions.getExpandWildcards().stream().map(it -> IndicesOptions.WildcardStates.valueOf((String)it.name().toUpperCase())).collect(Collectors.toSet());
        return new org.opensearch.action.support.IndicesOptions(options.isEmpty() ? EnumSet.noneOf(IndicesOptions.Option.class) : EnumSet.copyOf(options), wildcardStates.isEmpty() ? EnumSet.noneOf(IndicesOptions.WildcardStates.class) : EnumSet.copyOf(wildcardStates));
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    private boolean hasSeqNoPrimaryTermProperty(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            return false;
        }
        if (!this.elasticsearchConverter.getMappingContext().hasPersistentEntityFor(entityClass)) {
            return false;
        }
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(entityClass);
        return entity.hasSeqNoPrimaryTermProperty();
    }
}

