/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.esframework.model.vo;

import com.arms.egovframework.javaservice.esframework.model.vo.DocumentBucket;
import com.arms.egovframework.javaservice.esframework.model.vo.SearchDocResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHits;

public class DocumentAggregations
implements SearchDocResult {
    private final Long totalHits;
    private final Long docSumCount;
    private final List<DocumentBucket> documentBuckets;

    public DocumentAggregations(SearchHits<?> searchHits) {
        this.totalHits = searchHits.getTotalHits();
        AggregationsContainer aggregations = searchHits.getAggregations();
        Map<String, Aggregation> mainBucketsAggregationMap = this.getTerm(aggregations).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.documentBuckets = new DocumentAggregations(mainBucketsAggregationMap).docBuckets();
        this.docSumCount = this.documentBuckets.stream().mapToLong(DocumentBucket::getDocCount).reduce(0L, Long::sum);
    }

    public DocumentAggregations(List<DocumentBucket> documentBuckets) {
        this.totalHits = -1L;
        this.docSumCount = -1L;
        this.documentBuckets = documentBuckets;
    }

    DocumentAggregations(Map<String, Aggregation> bucketsAggregationMap) {
        this.documentBuckets = bucketsAggregationMap.entrySet().stream().flatMap(arg_0 -> this.createDocumentBucket(arg_0)).collect(Collectors.toList());
        this.totalHits = -1L;
        this.docSumCount = -1L;
    }

    private Stream<DocumentBucket> createDocumentBucket(Map.Entry<String, Aggregation> bucket) {
        if (bucket.getValue() instanceof NumericMetricsAggregation.SingleValue) {
            return Stream.of((NumericMetricsAggregation.SingleValue)bucket.getValue()).map(bucketValue -> new DocumentBucket((String)bucket.getKey(), bucketValue));
        }
        return ((MultiBucketsAggregation)bucket.getValue()).getBuckets().stream().map(bucketValue -> new DocumentBucket((String)bucket.getKey(), bucketValue));
    }

    private Map<String, Aggregation> getTerm(AggregationsContainer<?> aggregationsContainer) {
        return Optional.ofNullable(aggregationsContainer).map(a -> ((Aggregations)a.aggregations()).getAsMap()).orElseGet(HashMap::new);
    }

    public List<DocumentBucket> deepestList() {
        return this.documentBuckets.stream().flatMap(a -> a.getDeepestDocument().stream()).collect(Collectors.toList());
    }

    public List<DocumentBucket> docBuckets() {
        return this.documentBuckets;
    }

    @Generated
    public Long getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public Long getDocSumCount() {
        return this.docSumCount;
    }
}

