package com.arms.api.issue.almapi.model.vo.cloudjiraspec;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Set;


@Getter
@Slf4j
@ToString
public class CloudJiraIssueRawDataVOCollection {

    private final Set<CloudJiraIssueRawDataVO> issueSet;

    public CloudJiraIssueRawDataVOCollection(Set<CloudJiraIssueRawDataVO> issueSet){
        this.issueSet = issueSet;
    }

    public CloudJiraIssueRawDataVO get(String key){
        return issueSet.stream()
                .filter(a -> key.equals(a.getKey()))
                .findFirst().orElse(null);
    }

    public void add(CloudJiraIssueRawDataVO cloudJiraIssueRawDataVO){
        issueSet.add(cloudJiraIssueRawDataVO);

    }

    public void addAll(List<CloudJiraIssueRawDataVO> cloudJiraIssueRawDataVOS){
        cloudJiraIssueRawDataVOS.forEach(this::add);
    }

}
