package com.arms.config;

import com.arms.api.util.alm.JiraApi;
import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@AllArgsConstructor
public class WebClientBuilder {

    private final JiraApi jiraApi;

    @Bean
    public WebClient.Builder builder() {

        return WebClient.builder()
                .exchangeStrategies(ExchangeStrategies.builder().codecs(configure->{
                    configure.defaultCodecs().maxInMemorySize(jiraApi.getPacketSize());
                }).build());
    }

}
