package com.arms.api.issue.almapi.service;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;

import java.io.File;

import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public abstract class WireMockJiraConfig {

    protected static WireMockServer mockServer1;


    @BeforeAll
    public void startWireMocks()  {

//        File mappingFile =  new File("src/test/resources/wiremock/jira/mappings").getAbsoluteFile();
//        File file =  new File("src/test/resources/wiremock/jira/__files").getAbsoluteFile();
//
//
//        if (!mappingFile.exists()) {
//            mappingFile.mkdirs();
//        }
//
//        if (!file.exists()) {
//            file.mkdirs();
//        }

        mockServer1 = new WireMockServer(
                wireMockConfig()
                        .port(8089)
                        .usingFilesUnderClasspath("wiremock/jira")
        );

//        mockServer1.enableRecordMappings(new SingleRootFileSource(mappingFile),new SingleRootFileSource(file));

        mockServer1.start();

//        mockServer1.startRecording("http://313.co.kr/jira");

    }

    @AfterAll
    public void stopWireMocks() {
        if (mockServer1 != null && mockServer1.isRunning()) {
//             mockServer1.stopRecording();
            mockServer1.stop();
        }
    }
}
