package com.arms.api.account.model;


import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

@Getter
@Setter
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AlmAccount {
    String self;

    String name;

    String emailAddress;

    String displayName;

    Boolean active;

    Boolean admin;

    @JsonProperty(value="api_key")
    String apiKey;
}
