package com.arms.api.admin.almissue.controller;

import com.arms.api.admin.almissue.service.AlmIssueIndexAdminService;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import static com.arms.api.util.response.CommonResponse.success;


@RequestMapping("/engine/index/alm-issue")
@AllArgsConstructor
@RestController
public class AlmIssueIndexAdminController {

    private final AlmIssueIndexAdminService almIssueIndexAdminService;

    @PostMapping("/merge-with-reindex")
    public ResponseEntity<CommonResponse.ApiResult<String>> mergeWithReindex()  {
        almIssueIndexAdminService.merge();
        return ResponseEntity.ok(success("OK"));
    }

    @PostMapping("/merge-with-reindex/day/{day}")
    public ResponseEntity<CommonResponse.ApiResult<String>> mergeWithReindexByDay(@PathVariable int day)  {
        almIssueIndexAdminService.merge(day);
        return ResponseEntity.ok(success("OK"));
    }


}
