package com.arms.api.analysis.resource.service;

import com.arms.api.analysis.resource.model.dto.ResourceRequestDTO;
import com.arms.api.analysis.resource.model.dto.ResourceWithVersionIdNamesDTO;
import com.arms.api.analysis.resource.model.vo.treemap.TreeMapWorkerVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeIssueStatusVO;
import com.arms.api.analysis.resource.model.vo.UniqueAssigneeVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.HorizontalBarChartYAxisAndSeriesVO;
import com.arms.api.analysis.resource.model.vo.horizontalbar.ReqAndNotReqHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.pie.ReqAndNotReqPieChartVO;
import com.arms.api.analysis.resource.model.vo.pie.TotalIssueAndPieChartVO;
import com.arms.api.analysis.resource.model.vo.sankey.SankeyChartBaseVO;
import com.arms.api.analysis.resource.model.vo.stackedHorizontalBar.StackedHorizontalBarChartVO;
import com.arms.api.analysis.resource.model.vo.wordcloud.WordCloudExcelVO;

import java.util.List;

public interface AnalysisResource {

    // datatable (worker-status)
    List<UniqueAssigneeIssueStatusVO> issueStatusDataByAssignee(ResourceRequestDTO resourceDTO);

    // 워드클라우드
    List<WordCloudExcelVO> wordCloudData(ResourceRequestDTO resourceDTO);
    // 수평스택바
    StackedHorizontalBarChartVO issueStatusStackedBarChartData(ResourceRequestDTO resourceDTO);

    // pie
    ReqAndNotReqPieChartVO findPieChartData(ResourceRequestDTO resourceDTO);
    // pie (expand)
    TotalIssueAndPieChartVO findPieChartDataExpand(ResourceRequestDTO resourceDTO);
    // 수평바 - 요구사항 또는 하위이슈로 각각 가져오는 서비스(isReq 및 accounts) :: Expand 와 기본화면에서 사용 가능.
    List<HorizontalBarChartYAxisAndSeriesVO> findHorizontalBarChartData(ResourceRequestDTO resourceDTO);
    // 수평바 - (n and nr at once by same accounts) - datatable click
    ReqAndNotReqHorizontalBarChartVO findHorizontalBarChartDataBySameAccounts(ResourceRequestDTO resourceDTO);

    // 샌키
    List<SankeyChartBaseVO> sankeyChartBaseDataV3(ResourceRequestDTO resourceDTO);

    // List of Assignees' information
    List<UniqueAssigneeVO> findAssigneesInfo(ResourceRequestDTO resourceDTO);

    // 트리맵
    List<TreeMapWorkerVO> findTreeMapChartDataV2(ResourceWithVersionIdNamesDTO dto);
    List<TreeMapWorkerVO> findTreeMapChartDataV3(ResourceWithVersionIdNamesDTO dto);
}
