package com.arms.api.analysis.time.service;

import com.arms.api.analysis.time.dto.TimeAggrDTO;
import com.arms.api.analysis.time.dto.TimeDTO;
import com.arms.api.analysis.time.vo.*;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;

import java.util.List;

public interface AnalysisTime {

    //히트맵
    HeatMapVO getHeatMapDataByUpdated(TimeDTO timeDTO);
    DateIssueCountVO getDateHistogramCardinalityData(TimeDTO timeDTO);
    //스캐터
    List<ScatterChartVO> getScatterData(TimeDTO timeDTO);
    // 멀티콤비네이션 차트
    List<AlmIssueStatVO> getMultiCombinationChartData(TimeDTO timeDTO);
    // vertical-timeline
    List<AlmIssueEntity> getUpdatedReqIssueByDateRange(TimeAggrDTO timeAggrDTO);
    // ridge-line
    List<RidgeLineVO> getRidgeLineData(TimeDTO timeDTO);
}
