package com.arms.api.issue.status.controller;

import com.arms.api.issue.status.service.IssueStatusService;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.util.errors.ErrorCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/{connectId}/jira/issuestatus")
public class IssueStatusController {

    private final IssueStatusService issueStatusService;

    @Autowired
    public IssueStatusController(IssueStatusService issueStatusService) {
        this.issueStatusService = issueStatusService;
    }

    @ResponseBody
    @RequestMapping(
            value = {"/list"},
            method = {RequestMethod.GET}
    )
    public List<IssueStatusVO> getIssueStatusList(@PathVariable("connectId") String connectId) {

        if (connectId == null) {
            log.error("getIssueStatusList Error: connectId {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getIssueStatusList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        return issueStatusService.getIssueStatusList(connectId);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/project/{projectId}"},
            method = {RequestMethod.GET}
    )
    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(@PathVariable("connectId") String connectId,
                                                                               @PathVariable("projectId") String projectId) {

        if (connectId == null) {
            log.error("getIssueStatusListByProject Error: connectId {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getIssueStatusListByProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        if (StringUtils.isEmpty(projectId)) {
            log.error("getIssueStatusListByProject Error projectId {}", ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
            throw new IllegalArgumentException("getIssueStatusListByProject Error projectId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
        }

        return issueStatusService.getIssueStatusListByProject(connectId, projectId);
    }
}
