package com.arms.api.poc.model.dto;

import com.arms.api.poc.model.entity.PocEntity;
import com.arms.egovframework.javaservice.esframework.model.dto.request.SearchRequestDTO;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

@Getter
@Setter
public class PocDTO extends SearchRequestDTO {

    private String id;

    private String c_poc_first_name;
    private String c_poc_last_name;
    private String c_poc_full_name;
    private String c_poc_company_name;
    private String c_poc_company_size;
    private String c_poc_job_title;
    private String c_poc_email_address;
    private String c_poc_country;
    private Long c_poc_country_code;
    private String c_poc_contact_number;
    private String c_poc_inquiry_reason;
    private String c_poc_inquiry_content;
    private Date c_poc_inquiry_date;
    private String c_poc_assignee_id;
    private String c_poc_assignee_username;
    private String c_poc_assignee_name;
    private String c_poc_assignee_email;
    private Long c_poc_assignee_link;
    private String c_poc_status;
    private String c_poc_status_memo;
    private Date c_poc_status_updated;
    private Boolean c_poc_marketing_consent;
    private String c_poc_etc;
    private String c_poc_desc;
    private String c_poc_contents;

    public PocEntity toPocEntityWithCreate() {
        PocEntity pocEntity = createEntity();

        if (c_poc_inquiry_date == null) {
            pocEntity.setC_poc_inquiry_date(new Date());
        }
        if (c_poc_status == null) {
            pocEntity.setC_poc_status("PENDING");
        }

        return pocEntity;
    }

    public PocEntity toPocEntityWithUpdate() {
        PocEntity pocEntity = createEntity();

        if (c_poc_status_updated == null) {
            pocEntity.setC_poc_status_updated(new Date());
        }

        return pocEntity;
    }

    private PocEntity createEntity() {
        return PocEntity.builder()
                .c_poc_first_name(this.c_poc_first_name)
                .c_poc_last_name(this.c_poc_last_name)
                .c_poc_full_name(this.c_poc_full_name)
                .c_poc_company_name(this.c_poc_company_name)
                .c_poc_company_size(this.c_poc_company_size)
                .c_poc_job_title(this.c_poc_job_title)
                .c_poc_email_address(this.c_poc_email_address)
                .c_poc_country(this.c_poc_country)
                .c_poc_country_code(this.c_poc_country_code)
                .c_poc_contact_number(this.c_poc_contact_number)
                .c_poc_inquiry_reason(this.c_poc_inquiry_reason)
                .c_poc_inquiry_content(this.c_poc_inquiry_content)
                .c_poc_inquiry_date(this.c_poc_inquiry_date)
                .c_poc_assignee_id(this.c_poc_assignee_id)
                .c_poc_assignee_username(this.c_poc_assignee_username)
                .c_poc_assignee_name(this.c_poc_assignee_name)
                .c_poc_assignee_email(this.c_poc_assignee_email)
                .c_poc_assignee_link(this.c_poc_assignee_link)
                .c_poc_status(this.c_poc_status)
                .c_poc_status_memo(this.c_poc_status_memo)
                .c_poc_status_updated(this.c_poc_status_updated)
                .c_poc_marketing_consent(this.c_poc_marketing_consent)
                .c_poc_etc(this.c_poc_etc)
                .c_poc_desc(this.c_poc_desc)
                .c_poc_contents(this.c_poc_contents)
                .build();
    }
}
