package com.arms.api.report.controller;

import com.arms.api.report.model.AssigneeIssueCountVO;
import com.arms.api.report.model.FullDataRequestDTO;
import com.arms.api.report.service.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/engine/report")
@Slf4j
public class ReportController {

    @Autowired
    private ReportService reportService;

    @GetMapping("/resource-list")
    public ResponseEntity<?> 작업자_목록_가져오기() {
        return ResponseEntity.ok(reportService.작업자_목록_가져오기());
    }

    @GetMapping("/issue-list")
    public ResponseEntity<?> 이슈_목록_가져오기(FullDataRequestDTO fullDataRequestDTO) {
        return ResponseEntity.ok(reportService.이슈_목록_가져오기(fullDataRequestDTO));
    }

    @GetMapping("/issue-list-calendar")
    public ResponseEntity<?> 이슈_목록_가져오기_calendar(FullDataRequestDTO fullDataRequestDTO) {
        return ResponseEntity.ok(reportService.이슈_목록_가져오기_calendar(fullDataRequestDTO));
    }

    @GetMapping("/issue-list-scroll-api")
    public ResponseEntity<?> 이슈_목록_가져오기_스크롤API(FullDataRequestDTO fullDataRequestDTO) {
        return ResponseEntity.ok(reportService.이슈_목록_가져오기_스크롤API(fullDataRequestDTO));
    }

    @GetMapping("/req-issue-list")
    public ResponseEntity<?> getReqIssueList(FullDataRequestDTO fullDataRequestDTO) {
        return ResponseEntity.ok(reportService.getReqIssueList(fullDataRequestDTO));
    }

    @GetMapping("/assignee-report")
    public ResponseEntity<AssigneeIssueCountVO> getAssigneeAggregationList(FullDataRequestDTO fullDataRequestDTO) {
        return ResponseEntity.ok(reportService.getAssigneeAggregationList(fullDataRequestDTO));
    }

}
