package com.arms.api.util.alm;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Getter
@Setter
@Component
@RefreshScope
@ConfigurationProperties(prefix = "redmine.api")
public class RedmineApi {

    private Endpoint endpoint;

    @Getter
    @Setter
    public static class Endpoint {
        private String project;
        private String issuetype;
        private String priority;
        private String issuestatus;
        private String issue;
        private String priorityList;
    }

    public String replaceID(String endPoint, String id) {
        return endPoint.replace("{아이디}", id);
    }
}
