package com.arms.egovframework.javaservice.esframework.esquery.filter;

import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;

import java.time.LocalDate;

public class RangeQueryFilter extends Filter<RangeQueryBuilder> {

    private RangeQueryBuilder rangeQueryBuilder;

    private RangeQueryFilter(String name){
        this.rangeQueryBuilder = QueryBuilders.rangeQuery(name);
    }

    public static RangeQueryFilter of(String name){
        return new RangeQueryFilter(name);
    }


    public RangeQueryFilter lt(LocalDate lt){
        if(lt!=null){
            this.rangeQueryBuilder.lt(lt);
        }
        if(lt==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lt(String lt){

        String lessThan = checkEmptyThenNull(lt);

        if(lessThan!=null){
            this.rangeQueryBuilder.lt(lessThan);
        }
        if(lessThan==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lte(LocalDate lte){
        if(lte!=null){
            this.rangeQueryBuilder.lte(lte);
        }
        if(lte==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter lte(String lte){

        String lessThanOrEqualTo = checkEmptyThenNull(lte);

        if(lessThanOrEqualTo!=null){
            this.rangeQueryBuilder.lte(lessThanOrEqualTo);
        }
        if(lessThanOrEqualTo==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gt(LocalDate gt){
        if(gt!=null){
            this.rangeQueryBuilder.gt(gt);
        }
        if(gt==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gt(String gt){

        String greaterThan = checkEmptyThenNull(gt);

        if(greaterThan!=null){
            this.rangeQueryBuilder.gt(greaterThan);
        }
        if(greaterThan==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gte(LocalDate gte){
        if(gte!=null){
            this.rangeQueryBuilder.gte(gte);
        }
        if(gte==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter gte(String gte){

        String greaterThanOrEqualTo = checkEmptyThenNull(gte);

        if(greaterThanOrEqualTo!=null){
            this.rangeQueryBuilder.gte(greaterThanOrEqualTo);
        }
        if(greaterThanOrEqualTo==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }


    public RangeQueryFilter from(LocalDate from){
        if(from!=null){
            this.rangeQueryBuilder.from(from);
        }
        if(from==null){
            this.rangeQueryBuilder = null;
        }
        return this;
    }

    public RangeQueryFilter from(String from){

        String fromParam = checkEmptyThenNull(from);

        if(fromParam!=null){
            this.rangeQueryBuilder.from(fromParam);
        }
        if(fromParam==null){
            this.rangeQueryBuilder = null;
        }

        return this;
    }

    public RangeQueryFilter to(LocalDate to){

        if(to!=null){
            this.rangeQueryBuilder.to(to);
        }

        if(to==null){
            this.rangeQueryBuilder = null;
        }

        return this;
    }

    public RangeQueryFilter to(String to){

        String toParam = checkEmptyThenNull(to);

        if(toParam!=null){
            this.rangeQueryBuilder.to(toParam);
        }

        if(toParam==null){
            this.rangeQueryBuilder = null;
        }

        return this;
    }

    public RangeQueryFilter betweenDate(String from, String to){

        greaterThanOrEqualTo(from, to);

        lessThanOrEqualTo(from, to);

        if(from !=null&& to !=null){
            this.from(from).to(to);
        }
        if(from ==null&& to ==null){
            this.rangeQueryBuilder = null;
        }

        return this;

    }

    private void greaterThanOrEqualTo(String from, String to) {
        if(from !=null&& to ==null){
            String greaterThanOrEqualTo = checkEmptyThenNull(from);

            if(greaterThanOrEqualTo!=null){
                this.rangeQueryBuilder.gte(greaterThanOrEqualTo);
            }
            if(greaterThanOrEqualTo==null){
                this.rangeQueryBuilder = null;
            }
        }
    }

    private void lessThanOrEqualTo(String from, String to) {
        if(from ==null&& to !=null){
            String lessThanOrEqualTo = checkEmptyThenNull(to);

            if(lessThanOrEqualTo!=null){
                this.rangeQueryBuilder.lte(lessThanOrEqualTo);
            }
            if(lessThanOrEqualTo==null){
                this.rangeQueryBuilder = null;
            }
        }
    }

    public String checkEmptyThenNull(String str) {
        if (str != null && str.isEmpty()) {
            return null;
        }
        return str;
    }

    @Override
    public AbstractQueryBuilder<RangeQueryBuilder> abstractQueryBuilder() {
        return rangeQueryBuilder;
    }
}
