/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.schedule.controller;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.schedule.service.ScheduleService;
import com.arms.api.util.external_communicate.dto.SearchDTO;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ScheduleController {
    private final ScheduleService scheduleService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/auth-sche/schedule/server_info_backup"})
    public void serverInfoBackup() {
        this.logger.info("[ ScheduleController :: serverInfoBackup ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.serverInfoBackup();
    }

    @GetMapping(value={"/auth-sche/schedule/increment/sequentially_issue_es_store/withDateRange"})
    public void executeIncrementalIssueSequentialSchedulesWithDateRange(@RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) {
        this.logger.info("[ ScheduleController :: executeIncrementalIssueSequentialSchedulesWithDateRange ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.executeIncrementalIssueWithDateRangeSequentialSchedules(startDate, endDate);
    }

    @GetMapping(value={"/auth-sche/schedule/sequentially_issue_es_store"})
    public void sequentiallyIssueEsStore() {
        this.logger.info("[ ScheduleController :: sequentially_issue_es_store");
        this.scheduleService.executeSequentialSchedules();
    }

    @GetMapping(value={"/auth-sche/schedule/issue_es_load"})
    public void issueEsLoad() {
        this.logger.info("[ ScheduleController :: issueEsLoad ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.updateReqStatusFromElasticsearch();
    }

    @GetMapping(value={"/auth-sche/schedule/retry-failed-req-status-creation-to-elasticsearch"})
    public void retryFailedReqStatusCreationToElasticsearch() {
        this.logger.info("[ ScheduleController :: retryFailedReqStatusCreationToElasticsearch ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.retryFailedReqStatusCreationToElasticsearch();
    }

    @GetMapping(value={"/auth-sche/schedule/cache-status-mapping-data"})
    public void cacheStatusMappingData() {
        this.logger.info("[ ScheduleController :: cacheStatusMappingData ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.cacheStatusMappingData();
    }

    @GetMapping(value={"/auth-sche/schedule/update-arms-state-category"})
    public void updateArmsStateCategory() {
        this.logger.info("[ ScheduleController :: updateArmsStateCategory ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.updateArmsStateCategory();
    }

    @GetMapping(value={"/auth-sche/schedule/cloud-jira-test-api-request"})
    public void cloudJiraTestApiRequest() {
        this.logger.info("[ ScheduleController :: cloudJiraTestApiRequest ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.cloudJiraTestApiRequest();
    }

    @PostMapping(value={"/auth-sche/schedule/es-index/alm-issue/merge"})
    public void almIssueMergeWithReindex() {
        this.logger.info("[ ScheduleController :: almIssueMergeWithReindex ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.almIssueMergeWithReindex();
    }

    @PostMapping(value={"/auth-sche/schedule/es-index/fluentd/merge"})
    public void fluentdMergeWithReindex() {
        this.logger.info("[ ScheduleController :: fluentdMergeWithReindex ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.fluentdMergeWithReindex();
    }

    @PostMapping(value={"/auth-sche/schedule/es-index/alm-issue/merge/day/{day}"})
    public void almIssueMergeWithReindex(@PathVariable(value="day") int day) {
        this.logger.info("[ ScheduleController :: almIssueMergeWithReindex-day ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.almIssueMergeWithReindex(day);
    }

    @PostMapping(value={"/auth-sche/schedule/es-index/fluentd/merge/day/{day}"})
    public void fluentdMergeWithReindex(@PathVariable(value="day") int day) {
        this.logger.info("[ ScheduleController :: fluentdMergeWithReindex-day ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        this.scheduleService.fluentdMergeWithReindex(day);
    }

    @GetMapping(value={"/getScheduleList"})
    public ResponseEntity<?> getScheduleList() throws Exception {
        this.logger.info("[ ScheduleController :: getScheduleList ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.scheduleService.getScheduleList());
    }

    @GetMapping(value={"/auth-sche/getCurrentScheduleList"})
    public ResponseEntity<?> getCurrentScheduleList() {
        this.logger.info("[ ScheduleController :: getCurrentScheduleList ] \ub3d9\uc791 : {}", (Object)Calendar.getInstance().getTime());
        return ResponseEntity.ok((Object)this.scheduleService.getCurrentScheduleList());
    }

    @PostMapping(value={"/auth-sche/saveScheduleList"})
    public ResponseEntity<?> saveScheduleList(@RequestParam String fileName, @RequestBody List<ScheduleInfoDTO> scheduleList) throws Exception {
        this.logger.info("[ ScheduleController :: saveScheduleList ] :: fileName => {}, scheduleList.size => {}", (Object)fileName, (Object)Optional.ofNullable(scheduleList.size()).orElse(0));
        return ResponseEntity.ok((Object)this.scheduleService.saveScheduleList(fileName, scheduleList));
    }

    @PostMapping(value={"/auth-sche/getScheduleHistory"})
    public ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO searchDTO) {
        this.logger.info("[ ScheduleController :: getScheduleHistory ] :: searchDTO.searchString => {}", (Object)searchDTO.getSearchString());
        return ResponseEntity.ok((Object)this.scheduleService.getScheduleHistory(searchDTO));
    }

    public ScheduleController(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }
}

