/*
 * Decompiled with CFR 0.152.
 */
package com.arms.egovframework.javaservice.scmframework.controller;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class ScmController {
    private static final Logger log = LoggerFactory.getLogger(ScmController.class);

    @GetMapping(value={"/gitInitTest"})
    public ModelAndView gitInitTest(HttpServletRequest request) throws Exception {
        log.info("ScmController :: getNode");
        File gitDir = new File("./git_init_test");
        if (gitDir.exists()) {
            FileUtils.deleteDirectory((File)gitDir);
        }
        if (gitDir.mkdirs()) {
            log.info("dir create success");
        }
        Git git = Git.init().setDirectory(gitDir).call();
        git.close();
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)git.log());
        return modelAndView;
    }

    @GetMapping(value={"/gitHubCloneTest"})
    public ModelAndView gitHubCloneTest(HttpServletRequest request) throws Exception {
        File gitDir = new File("./git_hub_clone_test");
        if (gitDir.exists()) {
            FileUtils.deleteDirectory((File)gitDir);
        }
        if (gitDir.mkdirs()) {
            log.info("dir create success");
        }
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("313cokr@gmail.com", "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");
        Git git = ((CloneCommand)Git.cloneRepository().setURI("https://github.com/313DEVGRP/Java-Service-Tree-Framework-Auto-Code.git").setCredentialsProvider((CredentialsProvider)credentialsProvider)).setDirectory(gitDir).call();
        git.close();
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)git.log());
        return modelAndView;
    }

    @GetMapping(value={"/gitAddTest"})
    public ModelAndView gitAddTest(HttpServletRequest request) throws IOException {
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);
        String fileName = UUID.randomUUID().toString();
        File file = new File(dirPath + "/" + fileName + ".txt");
        FileUtils.writeStringToFile((File)file, (String)"testing it...", (String)String.valueOf(StandardCharsets.UTF_8));
        String result = null;
        try (Git git = Git.open((File)gitDir);){
            AddCommand add = git.add();
            add.addFilepattern(fileName + ".txt").call();
            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @GetMapping(value={"/gitCommitTest"})
    public ModelAndView gitCommitTest(HttpServletRequest request) throws IOException {
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);
        String result = null;
        try (Git git = Git.open((File)gitDir);){
            git.commit().setMessage("JGIT commit test").call();
            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @GetMapping(value={"/gitPushTest"})
    public ModelAndView gitPushTest(HttpServletRequest request) throws IOException {
        String dirPath = "./git_hub_clone_test";
        File gitDir = new File(dirPath);
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("313cokr@gmail.com", "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");
        String result = null;
        try (Git git = Git.open((File)gitDir);){
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setRemote("https://github.com/313DEVGRP/Java-Service-Tree-Framework-Auto-Code.git").setRefSpecs(new RefSpec[]{new RefSpec("dev")}).call();
            result = git.log();
        }
        catch (GitAPIException e) {
            log.error(e.getMessage());
            result = e.getMessage();
        }
        ModelAndView modelAndView = new ModelAndView("jsonView");
        modelAndView.addObject("result", (Object)result);
        return modelAndView;
    }

    @GetMapping(value={"/gitBranchMergeTest"})
    public ResponseEntity<String> gitBranchMergeTest(HttpServletRequest request) throws GitAPIException, IOException {
        ResponseEntity responseEntity;
        block10: {
            String dirPath = "./git_hub_clone_test";
            File gitDir = new File(dirPath);
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider("313cokr@gmail.com", "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");
            String branchName = "dev";
            Git git = Git.open((File)gitDir);
            try {
                List branchList = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
                boolean branchExists = branchList.stream().anyMatch(ref -> ref.getName().endsWith("heads/" + branchName));
                if (!branchExists) {
                    git.branchCreate().setName(branchName).call();
                }
                git.checkout().setName(branchName).call();
                ObjectId mergeBase = git.getRepository().resolve("live");
                MergeResult merge = git.merge().include((AnyObjectId)mergeBase).setCommit(true).setFastForward(MergeCommand.FastForwardMode.NO_FF).setMessage("Merged changes").call();
                if (merge.getMergeStatus().isSuccessful()) {
                    ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setRemote("stg").setRefSpecs(new RefSpec[]{new RefSpec(branchName)}).call();
                }
                responseEntity = ResponseEntity.ok((Object)"Branch merge and push completed successfully.");
                if (git == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GitAPIException e) {
                    log.error("Error during branch merge operation: ", e);
                    return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error during branch merge operation");
                }
            }
            git.close();
        }
        return responseEntity;
    }
}

