package com.arms.api.schedule.controller;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.schedule.service.ScheduleService;
import com.arms.api.util.external_communicate.dto.SearchDTO;
import lombok.AllArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Calendar;
import java.util.List;
import java.util.Optional;

@RestController
@AllArgsConstructor
public class ScheduleController {

    private final ScheduleService scheduleService;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value = "/auth-sche/schedule/server_info_backup")
    public void serverInfoBackup(){
        logger.info("[ ScheduleController :: serverInfoBackup ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.serverInfoBackup();
    }

    @GetMapping(value = "/auth-sche/schedule/increment/sequentially_issue_es_store/withDateRange")
    public void executeIncrementalIssueSequentialSchedulesWithDateRange(@RequestParam("startDate") String startDate,@RequestParam("endDate") String endDate) {
        logger.info("[ ScheduleController :: executeIncrementalIssueSequentialSchedulesWithDateRange ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.executeIncrementalIssueWithDateRangeSequentialSchedules(startDate,endDate);
    }

    @GetMapping(value = "/auth-sche/schedule/sequentially_issue_es_store")
    public void sequentiallyIssueEsStore() {
        logger.info("[ ScheduleController :: sequentially_issue_es_store");
        scheduleService.executeSequentialSchedules();
    }

    @GetMapping(value = "/auth-sche/schedule/issue_es_load")
    public void issueEsLoad() {
        logger.info("[ ScheduleController :: issueEsLoad ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.updateReqStatusFromElasticsearch();
    }

    @GetMapping(value = "/auth-sche/schedule/retry-failed-req-status-creation-to-elasticsearch")
    public void retryFailedReqStatusCreationToElasticsearch() {
        logger.info("[ ScheduleController :: retryFailedReqStatusCreationToElasticsearch ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.retryFailedReqStatusCreationToElasticsearch();
    }

    @GetMapping(value = "/auth-sche/schedule/cache-status-mapping-data")
    public void cacheStatusMappingData() {
        logger.info("[ ScheduleController :: cacheStatusMappingData ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.cacheStatusMappingData();
    }

    @GetMapping(value = "/auth-sche/schedule/update-arms-state-category")
    public void updateArmsStateCategory() {
        logger.info("[ ScheduleController :: updateArmsStateCategory ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.updateArmsStateCategory();
    }

    @GetMapping(value = "/auth-sche/schedule/cloud-jira-test-api-request")
    public void cloudJiraTestApiRequest() {
        logger.info("[ ScheduleController :: cloudJiraTestApiRequest ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.cloudJiraTestApiRequest();
    }


    @PostMapping(value = "/auth-sche/schedule/es-index/alm-issue/merge")
    public void almIssueMergeWithReindex() {
        logger.info("[ ScheduleController :: almIssueMergeWithReindex ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.almIssueMergeWithReindex();
    }

    @PostMapping(value = "/auth-sche/schedule/es-index/fluentd/merge")
    public void fluentdMergeWithReindex() {
        logger.info("[ ScheduleController :: fluentdMergeWithReindex ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.fluentdMergeWithReindex();
    }

    @PostMapping(value = "/auth-sche/schedule/es-index/alm-issue/merge/day/{day}")
    public void almIssueMergeWithReindex(@PathVariable("day")int day) {
        logger.info("[ ScheduleController :: almIssueMergeWithReindex-day ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.almIssueMergeWithReindex(day);
    }

    @PostMapping(value = "/auth-sche/schedule/es-index/fluentd/merge/day/{day}")
    public void fluentdMergeWithReindex(@PathVariable("day") int day) {
        logger.info("[ ScheduleController :: fluentdMergeWithReindex-day ] 동작 : {}", Calendar.getInstance().getTime());
        scheduleService.fluentdMergeWithReindex(day);
    }

    @GetMapping("/getScheduleList")
    public ResponseEntity<?> getScheduleList() throws Exception {
        logger.info("[ ScheduleController :: getScheduleList ] 동작 : {}", Calendar.getInstance().getTime());
        return ResponseEntity.ok(scheduleService.getScheduleList());
    }

    @GetMapping("/auth-sche/getCurrentScheduleList")
    public ResponseEntity<?> getCurrentScheduleList() {
        logger.info("[ ScheduleController :: getCurrentScheduleList ] 동작 : {}", Calendar.getInstance().getTime());
        return ResponseEntity.ok(scheduleService.getCurrentScheduleList());
    }

    @PostMapping("/auth-sche/saveScheduleList")
    public ResponseEntity<?> saveScheduleList(@RequestParam String fileName, @RequestBody List<ScheduleInfoDTO> scheduleList) throws Exception {
        logger.info("[ ScheduleController :: saveScheduleList ] :: fileName => {}, scheduleList.size => {}",
                fileName, Optional.ofNullable(scheduleList.size()).orElse(0));

        return ResponseEntity.ok(scheduleService.saveScheduleList(fileName, scheduleList));
    }

    @PostMapping("/auth-sche/getScheduleHistory")
    public ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO searchDTO) {

        logger.info("[ ScheduleController :: getScheduleHistory ] :: searchDTO.searchString => {}",
                searchDTO.getSearchString());

        return ResponseEntity.ok(scheduleService.getScheduleHistory(searchDTO));
    }


}
