package com.arms.api.mapping.service;

import com.arms.api.mapping.domain.AlmIssueStatus;
import com.arms.api.mapping.repository.AlmIssueStatusRepository;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class AlmIssueStatusService {

    private final AlmIssueStatusRepository almIssueStatusRepository;

    public void initAlmIssueStatus(List<AlmIssueStatus> almIssueStatusList) { almIssueStatusRepository.saveAll(almIssueStatusList); }

    public void deleteAlmIssueStatus(String pattern) { almIssueStatusRepository.deleteByPattern(pattern); }

    public AlmIssueStatus getAlmIssueStatus(String almId) {
        return almIssueStatusRepository.findById(almId).orElseGet(()->AlmIssueStatus.builder().build());
    }

}