////////////////////////////////////////////////////////////////////////////////////////
//Document Ready
////////////////////////////////////////////////////////////////////////////////////////
function execDocReady() {
	var pluginGroups = [
		[
			"../reference/lightblue4/docs/lib/widgster/widgster.js",
			"../reference/lightblue4/docs/lib/slimScroll/jquery.slimscroll.min.js",
			"../reference/light-blue/lib/vendor/jquery.ui.widget.js"
		],

		[
			"../reference/jquery-plugins/select2-4.0.2/dist/css/select2_lightblue4.css",
			"../reference/jquery-plugins/select2-4.0.2/dist/js/select2.min.js"
		],

		[
			"../reference/jquery-plugins/dataTables-1.10.16/media/css/jquery.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/css/responsive.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/css/select.dataTables_lightblue4.css",
			"../reference/jquery-plugins/dataTables-1.10.16/media/js/jquery.dataTables.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Responsive/js/dataTables.responsive.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Select/js/dataTables.select.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/RowGroup/js/dataTables.rowsGroup.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/dataTables.buttons.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.html5.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/buttons.print.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/jszip.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/pdfmake.min.js",
			"../reference/jquery-plugins/dataTables-1.10.16/extensions/Buttons/js/vfs_fonts.js"
		],

		["../arms/js/common/table_new.js"]
		// 추가적인 플러그인 그룹들을 이곳에 추가하면 됩니다.
	];

	loadPluginGroupsParallelAndSequential(pluginGroups)
		.then(function () {
			console.log("모든 플러그인 로드 완료");

			// 사이드 메뉴 색상 설정
			$(".widget").widgster();
			setSideMenu("sidebar_menu_security", "sidebar_menu_security_role");

			var resetRoleForm = function () {
				$("#role_form").trigger("reset");
				$("#btn_submit").removeClass("btn-success").addClass("btn-primary").text("Role 생성");
				$("#btn_delete").addClass("hidden");
				$("#users_in_role_table").table().reDraw([]);
			};

			$("#role_table")
				.trigger($.Event("init.role_list"))
				.on("select.table", function (event, selectedData) {
					$("#btn_submit").removeClass("btn-primary").addClass("btn-success").text("Role 수정");
					$("#btn_delete").removeClass("hidden");

					$.ajax({
						url: "/auth-admin/realms/master/role/" + selectedData.name + "/users",
						success: function (data) {
							var usersInRole = data.reduce(function (users, user) {
								return users.concat(
									$.extend(user, { createdTimestamp: new Date(user.createdTimestamp).toLocaleString() })
								);
							}, []);

							$("#users_in_role_table").table().reDraw(usersInRole);
						}
					});

					var roleForm = $("#role_form");
					var roleRepresentation = new FormData(roleForm[0]);

					roleRepresentation.keys().forEach(function (key) {
						roleForm.find("[name=" + key + "]").val(selectedData[key]);
					});
				})
				.on("deselect.table", function () {
					resetRoleForm();
				});

			$("#role_form").on("submit", function (event) {
				event.preventDefault();

				var roleRepresentation = Object.fromEntries(new FormData(event.target));
				var url = "/auth-admin/realms/master/role";
				var type = "POST";

				var selectedData = $("#role_table").table().getSelectedData();

				if (selectedData) {
					url += "/" + selectedData.name;
					type = "PUT";
				}

				$.ajax({
					url: url,
					withCredentials: true,
					type: type,
					contentType: "application/json;charset=utf-8",
					data: JSON.stringify(roleRepresentation),
					success: function () {
						resetRoleForm();
						$("#role_table").table().table.ajax.reload();
					}
				});

				return false;
			});

			$("#btn_delete").on("click", function () {
				var selectedData = $("#role_table").table().getSelectedData();

				if (selectedData) {
					$.ajax({
						url: "/auth-admin/realms/master/role/" + selectedData.name,
						method: "DELETE",
						success: function () {
							resetRoleForm();
							$("#role_table").table().table.ajax.reload();
						}
					});
				}
			});

			$("#btn_cancel").on("click", function () {
				var selectedData = $("#role_table").table().getSelectedData();

				if (selectedData) {
					var roleForm = $("#role_form");
					var roleRepresentation = new FormData(roleForm[0]);
					roleRepresentation.keys().forEach(function (key) {
						roleForm.find("[name=" + key + "]").val(selectedData[key]);
					});

					return;
				}

				$("#role_form").trigger("reset");
			});

			$("#users_in_role_table").trigger($.Event("init.user_list"));
		})
		.catch(function () {
			console.error("플러그인 로드 중 오류 발생");
		});
}

+(function ($) {
	"use strict";

	var columnList = [
		{
			name: "name",
			title: "Role Name",
			data: "name",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "description",
			title: "Description",
			data: "description",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		}
	];

	$(document).on("init.role_list", function (event) {
		$(event.target).table({
			columns: columnList,
			dom: "Blfrtip",
			buttons: [
				{
					extend: "excel",
					charset: "UTF-8",
					bom: true,
					className: "btn btn-default btn-sm margin-bottom"
				}
			],
			ajax: {
				url: "/auth-admin/realms/master/roles",
				dataSrc: function (json) {
					return json;
				}
			}
		});
	});
})(jQuery);

+(function ($) {
	"use strict";

	var columnList = [
		{
			name: "firstName",
			title: "성명",
			data: "firstName",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "username",
			title: "ID",
			data: "username",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "email",
			title: "Email",
			data: "email",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		},
		{
			name: "createdTimestamp",
			title: "Created Date",
			data: "createdTimestamp",
			render: function (data) {
				return ![null, undefined, ""].includes(data)
					? "<span style='color: #a4c6ff'>" + data + "</span>"
					: "<span style='color: #aaa'>N/A</span>";
			}
		}
	];

	$(document).on("init.user_list", function (event) {
		$(event.target).table({
			data: [],
			columns: columnList,
			dom: "Blfrtip",
			buttons: [
				{
					extend: "excel",
					charset: "UTF-8",
					bom: true,
					className: "btn btn-default btn-sm margin-bottom"
				}
			]
		});
	});
})(jQuery);
