import path from 'path';
import { defineConfig, loadEnv } from 'vite';
import react from '@vitejs/plugin-react';

// https://vitejs.dev/config/
export default ({ mode }) => {
  const env = loadEnv(mode, process.cwd());

  return defineConfig({
    plugins: [react()],
    server: {
      port: 3000,
      host: '0.0.0.0',
      proxy: ['/auth-user', '/auth-manager', '/auth-admin', '/login', '/logout'].reduce(
        (proxyConfig, proxyPath) => ({
          ...proxyConfig,
          [proxyPath]: {
            target: env.VITE_MIDDLE_PROXY,
            changeOrigin: true,
          },
        }),
        {},
      ),
    },
    resolve: {
      alias: {
        '@': path.resolve(__dirname, './src'),
      },
    },
    css: {
      preprocessorOptions: {
        scss: {
          additionalData: `
          @import '@/styles/variables';
          @import '@/styles/mixins';
        `,
          quietDeps: true,
        },
      },
    },
    base: '/backoffice/dist/',
  });
};
