/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.account.strategy;

import com.arms.api.account.model.AlmAccount;
import com.arms.api.account.model.RedmineAccount;
import com.arms.api.account.strategy.AccountStrategy;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.RedmineUtil;
import com.arms.api.util.errors.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class OnPromiseRedmineAccountStrategy
implements AccountStrategy {
    private final Logger \ub85c\uadf8 = LoggerFactory.getLogger(this.getClass());
    private final ServerInfoService serverInfoService;
    private final RedmineUtil redmineUtil;

    @Autowired
    public OnPromiseRedmineAccountStrategy(ServerInfoService ServerInfoService2, RedmineUtil RedmineUtil2) {
        this.serverInfoService = ServerInfoService2;
        this.redmineUtil = RedmineUtil2;
    }

    public AlmAccount verifyAccount(ServerInfo serverInfo) {
        this.\ub85c\uadf8.info("\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4_\uacc4\uc815_\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac80\uc99d");
        return this.\uacc4\uc815\uc815\ubcf4_\uc870\ud68c(serverInfo);
    }

    public AlmAccount getAccount(String connectId) {
        this.\ub85c\uadf8.info("\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4_\uacc4\uc815_\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uac00\uc838\uc624\uae30");
        ServerInfo serverInfo = this.serverInfoService.verifyServerInfo(connectId);
        return this.\uacc4\uc815\uc815\ubcf4_\uc870\ud68c(serverInfo);
    }

    private AlmAccount \uacc4\uc815\uc815\ubcf4_\uc870\ud68c(ServerInfo serverInfo) {
        try {
            String uri = serverInfo.getUri();
            String serverType = serverInfo.getType();
            String apiToken = this.serverInfoService.getDecryptPasswordOrToken(serverInfo);
            String userId = serverInfo.getUserId();
            this.\ub85c\uadf8.info("\ub808\ub4dc\ub9c8\uc778_\uc628\ud504\ub808\ubbf8\uc2a4_\uacc4\uc815_\uc804\ub7b5 :: \uacc4\uc815\uc815\ubcf4_\uc870\ud68c, \uc11c\ubc84 \uc8fc\uc18c: {}, \uc11c\ubc84 \ud0c0\uc785: {}, apiToken: {}, \uc720\uc800 \uc544\uc774\ub514: {}", new Object[]{uri, serverType, apiToken, userId});
            String endpoint = "/my/account.json";
            WebClient webClient = RedmineUtil.createRedmineWebClientCommunicator((String)uri, (String)this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
            RedmineAccount \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc = (RedmineAccount)this.redmineUtil.get(webClient, endpoint, RedmineAccount.class).block();
            if (\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc == null) {
                this.\ub85c\uadf8.error("\uc628\ud504\ub77c\ubbf8\uc2a4 \ub808\ub4dc\ub9c8\uc778 \uacc4\uc815 \uc870\ud68c \uacb0\uacfc\uac00 Null\uc785\ub2c8\ub2e4.");
                throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
            }
            return this.\uacc4\uc815\uc815\ubcf4_\ub370\uc774\ud130_\ubcc0\ud658(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc, uri);
        }
        catch (Exception e) {
            this.\ub85c\uadf8.error("\uc628\ud504\ub77c\ubbf8\uc2a4 \ub808\ub4dc\ub9c8\uc778 \uacc4\uc815 \uc815\ubcf4 \uc870\ud68c\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage());
            throw new IllegalArgumentException(ErrorCode.ACCOUNT_INFO_RETRIEVAL_ERROR.getErrorMsg(new Object[0]));
        }
    }

    private AlmAccount \uacc4\uc815\uc815\ubcf4_\ub370\uc774\ud130_\ubcc0\ud658(RedmineAccount \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc, String uri) {
        AlmAccount AlmAccount2 = new AlmAccount();
        String self = uri + "users/" + \uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getId() + ".json";
        AlmAccount2.setSelf(self);
        AlmAccount2.setName(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getLogin());
        AlmAccount2.setDisplayName(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getLastname());
        AlmAccount2.setEmailAddress(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getMail());
        AlmAccount2.setAdmin(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getAdmin());
        AlmAccount2.setApiKey(\uacc4\uc815\uc815\ubcf4_\uc870\ud68c\uacb0\uacfc.getUser().getApiKey());
        return AlmAccount2;
    }
}

