/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.clientcase.service;

import com.arms.api.clientcase.model.ClientCaseContentsDTO;
import com.arms.api.clientcase.model.ClientCaseEntity;
import com.arms.api.clientcase.service.ClientCaseService;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ClientCaseServiceImpl
implements ClientCaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCaseServiceImpl.class);
    private final EsCommonRepositoryWrapper<ClientCaseEntity> esCommonRepositoryWrapper;

    @Transactional
    public String addClientCase(ClientCaseContentsDTO clientCaseContentsDTO) {
        ClientCaseEntity clientCaseEntity = clientCaseContentsDTO.createClientCaseEntity();
        ClientCaseEntity savedEntity = (ClientCaseEntity)this.esCommonRepositoryWrapper.save((BaseEntity)clientCaseEntity);
        log.info("ClientCase Contents \uc800\uc7a5 \uc644\ub8cc - c_id: {}", (Object)savedEntity.getC_id());
        return savedEntity.getC_id();
    }

    @Transactional
    public String updateClientCase(ClientCaseContentsDTO clientCaseContentsDTO) {
        ClientCaseEntity existingEntity = (ClientCaseEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)clientCaseContentsDTO.getC_id()));
        if (existingEntity == null) {
            log.error("ClientCase Contents \uc5c5\ub370\uc774\ud2b8 \uc2e4\ud328 - ES\uc5d0 \ub370\uc774\ud130 \uc5c6\uc74c - c_id: {}", (Object)clientCaseContentsDTO.getC_id());
            throw new IllegalStateException("ES\uc5d0 ClientCase Contents\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4 - c_id: " + clientCaseContentsDTO.getC_id());
        }
        existingEntity.setC_clientcase_contents(clientCaseContentsDTO.getC_clientcase_contents());
        existingEntity.setC_clientcase_thumbnail_image(clientCaseContentsDTO.getC_clientcase_thumbnail_image());
        this.esCommonRepositoryWrapper.save((BaseEntity)existingEntity);
        log.info("ClientCase Contents \uc5c5\ub370\uc774\ud2b8 \uc644\ub8cc - c_id: {}", (Object)existingEntity.getC_id());
        return clientCaseContentsDTO.getC_id();
    }

    @Transactional(readOnly=true)
    public ClientCaseContentsDTO getClientCase(String clientCaseId) {
        ClientCaseEntity entity = (ClientCaseEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)clientCaseId));
        if (entity == null) {
            log.error("ClientCase Contents \uc870\ud68c \uc2e4\ud328 - ES\uc5d0 \ub370\uc774\ud130 \uc5c6\uc74c - c_id: {}", (Object)clientCaseId);
            throw new IllegalStateException("ES\uc5d0 ClientCase Contents\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4 - c_id: " + clientCaseId);
        }
        ClientCaseContentsDTO dto = new ClientCaseContentsDTO();
        dto.setC_id(entity.getC_id());
        dto.setC_clientcase_contents(entity.getC_clientcase_contents());
        dto.setC_clientcase_thumbnail_image(entity.getC_clientcase_thumbnail_image());
        log.info("ClientCase Contents \uc870\ud68c \uc644\ub8cc - c_id: {}", (Object)clientCaseId);
        return dto;
    }

    @Transactional
    public String deleteClientCase(String clientCaseId) {
        ClientCaseEntity existingEntity = (ClientCaseEntity)this.esCommonRepositoryWrapper.findDocById((Serializable)((Object)clientCaseId));
        if (existingEntity == null) {
            log.error("ClientCase Contents \uc0ad\uc81c \uc2e4\ud328 - ES\uc5d0 \ub370\uc774\ud130 \uc5c6\uc74c - c_id: {}", (Object)clientCaseId);
            throw new IllegalStateException("ES\uc5d0 ClientCase Contents\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4 - c_id: " + clientCaseId);
        }
        this.esCommonRepositoryWrapper.deleteById((Serializable)((Object)clientCaseId));
        log.info("ClientCase Contents \uc0ad\uc81c \uc644\ub8cc - c_id: {}", (Object)clientCaseId);
        return clientCaseId;
    }

    @Generated
    public ClientCaseServiceImpl(EsCommonRepositoryWrapper<ClientCaseEntity> esCommonRepositoryWrapper) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
    }
}

