/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.model.entity;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchIndex;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchTemplateConfig;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.annotation.Recent;
import com.arms.egovframework.javaservice.esframework.annotation.RecentId;
import com.arms.egovframework.javaservice.esframework.annotation.RollingIndexName;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="#{@jiraissue}", createIndex=false)
@ElasticSearchTemplateConfig
@ElasticSearchIndex
public class AlmIssueEntity
implements BaseEntity {
    @Id
    @ReadOnlyProperty
    private String id;
    @RecentId
    @JsonProperty(value="recent_id")
    @Field(type=FieldType.Keyword, name="recent_id")
    private String recentId;
    @Recent
    @Field(type=FieldType.Boolean, name="recent")
    private boolean recent;
    @Field(type=FieldType.Boolean, name="isReq")
    private Boolean isReq;
    @Field(type=FieldType.Long, name="cReqLink")
    private Long cReqLink;
    @Field(type=FieldType.Long, name="cReqStatusId")
    private Long cReqStatusId;
    @Field(type=FieldType.Long, name="pdServiceId")
    private Long pdServiceId;
    @Field(type=FieldType.Long, name="pdServiceVersions")
    private List<Long> pdServiceVersions;
    @Field(type=FieldType.Long, name="linkedIssuePdServiceIds")
    private List<Long> linkedIssuePdServiceIds;
    @Field(type=FieldType.Long, name="linkedIssuePdServiceVersions")
    private List<Long> linkedIssuePdServiceVersions;
    @Field(type=FieldType.Keyword, name="linkedIssues")
    private List<String> linkedIssues;
    @Field(type=FieldType.Keyword, name="jira_server_id")
    private String jira_server_id;
    @Field(type=FieldType.Keyword, name="key")
    private String key;
    @Field(type=FieldType.Keyword, name="parentReqKey")
    private String parentReqKey;
    @Field(type=FieldType.Keyword, name="upperKey")
    private String upperKey;
    @Field(type=FieldType.Auto, name="issueID")
    private String issueID;
    @Field(type=FieldType.Text, name="self")
    private String self;
    @Field(type=FieldType.Date, name="@timestamp")
    @JsonProperty(value="@timestamp")
    @ElasticSearchUpdateDate
    private Date timestamp;
    @Field(type=FieldType.Auto, name="etc")
    private Object etc;
    @Field(type=FieldType.Percolator, name="queries")
    @JsonProperty(value="queries")
    private List<String> percolatorQueries;
    private Project project;
    private IssueType issuetype;
    private Creator creator;
    private Reporter reporter;
    private Assignee assignee;
    @Field(type=FieldType.Text)
    private List<String> labels;
    private Priority priority;
    private \uc0c1\ud0dc status;
    @Field(type=FieldType.Keyword, name="armsStateCategory")
    @JsonProperty(value="armsStateCategory")
    private String armsStateCategory;
    private Resolution resolution;
    @Field(type=FieldType.Text, name="resolutiondate")
    private String resolutiondate;
    @Field(type=FieldType.Date, name="created")
    private Date created;
    @Field(type=FieldType.Date, name="updated")
    private Date updated;
    @Field(type=FieldType.Date, name="overallUpdatedDate")
    private Date overallUpdatedDate;
    private Deleted deleted;
    private List<Worklogs> worklogs;
    @Field(type=FieldType.Integer, name="timespent")
    private Integer timespent;
    @Field(type=FieldType.Text, name="summary")
    private String summary;
    private CReqProperty cReqProperty;
    @JsonIgnore
    @Field(type=FieldType.Text, name="rawData")
    private String rawData;

    public AlmIssueEntity() {
    }

    public void generateId() {
        this.recentId = this.jira_server_id + "_" + this.project.key + "_" + this.key;
    }

    public boolean izEmpty() {
        return this.recentId == null || this.recentId.isEmpty();
    }

    public boolean izNotEmpty() {
        return !this.izEmpty();
    }

    public String recentId() {
        return this.recentId;
    }

    public String recentIdByNewKey(String newKey) {
        return this.jira_server_id + "_" + this.project.key + "_" + newKey;
    }

    private void modifyKey(String projectKey, String newKey) {
        this.key = newKey;
        this.project.key = projectKey;
        this.recentId = this.recentIdByNewKey(newKey);
    }

    public void modifyProjectKeyAndKey(String projectKey, String newKey) {
        this.modifyKey(projectKey, newKey);
    }

    public boolean isNeedOverallUpdatedDate(AlmIssueEntity targetAlmIssueEntity) {
        if (targetAlmIssueEntity.getUpdated() == null) {
            return false;
        }
        return this.overallUpdatedDate.after(targetAlmIssueEntity.getUpdated());
    }

    public boolean izReqTrue() {
        return this.isReq != null && this.isReq != false;
    }

    public boolean izReqFalse() {
        return !this.izReqTrue();
    }

    public String stringValueOfCreatedDate() {
        if (this.created != null) {
            ZonedDateTime zdt = this.created.toInstant().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return zdt.format(formatter);
        }
        return null;
    }

    public String stringValueOfUpdatedDate() {
        if (this.updated != null) {
            ZonedDateTime zdt = this.updated.toInstant().atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            return zdt.format(formatter);
        }
        return null;
    }

    @RollingIndexName
    public String localDate() {
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return now.format(formatter);
    }

    @Generated
    public static AlmIssueEntityBuilder builder() {
        return new AlmIssueEntityBuilder();
    }

    @Generated
    public AlmIssueEntityBuilder toBuilder() {
        return new AlmIssueEntityBuilder().id(this.id).recentId(this.recentId).recent(this.recent).isReq(this.isReq).cReqLink(this.cReqLink).cReqStatusId(this.cReqStatusId).pdServiceId(this.pdServiceId).pdServiceVersions(this.pdServiceVersions).linkedIssuePdServiceIds(this.linkedIssuePdServiceIds).linkedIssuePdServiceVersions(this.linkedIssuePdServiceVersions).linkedIssues(this.linkedIssues).jira_server_id(this.jira_server_id).key(this.key).parentReqKey(this.parentReqKey).upperKey(this.upperKey).issueID(this.issueID).self(this.self).timestamp(this.timestamp).etc(this.etc).percolatorQueries(this.percolatorQueries).project(this.project).issuetype(this.issuetype).creator(this.creator).reporter(this.reporter).assignee(this.assignee).labels(this.labels).priority(this.priority).status(this.status).armsStateCategory(this.armsStateCategory).resolution(this.resolution).resolutiondate(this.resolutiondate).created(this.created).updated(this.updated).overallUpdatedDate(this.overallUpdatedDate).deleted(this.deleted).worklogs(this.worklogs).timespent(this.timespent).summary(this.summary).cReqProperty(this.cReqProperty).rawData(this.rawData);
    }

    @Generated
    public AlmIssueEntity(String id, String recentId, boolean recent, Boolean isReq, Long cReqLink, Long cReqStatusId, Long pdServiceId, List<Long> pdServiceVersions, List<Long> linkedIssuePdServiceIds, List<Long> linkedIssuePdServiceVersions, List<String> linkedIssues, String jira_server_id, String key, String parentReqKey, String upperKey, String issueID, String self, Date timestamp, Object etc, List<String> percolatorQueries, Project project, IssueType issuetype, Creator creator, Reporter reporter, Assignee assignee, List<String> labels, Priority priority, \uc0c1\ud0dc status, String armsStateCategory, Resolution resolution, String resolutiondate, Date created, Date updated, Date overallUpdatedDate, Deleted deleted, List<Worklogs> worklogs, Integer timespent, String summary, CReqProperty cReqProperty, String rawData) {
        this.id = id;
        this.recentId = recentId;
        this.recent = recent;
        this.isReq = isReq;
        this.cReqLink = cReqLink;
        this.cReqStatusId = cReqStatusId;
        this.pdServiceId = pdServiceId;
        this.pdServiceVersions = pdServiceVersions;
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
        this.linkedIssues = linkedIssues;
        this.jira_server_id = jira_server_id;
        this.key = key;
        this.parentReqKey = parentReqKey;
        this.upperKey = upperKey;
        this.issueID = issueID;
        this.self = self;
        this.timestamp = timestamp;
        this.etc = etc;
        this.percolatorQueries = percolatorQueries;
        this.project = project;
        this.issuetype = issuetype;
        this.creator = creator;
        this.reporter = reporter;
        this.assignee = assignee;
        this.labels = labels;
        this.priority = priority;
        this.status = status;
        this.armsStateCategory = armsStateCategory;
        this.resolution = resolution;
        this.resolutiondate = resolutiondate;
        this.created = created;
        this.updated = updated;
        this.overallUpdatedDate = overallUpdatedDate;
        this.deleted = deleted;
        this.worklogs = worklogs;
        this.timespent = timespent;
        this.summary = summary;
        this.cReqProperty = cReqProperty;
        this.rawData = rawData;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setRecentId(String recentId) {
        this.recentId = recentId;
    }

    @Generated
    public void setRecent(boolean recent) {
        this.recent = recent;
    }

    @Generated
    public void setIsReq(Boolean isReq) {
        this.isReq = isReq;
    }

    @Generated
    public void setCReqLink(Long cReqLink) {
        this.cReqLink = cReqLink;
    }

    @Generated
    public void setCReqStatusId(Long cReqStatusId) {
        this.cReqStatusId = cReqStatusId;
    }

    @Generated
    public void setPdServiceId(Long pdServiceId) {
        this.pdServiceId = pdServiceId;
    }

    @Generated
    public void setPdServiceVersions(List<Long> pdServiceVersions) {
        this.pdServiceVersions = pdServiceVersions;
    }

    @Generated
    public void setLinkedIssuePdServiceIds(List<Long> linkedIssuePdServiceIds) {
        this.linkedIssuePdServiceIds = linkedIssuePdServiceIds;
    }

    @Generated
    public void setLinkedIssuePdServiceVersions(List<Long> linkedIssuePdServiceVersions) {
        this.linkedIssuePdServiceVersions = linkedIssuePdServiceVersions;
    }

    @Generated
    public void setLinkedIssues(List<String> linkedIssues) {
        this.linkedIssues = linkedIssues;
    }

    @Generated
    public void setJira_server_id(String jira_server_id) {
        this.jira_server_id = jira_server_id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setParentReqKey(String parentReqKey) {
        this.parentReqKey = parentReqKey;
    }

    @Generated
    public void setUpperKey(String upperKey) {
        this.upperKey = upperKey;
    }

    @Generated
    public void setIssueID(String issueID) {
        this.issueID = issueID;
    }

    @Generated
    public void setSelf(String self) {
        this.self = self;
    }

    @Generated
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setEtc(Object etc) {
        this.etc = etc;
    }

    @Generated
    public void setPercolatorQueries(List<String> percolatorQueries) {
        this.percolatorQueries = percolatorQueries;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }

    @Generated
    public void setIssuetype(IssueType issuetype) {
        this.issuetype = issuetype;
    }

    @Generated
    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @Generated
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Generated
    public void setAssignee(Assignee assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Generated
    public void setStatus(\uc0c1\ud0dc status) {
        this.status = status;
    }

    @Generated
    public void setArmsStateCategory(String armsStateCategory) {
        this.armsStateCategory = armsStateCategory;
    }

    @Generated
    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    @Generated
    public void setResolutiondate(String resolutiondate) {
        this.resolutiondate = resolutiondate;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Generated
    public void setOverallUpdatedDate(Date overallUpdatedDate) {
        this.overallUpdatedDate = overallUpdatedDate;
    }

    @Generated
    public void setDeleted(Deleted deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setWorklogs(List<Worklogs> worklogs) {
        this.worklogs = worklogs;
    }

    @Generated
    public void setTimespent(Integer timespent) {
        this.timespent = timespent;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setCReqProperty(CReqProperty cReqProperty) {
        this.cReqProperty = cReqProperty;
    }

    @Generated
    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getRecentId() {
        return this.recentId;
    }

    @Generated
    public boolean isRecent() {
        return this.recent;
    }

    @Generated
    public Boolean getIsReq() {
        return this.isReq;
    }

    @Generated
    public Long getCReqLink() {
        return this.cReqLink;
    }

    @Generated
    public Long getCReqStatusId() {
        return this.cReqStatusId;
    }

    @Generated
    public Long getPdServiceId() {
        return this.pdServiceId;
    }

    @Generated
    public List<Long> getPdServiceVersions() {
        return this.pdServiceVersions;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceIds() {
        return this.linkedIssuePdServiceIds;
    }

    @Generated
    public List<Long> getLinkedIssuePdServiceVersions() {
        return this.linkedIssuePdServiceVersions;
    }

    @Generated
    public List<String> getLinkedIssues() {
        return this.linkedIssues;
    }

    @Generated
    public String getJira_server_id() {
        return this.jira_server_id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getParentReqKey() {
        return this.parentReqKey;
    }

    @Generated
    public String getUpperKey() {
        return this.upperKey;
    }

    @Generated
    public String getIssueID() {
        return this.issueID;
    }

    @Generated
    public String getSelf() {
        return this.self;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Object getEtc() {
        return this.etc;
    }

    @Generated
    public List<String> getPercolatorQueries() {
        return this.percolatorQueries;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public IssueType getIssuetype() {
        return this.issuetype;
    }

    @Generated
    public Creator getCreator() {
        return this.creator;
    }

    @Generated
    public Reporter getReporter() {
        return this.reporter;
    }

    @Generated
    public Assignee getAssignee() {
        return this.assignee;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Priority getPriority() {
        return this.priority;
    }

    @Generated
    public \uc0c1\ud0dc getStatus() {
        return this.status;
    }

    @Generated
    public String getArmsStateCategory() {
        return this.armsStateCategory;
    }

    @Generated
    public Resolution getResolution() {
        return this.resolution;
    }

    @Generated
    public String getResolutiondate() {
        return this.resolutiondate;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public Date getUpdated() {
        return this.updated;
    }

    @Generated
    public Date getOverallUpdatedDate() {
        return this.overallUpdatedDate;
    }

    @Generated
    public Deleted getDeleted() {
        return this.deleted;
    }

    @Generated
    public List<Worklogs> getWorklogs() {
        return this.worklogs;
    }

    @Generated
    public Integer getTimespent() {
        return this.timespent;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public CReqProperty getCReqProperty() {
        return this.cReqProperty;
    }

    @Generated
    public String getRawData() {
        return this.rawData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlmIssueEntity)) {
            return false;
        }
        AlmIssueEntity other = (AlmIssueEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isReq = this.getIsReq();
        Boolean other$isReq = other.getIsReq();
        if (this$isReq == null ? other$isReq != null : !((Object)this$isReq).equals(other$isReq)) {
            return false;
        }
        Long this$cReqLink = this.getCReqLink();
        Long other$cReqLink = other.getCReqLink();
        if (this$cReqLink == null ? other$cReqLink != null : !((Object)this$cReqLink).equals(other$cReqLink)) {
            return false;
        }
        Long this$cReqStatusId = this.getCReqStatusId();
        Long other$cReqStatusId = other.getCReqStatusId();
        if (this$cReqStatusId == null ? other$cReqStatusId != null : !((Object)this$cReqStatusId).equals(other$cReqStatusId)) {
            return false;
        }
        Long this$pdServiceId = this.getPdServiceId();
        Long other$pdServiceId = other.getPdServiceId();
        if (this$pdServiceId == null ? other$pdServiceId != null : !((Object)this$pdServiceId).equals(other$pdServiceId)) {
            return false;
        }
        Integer this$timespent = this.getTimespent();
        Integer other$timespent = other.getTimespent();
        if (this$timespent == null ? other$timespent != null : !((Object)this$timespent).equals(other$timespent)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$recentId = this.getRecentId();
        String other$recentId = other.getRecentId();
        if (this$recentId == null ? other$recentId != null : !this$recentId.equals(other$recentId)) {
            return false;
        }
        List this$pdServiceVersions = this.getPdServiceVersions();
        List other$pdServiceVersions = other.getPdServiceVersions();
        if (this$pdServiceVersions == null ? other$pdServiceVersions != null : !((Object)this$pdServiceVersions).equals(other$pdServiceVersions)) {
            return false;
        }
        List this$linkedIssuePdServiceIds = this.getLinkedIssuePdServiceIds();
        List other$linkedIssuePdServiceIds = other.getLinkedIssuePdServiceIds();
        if (this$linkedIssuePdServiceIds == null ? other$linkedIssuePdServiceIds != null : !((Object)this$linkedIssuePdServiceIds).equals(other$linkedIssuePdServiceIds)) {
            return false;
        }
        List this$linkedIssuePdServiceVersions = this.getLinkedIssuePdServiceVersions();
        List other$linkedIssuePdServiceVersions = other.getLinkedIssuePdServiceVersions();
        if (this$linkedIssuePdServiceVersions == null ? other$linkedIssuePdServiceVersions != null : !((Object)this$linkedIssuePdServiceVersions).equals(other$linkedIssuePdServiceVersions)) {
            return false;
        }
        List this$linkedIssues = this.getLinkedIssues();
        List other$linkedIssues = other.getLinkedIssues();
        if (this$linkedIssues == null ? other$linkedIssues != null : !((Object)this$linkedIssues).equals(other$linkedIssues)) {
            return false;
        }
        String this$jira_server_id = this.getJira_server_id();
        String other$jira_server_id = other.getJira_server_id();
        if (this$jira_server_id == null ? other$jira_server_id != null : !this$jira_server_id.equals(other$jira_server_id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$parentReqKey = this.getParentReqKey();
        String other$parentReqKey = other.getParentReqKey();
        if (this$parentReqKey == null ? other$parentReqKey != null : !this$parentReqKey.equals(other$parentReqKey)) {
            return false;
        }
        String this$upperKey = this.getUpperKey();
        String other$upperKey = other.getUpperKey();
        if (this$upperKey == null ? other$upperKey != null : !this$upperKey.equals(other$upperKey)) {
            return false;
        }
        String this$issueID = this.getIssueID();
        String other$issueID = other.getIssueID();
        if (this$issueID == null ? other$issueID != null : !this$issueID.equals(other$issueID)) {
            return false;
        }
        String this$self = this.getSelf();
        String other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Object this$etc = this.getEtc();
        Object other$etc = other.getEtc();
        if (this$etc == null ? other$etc != null : !this$etc.equals(other$etc)) {
            return false;
        }
        List this$percolatorQueries = this.getPercolatorQueries();
        List other$percolatorQueries = other.getPercolatorQueries();
        if (this$percolatorQueries == null ? other$percolatorQueries != null : !((Object)this$percolatorQueries).equals(other$percolatorQueries)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        IssueType this$issuetype = this.getIssuetype();
        IssueType other$issuetype = other.getIssuetype();
        if (this$issuetype == null ? other$issuetype != null : !this$issuetype.equals(other$issuetype)) {
            return false;
        }
        Creator this$creator = this.getCreator();
        Creator other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Reporter this$reporter = this.getReporter();
        Reporter other$reporter = other.getReporter();
        if (this$reporter == null ? other$reporter != null : !this$reporter.equals(other$reporter)) {
            return false;
        }
        Assignee this$assignee = this.getAssignee();
        Assignee other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        List this$labels = this.getLabels();
        List other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Priority this$priority = this.getPriority();
        Priority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        \uc0c1\ud0dc this$status = this.getStatus();
        \uc0c1\ud0dc other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$armsStateCategory = this.getArmsStateCategory();
        String other$armsStateCategory = other.getArmsStateCategory();
        if (this$armsStateCategory == null ? other$armsStateCategory != null : !this$armsStateCategory.equals(other$armsStateCategory)) {
            return false;
        }
        Resolution this$resolution = this.getResolution();
        Resolution other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) {
            return false;
        }
        String this$resolutiondate = this.getResolutiondate();
        String other$resolutiondate = other.getResolutiondate();
        if (this$resolutiondate == null ? other$resolutiondate != null : !this$resolutiondate.equals(other$resolutiondate)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Date this$updated = this.getUpdated();
        Date other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Date this$overallUpdatedDate = this.getOverallUpdatedDate();
        Date other$overallUpdatedDate = other.getOverallUpdatedDate();
        if (this$overallUpdatedDate == null ? other$overallUpdatedDate != null : !((Object)this$overallUpdatedDate).equals(other$overallUpdatedDate)) {
            return false;
        }
        Deleted this$deleted = this.getDeleted();
        Deleted other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !this$deleted.equals(other$deleted)) {
            return false;
        }
        List this$worklogs = this.getWorklogs();
        List other$worklogs = other.getWorklogs();
        if (this$worklogs == null ? other$worklogs != null : !((Object)this$worklogs).equals(other$worklogs)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        CReqProperty this$cReqProperty = this.getCReqProperty();
        CReqProperty other$cReqProperty = other.getCReqProperty();
        return !(this$cReqProperty == null ? other$cReqProperty != null : !this$cReqProperty.equals(other$cReqProperty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlmIssueEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isReq = this.getIsReq();
        result = result * 59 + ($isReq == null ? 43 : ((Object)$isReq).hashCode());
        Long $cReqLink = this.getCReqLink();
        result = result * 59 + ($cReqLink == null ? 43 : ((Object)$cReqLink).hashCode());
        Long $cReqStatusId = this.getCReqStatusId();
        result = result * 59 + ($cReqStatusId == null ? 43 : ((Object)$cReqStatusId).hashCode());
        Long $pdServiceId = this.getPdServiceId();
        result = result * 59 + ($pdServiceId == null ? 43 : ((Object)$pdServiceId).hashCode());
        Integer $timespent = this.getTimespent();
        result = result * 59 + ($timespent == null ? 43 : ((Object)$timespent).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $recentId = this.getRecentId();
        result = result * 59 + ($recentId == null ? 43 : $recentId.hashCode());
        List $pdServiceVersions = this.getPdServiceVersions();
        result = result * 59 + ($pdServiceVersions == null ? 43 : ((Object)$pdServiceVersions).hashCode());
        List $linkedIssuePdServiceIds = this.getLinkedIssuePdServiceIds();
        result = result * 59 + ($linkedIssuePdServiceIds == null ? 43 : ((Object)$linkedIssuePdServiceIds).hashCode());
        List $linkedIssuePdServiceVersions = this.getLinkedIssuePdServiceVersions();
        result = result * 59 + ($linkedIssuePdServiceVersions == null ? 43 : ((Object)$linkedIssuePdServiceVersions).hashCode());
        List $linkedIssues = this.getLinkedIssues();
        result = result * 59 + ($linkedIssues == null ? 43 : ((Object)$linkedIssues).hashCode());
        String $jira_server_id = this.getJira_server_id();
        result = result * 59 + ($jira_server_id == null ? 43 : $jira_server_id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $parentReqKey = this.getParentReqKey();
        result = result * 59 + ($parentReqKey == null ? 43 : $parentReqKey.hashCode());
        String $upperKey = this.getUpperKey();
        result = result * 59 + ($upperKey == null ? 43 : $upperKey.hashCode());
        String $issueID = this.getIssueID();
        result = result * 59 + ($issueID == null ? 43 : $issueID.hashCode());
        String $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Object $etc = this.getEtc();
        result = result * 59 + ($etc == null ? 43 : $etc.hashCode());
        List $percolatorQueries = this.getPercolatorQueries();
        result = result * 59 + ($percolatorQueries == null ? 43 : ((Object)$percolatorQueries).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        IssueType $issuetype = this.getIssuetype();
        result = result * 59 + ($issuetype == null ? 43 : $issuetype.hashCode());
        Creator $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Reporter $reporter = this.getReporter();
        result = result * 59 + ($reporter == null ? 43 : $reporter.hashCode());
        Assignee $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        List $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Priority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        \uc0c1\ud0dc $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $armsStateCategory = this.getArmsStateCategory();
        result = result * 59 + ($armsStateCategory == null ? 43 : $armsStateCategory.hashCode());
        Resolution $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
        String $resolutiondate = this.getResolutiondate();
        result = result * 59 + ($resolutiondate == null ? 43 : $resolutiondate.hashCode());
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Date $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Date $overallUpdatedDate = this.getOverallUpdatedDate();
        result = result * 59 + ($overallUpdatedDate == null ? 43 : ((Object)$overallUpdatedDate).hashCode());
        Deleted $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : $deleted.hashCode());
        List $worklogs = this.getWorklogs();
        result = result * 59 + ($worklogs == null ? 43 : ((Object)$worklogs).hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        CReqProperty $cReqProperty = this.getCReqProperty();
        result = result * 59 + ($cReqProperty == null ? 43 : $cReqProperty.hashCode());
        return result;
    }
}

