/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.almapi.strategy;

import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.AlmIssueVOCollection;
import com.arms.api.issue.almapi.service.AlmIssueToEntityConverter;
import com.arms.api.util.alm.AlmDiscoveryDate;
import com.arms.api.util.msa_communicate.BackendCoreClient;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.google.common.base.Function;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IssueSaveTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssueSaveTemplate.class);
    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;
    private final AlmDiscoveryDate almDiscoveryDate;
    private final BackendCoreClient backendCoreClient;

    public List<AlmIssueEntity> discoveryIncrementALmIssueAndGetReqAlmIssueEntities(@Valid AlmIssueIncrementDTO almIssueIncrementDTO, Function<AlmIssueIncrementDTO, AlmIssueVOCollection> discoveryIssueAndGetReqEntitiesFunction) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        log.info("almDiscoveryDate getStartDate: {} ", (Object)this.almDiscoveryDate.getStartDate());
        log.info("almDiscoveryDate getDateRange: {} ", (Object)this.almDiscoveryDate.getDateRange());
        LocalDate startDate = LocalDate.parse(Optional.ofNullable(almIssueIncrementDTO.getStartDate()).orElseGet(() -> ((AlmDiscoveryDate)this.almDiscoveryDate).getStartDate()), formatter);
        LocalDate endDate = LocalDate.parse(almIssueIncrementDTO.getEndDate(), formatter);
        LocalDate currentStart = startDate;
        ArrayList<AlmIssueEntity> requirementAlmIssueEntities = new ArrayList<AlmIssueEntity>();
        while (!currentStart.isAfter(endDate)) {
            LocalDate currentEnd = currentStart.plusDays(this.almDiscoveryDate.getDateRange());
            if (currentEnd.isAfter(endDate)) {
                currentEnd = endDate;
            }
            AlmIssueIncrementDTO dynamicIncrementDto = AlmIssueIncrementDTO.builder().serverId(almIssueIncrementDTO.getServerId()).projectKey(almIssueIncrementDTO.getProjectKey()).startDate(String.valueOf(currentStart)).endDate(String.valueOf(currentEnd)).build();
            this.backendCoreClient.sendMessage(String.format("\uc218\uc9d1 \uc694\uccad::%s::%s ~ %s::", almIssueIncrementDTO.getProjectKey(), currentStart, currentEnd));
            requirementAlmIssueEntities.addAll(this.discoveryIncrementALmIssueAndGetReqAlmIssueEntities((AlmIssueVOCollection)discoveryIssueAndGetReqEntitiesFunction.apply((Object)dynamicIncrementDto)));
            currentStart = currentEnd.plusDays(1L);
        }
        return requirementAlmIssueEntities;
    }

    private List<AlmIssueEntity> discoveryIncrementALmIssueAndGetReqAlmIssueEntities(AlmIssueVOCollection almIssueVOCollection) {
        List requirementAlmIssueEntities = AlmIssueToEntityConverter.discoveryRequirementIssue((AlmIssueVOCollection)almIssueVOCollection).almIssueEntities();
        this.saveEntities(requirementAlmIssueEntities);
        List noneRequirementAlmIssueEntities = AlmIssueToEntityConverter.discoveryNoneRequirementIssue((AlmIssueVOCollection)almIssueVOCollection).almIssueEntities();
        this.saveEntities(noneRequirementAlmIssueEntities);
        return requirementAlmIssueEntities;
    }

    private void saveEntities(List<AlmIssueEntity> almIssueList) {
        almIssueList.forEach(arg_0 -> ((EsCommonRepositoryWrapper)this.esCommonRepositoryWrapper).save(arg_0));
        List<AlmIssueEntity> almIssueEntities = almIssueList.stream().filter(a -> a.izReqFalse() && a.getKey() != null).toList();
        for (AlmIssueEntity almIssueEntity : almIssueEntities) {
            AlmIssueEntity almIssueEntityByUpperKey = (AlmIssueEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)almIssueEntity.recentIdByNewKey(almIssueEntity.getUpperKey())));
            while (almIssueEntity.isNeedOverallUpdatedDate(almIssueEntityByUpperKey)) {
                almIssueEntityByUpperKey.setOverallUpdatedDate(almIssueEntity.getOverallUpdatedDate());
                this.esCommonRepositoryWrapper.save((BaseEntity)almIssueEntityByUpperKey);
                almIssueEntityByUpperKey = (AlmIssueEntity)this.esCommonRepositoryWrapper.findRecentDocByRecentId((Serializable)((Object)almIssueEntityByUpperKey.recentIdByNewKey(almIssueEntityByUpperKey.getUpperKey())));
            }
        }
    }

    @Generated
    public IssueSaveTemplate(EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper, AlmDiscoveryDate almDiscoveryDate, BackendCoreClient backendCoreClient) {
        this.esCommonRepositoryWrapper = esCommonRepositoryWrapper;
        this.almDiscoveryDate = almDiscoveryDate;
        this.backendCoreClient = backendCoreClient;
    }
}

