/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.issue.status.strategy;

import com.arms.api.issue.status.dto.CloudJiraByIssueTypeIssueStatusDTO;
import com.arms.api.issue.status.dto.IssueStatusCategoryDTO;
import com.arms.api.issue.status.dto.IssueStatusDTO;
import com.arms.api.issue.status.strategy.IssueStatusStrategy;
import com.arms.api.issue.status.vo.CloudJiraByIssueTypeIssueStatusVO;
import com.arms.api.issue.status.vo.IssueStatusCategoryVO;
import com.arms.api.issue.status.vo.IssueStatusVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.api.util.errors.ErrorLogUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class CloudJiraIssueStatusStrategy
implements IssueStatusStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJiraIssueStatusStrategy.class);
    private final JiraUtil jiraUtil;
    private final JiraApi jiraApi;
    private final ServerInfoService serverInfoService;

    public List<IssueStatusVO> getIssueStatusList(ServerInfo serverInfo) {
        return null;
    }

    public List<CloudJiraByIssueTypeIssueStatusVO> getIssueStatusListByProject(ServerInfo serverInfo, String projectId) {
        String endpoint = this.jiraApi.getEndpoint().getProject() + "/" + projectId + "/statuses";
        WebClient webClient = this.jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), this.serverInfoService.getDecryptPasswordOrToken(serverInfo));
        try {
            List issueStatusList = (List)this.jiraUtil.get(webClient, endpoint, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).block();
            return Optional.ofNullable(issueStatusList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(arg_0 -> this.convertCloudJiraByIssueTypeIssueStatusVO(arg_0)).collect(Collectors.toList());
        }
        catch (Exception e) {
            String errorMessage = ErrorLogUtil.exceptionLoggingAndReturn((Exception)e, (String)this.getClass().getName(), (String)String.format("%s[%s] :: getIssueStatusListByProject Error :: projectId[%s]", serverInfo.getType(), serverInfo.getUri(), projectId));
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private CloudJiraByIssueTypeIssueStatusVO convertCloudJiraByIssueTypeIssueStatusVO(CloudJiraByIssueTypeIssueStatusDTO cloudJiraByIssueTypeIssueStatusDTO) {
        return CloudJiraByIssueTypeIssueStatusVO.builder().self(cloudJiraByIssueTypeIssueStatusDTO.getSelf()).id(cloudJiraByIssueTypeIssueStatusDTO.getId()).name(cloudJiraByIssueTypeIssueStatusDTO.getName()).subtask(cloudJiraByIssueTypeIssueStatusDTO.isSubtask()).statuses(this.convertIssueStatusVOList(cloudJiraByIssueTypeIssueStatusDTO.getStatuses())).build();
    }

    private List<IssueStatusVO> convertIssueStatusVOList(List<IssueStatusDTO> issueStatusDTOList) {
        return Optional.ofNullable(issueStatusDTOList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(arg_0 -> this.converIssueStatusVO(arg_0)).collect(Collectors.toList());
    }

    private IssueStatusVO converIssueStatusVO(IssueStatusDTO issueStatusDTO) {
        return IssueStatusVO.builder().self(issueStatusDTO.getSelf()).id(issueStatusDTO.getId()).name(issueStatusDTO.getName()).description(issueStatusDTO.getDescription()).issueTypeId(issueStatusDTO.getIssueTypeId()).statusCategory((IssueStatusCategoryVO)Optional.ofNullable(issueStatusDTO.getStatusCategory()).map(arg_0 -> this.convertIssueStatusCategoryVO(arg_0)).orElse(null)).build();
    }

    private IssueStatusCategoryVO convertIssueStatusCategoryVO(IssueStatusCategoryDTO issueStatusCategoryDTO) {
        return IssueStatusCategoryVO.builder().self(issueStatusCategoryDTO.getSelf()).id(issueStatusCategoryDTO.getId()).name(issueStatusCategoryDTO.getName()).key(issueStatusCategoryDTO.getKey()).colorName(issueStatusCategoryDTO.getColorName()).build();
    }

    @Generated
    public CloudJiraIssueStatusStrategy(JiraUtil jiraUtil, JiraApi jiraApi, ServerInfoService serverInfoService) {
        this.jiraUtil = jiraUtil;
        this.jiraApi = jiraApi;
        this.serverInfoService = serverInfoService;
    }
}

